<?php
/**
 * The template for displaying content of archive page meetings
 *
 * This template can be overridden by copying it to yourtheme/video-conferencing-zoom/content-meeting.php.
 *
 * @author Deepen
 * @since 3.0.0
 */

defined( 'ABSPATH' ) || exit;

?>
<div class="post">
    <div id="dpn-zvc-<?php the_ID(); ?>" class="dpn-zvc-<?php the_ID(); ?>">
         <?php if(has_post_thumbnail()): ?>  
            <div class="post-media post-image"> 
                <a href="<?php echo esc_url(get_the_permalink()); ?>">
                    <img class="img-fluid" src="<?php echo esc_url(get_the_post_thumbnail_url()); ?>" alt=" <?php the_title_attribute(); ?>">
                </a> 
            </div>
        <?php endif; ?>
        <div class="post-body clearfix">
            <div class="entry-header">
                <?php turitor_post_meta(); ?>
                <h2 class="entry-title">
                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </h2>
            </div>
            
            <div class="post-content">
                <div class="entry-content">
                    <p>
                        <?php turitor_excerpt( 40, null ); ?>
                    </p>
                </div>
                <?php
                    if(!is_single()):
                        printf('<div class="post-footer readmore-btn-area"><a class="readmore" href="%1$s">%2$s <i class="tsicon tsicon-arrow-right"></i></a></div>',
                        esc_url(get_the_permalink()), esc_html__('Continue', 'turitor'));
                     endif;  
                ?>
            </div>
        
        </div>
        <!-- post-body end-->
        
    </div>
</div>



