<?php 
function tutor_course_function($atts, $content, $tag)
{

    $mytextdomain = wp_get_theme()->get( 'TextDomain' );
    global $wp_query;
    $top_filter_bar = get_theme_mod('top_filter_bar', true);
    $column = get_theme_mod('course_column_count', 4);
   
    $atts = extract(shortcode_atts(array(
        'top_filter' => $top_filter_bar,
        'column' => $column,
    ), $atts, $tag
    ));
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

    $selected_cat = !empty($_GET['course_category']) ? (array) $_GET['course_category'] : array();
    $args = array(
        'post_type' => tutor()->course_post_type,
        'post_status' => 'publish',
        'paged' => $paged,
        'order'=> 'desc',
        's' => get_search_query(),
    );

    $course_filter = 'newest_first';
    if (!empty($_GET['tutor_course_filter'])) {
        $course_filter = sanitize_text_field($_GET['tutor_course_filter']);
    }
    switch ($course_filter) {
        case 'newest_first':
            $args['orderby'] = 'ID';
            $args['order'] = 'desc';
            break;
        case 'oldest_first':
            $args['orderby'] = 'ID';
            $args['order'] = 'asc';
            break;
        case 'course_title_az':
            $args['orderby'] = 'post_title';
            $args['order'] = 'asc';
            break;
        case 'course_title_za':
            $args['orderby'] = 'post_title';
            $args['order'] = 'desc';
            break;
    }

    $q = new WP_Query($args);
    ob_start();?>
    <?php if ($top_filter) {?>
        <div class="tutor-course-filter-wrap row align-items-center">
            <div class="tutor-course-archive-results-wrap col">
            <?php
            $courseCount = tutor_utils()->get_archive_page_course_count();
            printf(__('%s Courses', 'turitor'), "<strong>{$q->post_count}</strong>");
        ?>
            </div>
            <div class="archive-course-filter col-auto">
                <div class="turitor-course-order">
                    <form class="tutor-course-filter-form" method="get">
                        <select name="tutor_course_filter" class="small">
                            <option value="0"><?php echo esc_html__("Select Order", 'turitor');?></option>
                            <option value="newest_first" <?php if (isset($_GET["tutor_course_filter"]) ? selected("newest_first", $_GET["tutor_course_filter"]) : "");?> ><?php esc_html_e("Release Date (newest first)", 'turitor');?></option>
                            <option value="oldest_first" <?php if (isset($_GET["tutor_course_filter"]) ? selected("oldest_first", $_GET["tutor_course_filter"]) : "");?>><?php esc_html_e("Release Date (oldest first)", 'turitor');?></option>
                            <option value="course_title_az" <?php if (isset($_GET["tutor_course_filter"]) ? selected("course_title_az", $_GET["tutor_course_filter"]) : "");?>><?php esc_html_e("Course Title (a-z)", 'turitor');?></option>
                            <option value="course_title_za" <?php if (isset($_GET["tutor_course_filter"]) ? selected("course_title_za", $_GET["tutor_course_filter"]) : "");?>><?php esc_html_e("Course Title (z-a)", 'turitor');?></option>
                        </select>
                    </form>
                </div>
            </div>
        </div>
    <?php }?>
    <div class="tutor-courses-wrap tutor-course-style3 row">
        <?php
        if ($q->have_posts()) {
                while ($q->have_posts()) {
                    $q->the_post();
                    $idd = get_the_ID();
                    global $authordata;
                    $profile_url = tutor_utils()->profile_url($authordata->ID);
                    $course_categories = get_tutor_course_categories();
                    $cat_color ='';

                    if(is_array($course_categories) && count($course_categories)){
                        foreach ($course_categories as $course_category){
                            $cat_color = turitor_term_meta_option($course_category->term_id, 'course-category','tutor_course_cat_color');
                        }
                     } 
                    ?>
                    <div class="col-lg-<?php echo $column; ?> col-sm-6 mb-30">
                        <div class="single-course-item course-grid-style2" style="--course-color: <?php echo esc_attr($cat_color);?>">
                            <div class="single-course">
                                    <div class="course-thumb">
                                        <?php tutor_course_loop_thumbnail();?>
                                    </div>
                                    <div class="course-title-area">
                                        <div class="course-category normal">
                                            <?php
                                            $course_categories = get_tutor_course_categories();
                                            if(is_array($course_categories) && count($course_categories)){
                                                ?>
                                                <?php
                                                    foreach ($course_categories as $course_category){
                                                        $category_name = $course_category->name;
                                                        $category_link = get_term_link($course_category->term_id);
                                                        echo "<a href='$category_link' style='background-color:  $cat_color;'>$category_name</a>";
                                                    }
                                                ?>
                                                
                                            <?php } ?>
                                        </div><!-- end category --> 
                                        <h3 class="ts-course-el-title">
                                            <a href="<?php the_permalink();?>">
                                                <?php echo get_the_title(); ?>
                                            </a>
                                        </h3><!-- end title --> 

                                    </div> <!-- end title area -->
                                    <div class="course-footer style2">
                                        <div class="xs-ratting-content">
                                            <?php $course_rating = tutor_utils()->get_course_rating();?>
                                            <div class="tutor-loop-rating-wrap">
                                                <?php tutor_utils()->star_rating_generator($course_rating->rating_avg);?>
                                            </div>
                                        </div><!-- ratting end --> 
                                    <div class="course-price-item">
                                        <div class="tutor-course-loop-price">
                                            <?php
                                            $course_id = get_the_ID();
                                            $price_html = '<span class="amount">'.__('Free', 'tutor').'</span>';
                                            if (tutor_utils()->is_course_purchasable()) {
                                                $product_id = tutor_utils()->get_course_product_id($course_id);
                                                $product    = wc_get_product( $product_id );
                                                if ( $product ) {
                                                    $price_html = '<div class="turitor-course-pricess"> '.$product->get_price_html() . '</div> ';
                                                }
                                            }
                                                echo $price_html;
                                            ?>
                                            </div>
                                        </div><!-- price item --> 
                                    </div><!-- end course-footer -->
                                    <div class="single-course hover">
                                        <div class="course-category">
                                            <?php
                                            $course_categories = get_tutor_course_categories();
                                            if(is_array($course_categories) && count($course_categories)){
                                                ?>
                                                    <?php
                                                            foreach ($course_categories as $course_category){
                                                                $category_name = $course_category->name;
                                                                $category_link = get_term_link($course_category->term_id);
                                                                echo "<a href='$category_link'>$category_name</a>";
                                                            }
                                                    ?>
                                                
                                            <?php } ?>
                                        </div><!-- end category --> 

                                        <h3 class="ts-course-el-title">
                                            <a href="<?php the_permalink();?>">
                                                <?php echo get_the_title(); ?>
                                            </a>
                                        </h3><!-- end title --> 
                                        <div class="enrol-list-area">
                                            <div class="instructor">
                                                <a href="<?php echo esc_url($profile_url); ?>" class="tutor-course-author"><?php the_author();?></a>
                                            </div>
                                        </div><!-- end author -->
                                        <div class="excerpt-content">
                                            <p>
                                                <?php echo turitor_excerpt(18, ''); ?>
                                            </p>
                                        </div><!-- excerpt -->
                                    </div><!-- course hover -->
                            </div>
                        </div>
                    </div>
                <?php }
            } else {
                ?>

                <div class="col-12">
                    <?php
                        echo "<h2>" . __('Nothing found!', 'turitor') . "</h2>";
                        echo "<div>" . __('Sorry, but nothing matched your search terms. Please try again with different keywords.', 'turitor') . "</div>";
                    ?>
                </div>

                <?php
            }

            ?>
    </div>
    <?php

    wp_reset_query();
    $output = ob_get_contents();
    ob_end_clean();
    echo $output;
}

add_shortcode('tutor-course', 'tutor_course_function'); ?>

<div id="main-content" class="archive-course-container">
    <div class="container">
        <?php
            do_shortcode('[tutor-course]');
        ?>
    </div>
</div>
