<?php 
function tutor_course_function($atts, $content, $tag)
{

    $mytextdomain = wp_get_theme()->get( 'TextDomain' );
    global $wp_query;
    $sidebar_filter = get_theme_mod('sidebar_filter', true);
    $top_filter_bar = get_theme_mod('top_filter_bar', true);
    $course_column_count = get_theme_mod('course_column_count', 3);
    $course_category_count = get_theme_mod('course_category_count', 1);
    $course_sidebar_position = get_theme_mod('course_sidebar_position', 'left');

    $atts = extract(shortcode_atts(array(
        'sidebar' => $sidebar_filter,
        'top_filter' => $top_filter_bar,
        'column' => $course_column_count,
        'category_count' => $course_category_count,
        'sidebar_position' => $course_sidebar_position,
    ), $atts, $tag
    ));

    if ($sidebar === 'false' || $sidebar === 0) {
        $sidebar = false;
    }

    switch ($column) {
        case 1:
            $column = 12;
            break;
        case 2:
            $column = 6;
            break;
        case 3:
            $column = 4;
            break;
        case 4:
            $column = 3;
            break;
        case 6:
            $column = 2;
            break;
        case 12:
            $column = 1;
            break;
        default:
            $column = 3;
    }

    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

    $selected_cat = !empty($_GET['course_category']) ? (array) $_GET['course_category'] : array();
    $selected_cat = array_map('sanitize_text_field', $selected_cat);
    $selected_cat = array_map('intval', $selected_cat);
    $is_queried_object = false;
    if (isset($wp_query->queried_object->term_id)) {
        $is_queried_object = true;
        $selected_cat = array($wp_query->queried_object->term_id);
    }

    $selected_tag = !empty($_GET['course_tag']) ? (array) $_GET['course_tag'] : array();
    $selected_tag = array_map('sanitize_text_field', $selected_tag);
    $selected_tag = array_map('intval', $selected_tag);

    $selected_level = !empty($_GET['course_level']) ? (array) $_GET['course_level'] : array('all_levels');
    $selected_level = array_map('sanitize_text_field', $selected_level);

    $course_terms_cat = get_terms(array(
        'taxonomy' => 'course-category',
        'hide_empty' => true,
        'parent' => 0,
    ));

    $course_terms_tag = get_terms(array(
        'taxonomy' => 'course-tag',
        'hide_empty' => true,
    ));

    $course_levels = tutor_utils()->course_levels();

    $course_level_filter = !empty($selected_level) && !in_array('all_levels', $selected_level) ? array(
        'key' => '_tutor_course_level',
        'value' => $selected_level,
        'compare' => 'IN',
    ) : array();

    $args = array(
        'post_type' => tutor()->course_post_type,
        'post_status' => 'publish',
        'paged' => $paged,
        's' => get_search_query(),
        'meta_query' => array(
            $course_level_filter,
        ),
        'tax_query' => array(
            'relation' => 'OR',
            array(
                'taxonomy' => 'course-category',
                'field' => 'term_id',
                'terms' => $selected_cat,
                'operator' => !empty($selected_cat) ? 'IN' : 'NOT IN',
            ),
            array(
                'taxonomy' => 'course-tag',
                'field' => 'term_id',
                'terms' => $selected_tag,
                'operator' => !empty($selected_tag) ? 'IN' : 'NOT IN',
            ),
        ),
    );

    $course_filter = 'newest_first';
    if (!empty($_GET['tutor_course_filter'])) {
        $course_filter = sanitize_text_field($_GET['tutor_course_filter']);
    }
    switch ($course_filter) {
        case 'newest_first':
            $args['orderby'] = 'ID';
            $args['order'] = 'desc';
            break;
        case 'oldest_first':
            $args['orderby'] = 'ID';
            $args['order'] = 'asc';
            break;
        case 'course_title_az':
            $args['orderby'] = 'post_title';
            $args['order'] = 'asc';
            break;
        case 'course_title_za':
            $args['orderby'] = 'post_title';
            $args['order'] = 'desc';
            break;
    }

    $q = new WP_Query($args);
    ob_start();?>
    <?php if ($top_filter) {?>
        <div class="tutor-course-filter-wrap row align-items-center">
            <div class="tutor-course-archive-results-wrap col">
                <?php
$courseCount = tutor_utils()->get_archive_page_course_count();
        printf(__('%s Courses', 'turitor'), "<strong>{$q->post_count}</strong>");
        ?>
            </div>
            <div class="archive-course-filter col-auto">
                <div class="turitor-course-order">
                    <form class="tutor-course-filter-form" method="get">
                        <select name="tutor_course_filter" class="small">
                            <option value="0"><?php echo esc_html__("Select Order", 'turitor');?></option>
                            <option value="newest_first" <?php if (isset($_GET["tutor_course_filter"]) ? selected("newest_first", $_GET["tutor_course_filter"]) : "");?> ><?php esc_html_e("Release Date (newest first)", 'turitor');?></option>
                            <option value="oldest_first" <?php if (isset($_GET["tutor_course_filter"]) ? selected("oldest_first", $_GET["tutor_course_filter"]) : "");?>><?php esc_html_e("Release Date (oldest first)", 'turitor');?></option>
                            <option value="course_title_az" <?php if (isset($_GET["tutor_course_filter"]) ? selected("course_title_az", $_GET["tutor_course_filter"]) : "");?>><?php esc_html_e("Course Title (a-z)", 'turitor');?></option>
                            <option value="course_title_za" <?php if (isset($_GET["tutor_course_filter"]) ? selected("course_title_za", $_GET["tutor_course_filter"]) : "");?>><?php esc_html_e("Course Title (z-a)", 'turitor');?></option>
                        </select>
                    </form>
                </div>
            </div>
        </div>
    <?php }?>
    <div class="row">
        <?php if ($sidebar): ?>

            <?php
                $current_url = get_post_type_archive_link('course');
            ?>
            <div class="col-12 col-md-4 col-lg-3 order-2 order-sm-<?php echo $sidebar_position == 'right' ? 2 : 1; ?> mb-4 md-lg-0">
                <div class="course-sidebar">
                    <form class="tutor-sidebar-filter tutor-course-filter-form" action="<?php echo esc_url($current_url); ?>" method="get">
                        <input type="hidden" name="s" value="<?php echo get_search_query(); ?>">


                        <div class="archive-category-filter-area archive-widgets single-filter">
                            <h3 class="widget-title"><?php esc_html_e('Level', 'turitor');?></h3>
                            <?php
                            foreach ($course_levels as $key => $course_level) {
                                if ($key == 'all_levels') {
                                    continue;
                                }
                                ?>
                                <label for="<?php echo esc_attr($key); ?>">
                                    <input
                                        type="checkbox"
                                        name="course_level[]"
                                        value="<?php echo esc_attr($key); ?>"
                                        id="<?php echo esc_attr($key); ?>"
                                        <?php echo in_array($key, $selected_level) ? 'checked="checked"' : ''; ?>
                                    >
                                    <span class="filter-checkbox"></span>
                                    <?php echo esc_html($course_level); ?>
                                </label>
                                <?php
                            }?>
                        </div>

                        <?php if (is_array($course_terms_cat) && count($course_terms_cat)): ?>
                            <div class="archive-category-filter-area archive-widgets single-filter">
                                <h3 class="widget-title"><?php esc_html_e('Category', 'turitor');?></h3>
                                <?php
                                    foreach ($course_terms_cat as $course_term) {
                                            $childern = get_categories(
                                                array(
                                                    'parent' => $course_term->term_id,
                                                    'taxonomy' => 'course-category',
                                                )
                                                );?>
                                    <div class="tutor-archive-single-cat">
                                        <label for="cat-<?php echo esc_attr($course_term->slug) ?>">
                                            <input
                                                    type="checkbox"
                                                    name="course_category[]"
                                                    value="<?php echo esc_attr($course_term->term_id) ?>"
                                                    id="cat-<?php echo esc_attr($course_term->slug) ?>"
                                                <?php echo in_array($course_term->term_id, $selected_cat) ? 'checked="checked"' : ''; ?>
                                            >
                                            <span class="filter-checkbox"></span>
                                            <?php
                                            echo esc_attr($course_term->name);
                                                    ?>
                                                                                </label>
                                                                                <?php
                                            if (count($childern)) {
                                                        echo "<i class='category-toggle fas fa-plus'></i>";
                                                    }?>
                                        <?php if (count($childern)): ?>
                                            <div class="tutor-archive-childern"  style="display: none;">
                                                <?php foreach ($childern as $child) {?>
                                                    <label for="cat-<?php echo esc_attr($child->slug) ?>">
                                                        <input
                                                                type="checkbox"
                                                                name="course_category[]"
                                                                value="<?php echo esc_attr($child->term_id) ?>"
                                                                id="cat-<?php echo esc_attr($child->slug) ?>"
                                                            <?php echo in_array($child->term_id, $selected_cat) ? 'checked="checked"' : ''; ?>
                                                        >
                                                        <span class="filter-checkbox"></span>
                                                        <?php echo esc_attr($child->name) ?>
                                                    </label>
                                                <?php }?>
                                            </div>
                                        <?php endif;?>
                                    </div>

                                <?php }?>
                            </div>
                        <?php endif;?>

                        <?php if (is_array($course_terms_tag) && count($course_terms_tag)): ?>
                            <div class="archive-category-filter-area archive-widgets single-filter">
                                <h3 class="widget-title"><?php esc_html_e('Topics', 'turitor');?></h3>
                                <?php
                                    foreach ($course_terms_tag as $course_tag) {
                                ?>
                                    <label for="tag-<?php echo esc_attr($course_tag->slug) ?>">
                                        <input
                                            type="checkbox"
                                            name="course_tag[]"
                                            value="<?php echo esc_attr($course_tag->term_id) ?>"
                                            id="tag-<?php echo esc_attr($course_tag->slug) ?>"
                                            <?php echo in_array($course_tag->term_id, $selected_tag) ? 'checked="checked"' : ''; ?>
                                        >
                                        <span class="filter-checkbox"></span>
                                        <?php echo esc_html($course_tag->name) ?>
                                    </label>
                                    <?php
                                        }
                                    ?>
                            </div>
                        <?php endif;?>
                    </form>
                </div><!-- Course sidebar End -->
            </div>
        <?php endif;?>
        <div class="col order-1 order-sm-<?php echo $sidebar_position == 'right' ? 1 : 2; ?>">
            <div class="tutor-courses-wrap row">
                <?php
                if ($q->have_posts()) {
                        while ($q->have_posts()) {
                            $q->the_post();
                            $idd = get_the_ID();
                            global $authordata;
                            $profile_url = tutor_utils()->profile_url($authordata->ID)
                            ?>
                            <div class="col-lg-<?php echo $column; ?> col-sm-6 course-single-wrap archive-course2">
                                <div class="single-course mb-30">
                                    <div class="tutor-course-header">
                                        <div class="course-thumbnail">
                                            <?php tutor_course_loop_thumbnail();?>
                                        </div>
                                        <div class="course-price-item">
                                            <!-- <?php echo tutor_course_loop_price(); ?> -->
                                            <div class="tutor-course-loop-price">
                                            <?php
                                                $course_id = get_the_ID();
                                                $price_html = '<div class="course-price"> <span class="amount">'.esc_html__('Free', 'tutor').'</span>'. '</div>';

                                                if (tutor_utils()->is_course_purchasable()) {
                                                    $product_id = tutor_utils()->get_course_product_id($course_id);
                                                    $product    = wc_get_product( $product_id );
                                                    if ( $product ) {
                                                        $price_html = '<div class="turitor-course-pricess"> '.$product->get_price_html() . '</div> ';
                                                    }
                                                }
                                                echo $price_html;
                                                ?>
                                            </div>

                                        </div>
                                        <div class="course-category">
                                            <?php
                                               $course_categories = get_tutor_course_categories();
                                               if(is_array($course_categories) && count($course_categories)){
                                                   ?>
                                                    <?php
                                                            foreach ($course_categories as $course_category){
                                                                $category_name = $course_category->name;
                                                                $category_link = get_term_link($course_category->term_id);
                                                                echo "<a href='$category_link'>$category_name</a>";
                                                            }
                                                    ?>
                                                  
                                            <?php } ?>
                                        </div>
                                        <h3 class="ts-course-el-title">
                                            <a href="<?php the_permalink();?>">
                                                <?php echo get_the_title(); ?>
                                            </a>
                                        </h3>
                                    </div>
                                    <div class="border-bar"></div>
                                    <div class="course-footer">
                                        <div class="xs-ratting-content">
                                            <?php $course_rating = tutor_utils()->get_course_rating();?>
                                            <div class="tutor-loop-rating-wrap">
                                                <?php tutor_utils()->star_rating_generator($course_rating->rating_avg);?>
                                            </div>
                                        </div><!-- ratting end --> 
                                        <div class="price-btn">
                                            <a href="<?php the_permalink(); ?>" class="btn-link">
                                                <i class="tsicon tsicon-right_arrow"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php }
                    } else {
                        ?>

                        <div class="col-12">
                            <?php
                                echo "<h2>" . esc_html__('Nothing found!', 'turitor') . "</h2>";
                                echo "<div>" . esc_html__('Sorry, but nothing matched your search terms. Please try again with different keywords.', 'turitor') . "</div>";
                            ?>
                        </div>

                        <?php
                    }

                    ?>
            </div>
           
        </div>
    </div>
    <?php

    wp_reset_query();
    $output = ob_get_contents();
    ob_end_clean();
    echo $output;
}

add_shortcode('tutor-course', 'tutor_course_function'); ?>

<div id="main-content" class="main-container archive-course-container">
    <div class="container">
        <?php
            do_shortcode('[tutor-course]');
        ?>
    </div>
</div>
