<?php


if (defined('FW')) {

   $header_settings =  turitor_option('theme_header_default_settings');

   if (isset($header_settings['no'])) {
      // sticky header
      $course_category_en          = $header_settings['no']['course_category_en'];
      $course_search_en            = $header_settings['no']['course_search_en'];

      $turitor_header_nav_sticky   = $header_settings['no']['header_nav_sticky'];
      $turitor_shop_btn_show       = $header_settings['no']['shop_btn_show'];
      $author_btn_show             = $header_settings['no']['author_btn_show'];
      $author_url_link             = (isset($header_settings['no']['author_url_link']) ? $header_settings['no']['author_url_link'] : '');
      // of canvas 
      $header_offcanvas_settings   = $header_settings['no']['header_offcanvas_settings'];
      $header_offcanvas_show       = $header_offcanvas_settings['header_offcanvas_show'];
   }
} else {

   $turitor_shop_btn_show     = 'no';
   $turitor_header_nav_sticky = 'no';
   //  offcanvas 
   $header_offcanvas_show     = 'no';
   $author_btn_show           = 'no';
   $author_url_link           = '#';
   $course_search_en          = 'no';
   $course_category_en        = 'no';
}


$profile_url = '';

if (isset($author_url_link) && $author_url_link != '') {
   $profile_url = $author_url_link;
}

?>

<!-- header nav start-->
<div class="header-wrapper">
   <header id="header" class="header header-standard  <?php echo esc_attr($turitor_header_nav_sticky == 'yes' ? 'navbar-sticky' : ''); ?>">
      <!-- navbar container start -->
      <div class="navbar-container">
         <div class="container-fluid">
            <div class="row">
               <div class="col-lg-2 col-md-3 align-self-center">
                  <div class="header-logo-area">
                     <div class="nav-logo">
                        <a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>">
                           <img src="<?php
                                       echo esc_url(
                                          turitor_src(
                                             'general_main_logo',
                                             TURITOR_IMG . '/logo/logo.png'
                                          )
                                       );
                                       ?>" alt="<?php bloginfo('name'); ?>">
                        </a>
                     </div>
                  </div>
               </div>
               <div class="col-lg-3 col-md-4 align-self-center">
                  <div class="media header-cd-area">
                     <?php if (defined('FW')  && $course_category_en == "yes") {  ?>
                        <div class="header-cd-menu">
                           <div class="header-cd-menu-item">
                              <i class="tsicon tsicon-humburger_2"></i>
                              <?php echo esc_html__("Categories", 'turitor'); ?>
                           </div>

                           <?php if (defined('FW')) : ?>
                              <?php get_template_part('template-parts/navigations/nav', 'category'); ?>
                           <?php endif; ?>
                        </div>
                     <?php } ?>
                     <?php if (defined('FW')  && $course_search_en == "yes") {  ?>
                        <div class="header-search">
                           <?php echo get_search_form(); ?>
                        </div>
                     <?php } ?>
                  </div>
               </div>
               <div class="col-lg-7 col-md-5">
                  <nav class="navbar navbar-expand-lg navbar-light">
                     <a class="navbar-brand d-none" href="<?php echo esc_url(home_url('/')); ?>">
                        <img src="<?php
                                    echo esc_url(
                                       turitor_src(
                                          'general_main_logo',
                                          TURITOR_IMG . '/logo/logo.png'
                                       )
                                    );
                                    ?>" alt="<?php bloginfo('name'); ?>">
                     </a>
                     <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#primary-nav" aria-controls="primary-nav" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"><i class="tsicon tsicon-menu"></i></span>
                     </button>
                     <?php get_template_part('template-parts/navigations/nav', 'primary'); ?>
                     <!-- collapse end -->
                     <?php if (defined('FW')) : ?>
                        <ul class="header-nav-right-info form-inline">
                           <?php if ($author_btn_show == 'yes') : ?>
                              <li class="header-login-user">
                                 <?php
                                 if (! class_exists('SFWD_LMS') && isset($profile_url) && $profile_url != '') {
                                 ?>
                                    <a href="<?php echo esc_url($profile_url); ?>"><i class="tsicon tsicon-user"></i></a>
                                    <?php
                                 } elseif (function_exists('learn_press_get_page_link')) {
                                    $profile_url = learn_press_get_page_link('profile');

                                    if (is_user_logged_in()) {
                                    ?>
                                       <a href="<?php echo esc_url($profile_url); ?>"><i class="tsicon tsicon-user"></i></a>
                                    <?php
                                    } else {
                                    ?>
                                       <a href="#" data-toggle="modal" data-target="#exampleModalCenter">
                                          <i class="tsicon tsicon-user"></i> 
                                       </a>
                                    <?php
                                    }
                                 } elseif (class_exists('SFWD_LMS')) {
                                    if ( is_user_logged_in()) {
                                    ?>
                                       <a href="<?php echo esc_url($profile_url); ?>" class="ts-d-popup"><i class="tsicon tsicon-user"></i></a>
                                    <?php } else{ ?>
                                       <a href="#" class="ts-login-popup"><i class="tsicon tsicon-user"></i>
                                          <?php do_shortcode("[learndash_login]"); ?>
                                       </a>
                                 <?php
                                 }}


                                 ?>
                              </li>
                           <?php endif; ?>
                           
                           <?php if ($turitor_shop_btn_show == "yes" && defined('LP_COURSE_CPT')) { ?>
                                 <li class="header-cart">
                                    <div class="cart-link">
                                       <a class="cart-contents" href="<?php echo esc_url(learn_press_get_checkout_url()); ?>">
                                          <span class="tsicon tsicon-cart"></span>
                                          <sup> <?php turitor_cart_count(); ?> </sup>
                                       </a>
                                    </div>
                                 </li>
                              <?php } elseif ($turitor_shop_btn_show == "yes" && class_exists('WooCommerce')) { ?>
                                 <li class="header-cart">
                                    <div class="cart-link">
                                       <a class="cart-contents" href="<?php echo wc_get_cart_url(); ?>" title="<?php _e('View your shopping cart', 'turitor'); ?>">
                                          <span class="tsicon tsicon-cart"></span>
                                          <sup><?php echo sprintf(_n('%d item', '%d', WC()->cart->cart_contents_count, 'turitor'), WC()->cart->cart_contents_count); ?></sup>
                                       </a>
                                    </div>
                                 </li>
                           <?php } ?>

                           <!-- off canvas -->
                           <?php if ($header_offcanvas_show == 'yes') : ?>
                              <li class="header-humburger">
                                 <a href="#" class="navSidebar-button">
                                    <i class="tsicon tsicon-menu"></i>
                                 </a>
                              </li>
                           <?php endif; ?>
                        </ul>
                     <?php endif; ?>
                  </nav>
                  <!-- nav end -->
               </div>
            </div>
         </div>
         <!-- container end -->
      </div>
      <!-- navbar contianer end -->
   </header>
</div>

<?php get_template_part('template-parts/navigations/offcanvas', 'menu'); ?>



<!-- Modal -->
<div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
   <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
               <span aria-hidden="true">&times;</span>
            </button>
         </div>
         <div class="modal-body">
            <div class="row">
               <div class="col-lg-6">
                  <div class="lp-login-form turitor-lp-form">
                     <?php echo do_shortcode('[turitor_lp_login_form]'); ?>
                  </div>
               </div>
               <div class="col-lg-6">
                  <div class="lp-reg-form turitor-lp-form">
                     <?php echo do_shortcode('[turitor_lp_register_form]'); ?>
                  </div>
               </div>
            </div>
         </div>

      </div>
   </div>
</div>