<?php
/**
 * Blog Header
 *
 */
 
$turitor_banner_bg	 = $turitor_banner_title = $turitor_banner_subtitle = '';
$turitor_header_style    = 'standard';
 
if ( defined( 'FW' ) ) {
    
    $turitor_banner_settings = turitor_option('shop_banner_settings');
    //Page settings
    $turitor_header_style    = turitor_option('header_layout_style', 'standard');

    $turitor_show = (isset($turitor_banner_settings['show'])) ? $turitor_banner_settings['show'] : 'yes'; 
    $turitor_show_breadcrumb = (isset($turitor_banner_settings['show_breadcrumb'])) ? $turitor_banner_settings['show_breadcrumb'] : 'yes';

    $turitor_banner_title = (isset($turitor_banner_settings['title']) && $turitor_banner_settings['title'] != '') ? 
                        $turitor_banner_settings['title'] : esc_html__('Products','turitor');
    $turitor_single_title = (isset($turitor_banner_settings['single_title']) && $turitor_banner_settings['single_title'] != '') ? 
                        $turitor_banner_settings['single_title'] : esc_html__('Products','turitor');

    $turitor_banner_image = ( is_array($turitor_banner_settings['image']) && $turitor_banner_settings['image']['url'] != '') ? 
                        $turitor_banner_settings['image']['url'] : TURITOR_IMG.'/banner/banner_image.png';

}else{
    $turitor_banner_image =TURITOR_IMG.'/banner/banner_image.png';
    $turitor_banner_title = esc_html__('Shop','turitor');
    $turitor_single_title = esc_html__('Products','turitor');
    $turitor_show = 'yes';
    $turitor_show_breadcrumb = 'yes';
}
if( isset($turitor_banner_image) && $turitor_banner_image != ''){
    $turitor_banner_bg = 'style="background-image:url('.esc_url( $turitor_banner_image ).');"';
}

if(isset($turitor_show) && $turitor_show == 'yes'): ?>

<?php

   $turitor_banner_heading_class = '';

   if( $turitor_header_style=="transparent" ){
      $turitor_banner_heading_class     = "mt-80"; 
   } elseif( $turitor_header_style== 'standard' ){
      $turitor_banner_heading_class     = "mt-80";   
   }
?>

<div id="page-banner-area" class="page-banner-area banner-area" <?php echo wp_kses_post( $turitor_banner_bg ); ?>>
   <!-- Subpage title start -->
   <div class="page-banner-title">
   
      <div class="text-center">
      
         <p class="banner-title <?php echo esc_attr($turitor_banner_heading_class); ?>">
            <?php 
                  if(is_shop()){
                        $shop_title = explode(':',get_the_archive_title() );
                        if(isset($shop_title[1])){
                           echo esc_html($shop_title[1]);
                        }else{
                           echo esc_html($turitor_banner_title);
                        }
                  
                  }elseif(is_product()){
                        echo turitor_kses( $turitor_single_title );
                  }else{
                        echo turitor_kses( $turitor_banner_title );
                  }
            ?>
         </p> 
      
      
         <?php if($turitor_show_breadcrumb == 'yes'): ?>
               <?php woocommerce_breadcrumb(); ?>
         <?php endif; ?>
      </div>
   </div><!-- Subpage title end -->
</div><!-- Page Banner end -->

<?php endif; ?>