<?php 
   $turitor_banner_image    = '';
   $turitor_banner_title    = '';
   $turitor_banner_style    = 'full';
   $turitor_header_style    = 'standard';

   if ( defined( 'FW' ) ) { 

 
      $turitor_banner_settings          = turitor_option('page_banner_setting'); 
      $turitor_banner_image             = turitor_meta_option( get_the_ID(), 'header_image' );
      $turitor_header_style             = turitor_option('header_layout_style', 'standard');
      
   
      //title
      if(turitor_meta_option( get_the_ID(), 'header_title' ) != ''){
         $turitor_banner_title = turitor_meta_option( get_the_ID(), 'header_title' );
      }elseif($turitor_banner_settings['banner_page_title'] != ''){
         $turitor_banner_title = $turitor_banner_settings['banner_page_title'];
      }else{
         $turitor_banner_title   = get_the_title();
      }
      
    
      //image
      if(is_array($turitor_banner_image) && $turitor_banner_image['url'] != '' ){
         $turitor_banner_image = $turitor_banner_image['url'];
      }elseif( is_array($turitor_banner_settings['banner_page_image']) && $turitor_banner_settings['banner_page_image']['url'] != ''){
            $turitor_banner_image = $turitor_banner_settings['banner_page_image']['url'];
      }else{
         
            $turitor_banner_image = TURITOR_IMG.'/banner/banner_image.jpg';
      }
      
      $turitor_show = (isset($turitor_banner_settings['page_show_banner'])) ? $turitor_banner_settings['page_show_banner'] : 'yes'; 
      // breadcumb
      $turitor_show_breadcrumb =  (isset($turitor_banner_settings['page_show_breadcrumb'])) ? $turitor_banner_settings['page_show_breadcrumb'] : 'yes';

   
   }else{
      //default
      $turitor_banner_image             = '';
      $turitor_banner_title             = get_the_title();
      $turitor_show                     = 'yes';
      $turitor_show_breadcrumb          = 'no';

   }
   if( $turitor_banner_image != ''){
      $turitor_banner_image = 'style="background-image:url('.esc_url( $turitor_banner_image ).');"';
   }
   $turitor_banner_heading_class = '';
   if($turitor_header_style=="transparent"):
      $turitor_banner_heading_class     = "mt-80";   
   endif;  

?>

<?php if(isset($turitor_show) && $turitor_show == 'yes'): ?>

     <div class="banner-area <?php echo esc_attr($turitor_banner_image == ''?'banner-solid':'banner-bg'); ?>" <?php echo wp_kses_post( $turitor_banner_image ); ?>>
            <div class="container">
                <div class="row">
                    <div class="col-md-12 text-center">
                        <h2 class="banner-title <?php echo esc_attr($turitor_banner_heading_class); ?>">
                           <?php 
                              if(is_archive()){
                                    the_archive_title();
                              }else{
                                 $turitor_title = str_replace(['{', '}'], ['<span>', '</span>'],$turitor_banner_title ); 
                                 echo wp_kses_post( $turitor_title);
                              }
                           ?> 
                        </h2>
                         <?php if(isset($turitor_show_breadcrumb) && $turitor_show_breadcrumb == 'yes'): ?>
                            <?php turitor_get_breadcrumbs("/"); ?>
                         <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>  
  
<?php endif; ?>   