<?php

      $course_trending     = turitor_option('course_trending','trending_enable');  
      if( $course_trending == 'trending_disable' ){
        return;
      }
      //default settings
      $limit              = 10;
      $course_trending_by = 'features';
      $title              = esc_html__('Feature course','turitor');
      $subtitle           = esc_html__('Feature subtitle','turitor');
      $course_trending_settings = turitor_option('course_trending_settings');
      $course_slider_limit      = 4;
      $course_slider_autoplay   = true;
      $course_slider_nav        = false;
      $course_slider_dot        = true;

      // customizer settings
      if(isset($course_trending_settings['trending_enable'])){

        $trending_settings        = $course_trending_settings['trending_enable'];
        $limit                    = isset($trending_settings['course_trending_limit'])?$trending_settings['course_trending_limit']:10;
        $course_trending_by       = isset($trending_settings['course_trending_by'])?$trending_settings['course_trending_by']:'features';
        $title                    = isset($trending_settings['title'])?$trending_settings['title'] : esc_html__('Feature Course','turitor');
        $subtitle                 = isset($trending_settings['course_trending_sub_label'])?$trending_settings['course_trending_sub_label']:esc_html__('Feature course','turitor');
        $course_slider_limit      = isset($trending_settings['course_slider_limit'])?$trending_settings['course_slider_limit']:4;
        $course_slider_autoplay   = isset($trending_settings['course_slider_autoplay'])?$trending_settings['course_slider_autoplay']:true;
        $course_slider_nav        = isset($trending_settings['course_slider_nav'])?$trending_settings['course_slider_nav']:true;
        $course_slider_dot        = isset($trending_settings['course_slider_dot'])?$trending_settings['course_slider_dot']:true;

      }
 
      $post_in = turitor_course_popular_ids();
      $condition = array(
        'post_type'           => 'lp_course',
        'posts_per_page'      => $limit,
        'ignore_sticky_posts' => true,
      );
      
      if($course_trending_by=='features'){
          $condition['meta_query'] = array(
            array(
              'key'   => '_lp_featured',
              'value' =>  'yes',
            )
          );
      }elseif($course_trending_by == 'popular'){
          if(is_array($post_in)){
            $condition['post__in'] = $post_in;
            $condition['orderby']  = 'post__in';
          }
      }        
    $trending_course = new WP_Query( $condition );
    if ( $trending_course->have_posts() ) : 
?>

      <div class="row">
          <div class="col-md-12">
               <div class="ts-section-title text-center mb-80">
                  <h2 class="section-title"> <?php echo esc_html($title); ?> </h2>
                  <p class="section-subtitle"> <?php echo turitor_kses($subtitle); ?> </p>
               </div>
          </div>
      </div>
      <div data-dot="<?php echo esc_attr($course_slider_dot); ?>" data-nav="<?php echo esc_attr($course_slider_nav); ?>" data-autoplay="<?php echo esc_attr($course_slider_autoplay); ?>" data-count="<?php echo esc_attr($course_slider_limit); ?>" class="turitor_trending_course owl-carousel ts-mix-tab-course"> 
            
                  <?php
                      while ( $trending_course->have_posts() ) : $trending_course->the_post();
                        $terms = get_the_terms( $post->ID, 'course_category' );
                        $cat = '';
                        $cat_with_link = '';
                        
                          if(is_array($terms)):
                
                              foreach($terms as $tkey=>$term):
                                $cat.= $term->slug.' ';
                              endforeach;
                
                          endif; 
                          $cat_with_link = turitor_course_cageory_by_id($post->ID);
                          $course            = LP()->global['course'];
                          $lessons           = $course->get_curriculum_items( 'lp_lesson' )? count( $course->get_curriculum_items( 'lp_lesson' ) ) : 0;
                          $students_enrolled = $course->get_users_enrolled();
                          $instructor        = $course->get_instructor();
                          $instructor_link   = $course->get_instructor_html();
                          $instructor_id     = $course->get_id();
                          $meta              = get_post_meta( $post->ID );
                          $featured          = isset($meta['_lp_featured'][0]) ? $meta['_lp_featured'][0] : '';
                      ?>
                           
                            <div class="single-course">
                                 <div class="course-category">
                                      <?php 
                                           echo wp_kses_post($cat_with_link);
                                      ?> 
                                  </div>
                                  <h3 class="ts-course-el-title"> 
                                    <a href="<?php echo esc_url($course->get_permalink()); ?>">
                                        <?php echo esc_html($post->post_title); ?> 
                                    </a>	
                                  </h3>
                                  <div class="enrol-list-area">
                                    <ul class="course-enrole-list">
                                       <li class="lessons">
                                       <i class="tsicon tsicon-file"></i> 
                                       <?php echo esc_html($lessons); ?>
                                       <?php echo esc_html__(' Lessons', 'turitor'); ?>
                                       </li>
                                       <li class="students">
                                          <i class="tsicon tsicon-user_group"></i> 
                                          <?php echo esc_html($course->count_students()); ?> 
                                       </li>
                                    </ul>
                                    <div class="instructor">  
                                        <?php 
                                                $dir          = learn_press_user_profile_picture_upload_dir();
                                                $user         = get_user_by( 'id', $instructor->get_id());
                                                $pro_link     = get_user_meta($user->ID,'_lp_profile_picture',true); 
                                                $base_url     = isset($dir['baseurl'])?$dir['baseurl']:'';
                                                $profile_link =  $base_url.'/'.$pro_link;
                                        ?>
                                    
                                        <?php if($pro_link !=''){ ?>
                                          <div class="instructor-thumb">
                                                <img src="<?php echo esc_url($profile_link); ?>" alt="<?php  echo  esc_attr($user->display_name); ?>">
                                          </div>
                                          <?php  echo wp_kses_post($instructor_link) ?>

                                    <?php }else{ ?>
                                            <div class="instructor-thumb">
                                                <img src="<?php echo esc_url( get_avatar_url( $instructor->get_id() ) ); ?> " alt="<?php echo esc_attr($user->display_name); ?>"> 
                                            </div>
                                            <?php  echo wp_kses_post($instructor_link) ?>

                                        <?php } ?>
                                    </div>
                                  </div>

                                  <div class="course-thumb">
                                    <?php $course_intro_img = turitor_meta_option( $post->ID,'course_intro_img' ); ?>
                                        <?php if(isset($course_intro_img['url']) && $course_intro_img['url'] !=''){ ?>
                                                <img class="img-fluid"  src="<?php echo esc_url($course_intro_img['url']); ?>" alt="<?php echo the_title_attribute(); ?>">
                                        <?php }else{ ?>
                                          <img class="img-fluid"  src="<?php echo esc_url(get_the_post_thumbnail_url( $post->ID, 'large' )); ?>" alt="<?php echo esc_attr($post->post_title); ?>">
                                    <?php } ?> 
                                  </div>

                                  <img class="course-shap" src="<?php echo esc_url_raw(TURITOR_IMG.'/shape_combined.svg');  ?>" alt="<?php echo esc_attr__('shape', 'turitor'); ?>">

                                  <div class="course-footer">
                                       <?php 
                                          if(defined('WUR_REVIEW_KEY')) {
                                            echo	review_kit_rating( [ 'post-id' => $post->ID, 'ratting-show' => 'yes', 'ratting-style' => 'star', 'count-show' => 'no', 'vote-show' => 'yes', 'vote-text' => 'votes', 'return-type' => '' ]);
                                          }
                                       ?>
                                       <div class="course-price-item">
                                             <?php if($course->is_free()): ?>
                                                <span class="free-course"> <?php echo esc_html__('Free','turitor'); ?> </span> 
                                             <?php else: ?>
                                                <span class="course-price">							
                                                   <?php echo turitor_kses($course->get_price_html()); ?>
                                                </span> 
                                                <?php endif; ?>
                                       </div>
                                  </div>
                            </div>
                          <?php
                      endwhile;
                  ?>
         
      </div>

    <?php endif; ?>