<?php

defined('ABSPATH') || exit();

if (post_password_required()) {
	echo get_the_password_form();

	return;
}


$course           = LP_Global::course();
$sections         = $course->get_sections();
$instructor       = $course->get_instructor();
$turitor_user_designation = get_user_meta($instructor->get_id(), 'turitor_user_designation', true);
$preview_video            = turitor_meta_option(get_the_id(), 'course_preview_video');
$hide_students_list = get_post_meta($course->get_id(), '_lp_hide_students_list', true);
$questions         = $course->get_faqs();

$category = '';
$category = get_the_terms(get_the_id(), 'course_category');


?>

<div class="row">
	<div class="col-lg-4">
		<div class="course-sidebar">
			<div class="course-single-info course-widget">
				<?php if ($preview_video != '') : ?>
					<div class="course-preview-video embed-responsive embed-responsive-16by9">

						<iframe class="embed-responsive-item" width="300" height="315" src="<?php echo esc_url($preview_video); ?>">
						</iframe>

					</div>
				<?php endif; ?>
				<div class="course-intro">
					<?php
					$skill_lebel = esc_html__('beginner', 'turitor');
					$skill = get_the_terms(get_the_id(), 'ts-skill-label');

					if (is_array($skill)) {
						$skill_lebel = $skill[0]->name;
					}

					$total_quize =  turitor_get_total_quize($sections);

					$cartificat = (turitor_meta_option(get_the_id(), 'course_certificate') == 'yes' ? esc_html__('Yes', 'turitor') : esc_html__('No', 'turitor'));
					?>

					<ul>
						<li class="course-duration"> <i class="tsicon tsicon-time"></i> <?php echo esc_html__('Duration', 'turitor'); ?><span> <?php echo esc_html(get_post_meta(get_the_id(), '_lp_duration', true)); ?></span></li>
						<li class="course-lectures"> <i class="tsicon tsicon-tsbook"></i> <?php echo esc_html__('Lectures', 'turitor');  ?> <span> <?php echo esc_html($course->count_items()); ?></span></li>
						<li class="course-skill-level"> <i class="tsicon tsicon-skill_level"></i> <?php echo esc_html__('Skill level', 'turitor');  ?> <span><?php echo esc_html($skill_lebel); ?></span></li>
						<li class="course-quizes"> <i class="tsicon tsicon-tschecklist"></i> <?php echo esc_html__('Quizzes', 'turitor');  ?> <span><?php echo esc_html($total_quize); ?></span> </li>
						<li class="course-pass-parcentages"> <i class="tsicon tsicon-tsparcent"></i> <?php echo esc_html__('Pass parcentages', 'turitor');  ?> <span> <?php echo esc_html($course->get_passing_condition()); ?></span> </li>
						<li class="course-pass-Certificate"> <i class="tsicon tsicon-certificate"></i> <?php echo esc_html__('Certificate', 'turitor');  ?> <span><?php echo esc_html($cartificat); ?></span> </li>
					</ul>

				</div>
				<div class="course-enroll">
					<?php do_action( 'learn-press/before-course-buttons' ); ?>
					<?php
					/**
					 * @see learn_press_course_purchase_button - 10
					 * @see learn_press_course_enroll_button - 10
					 * @see learn_press_course_retake_button - 10
					 */
					do_action( 'learn-press/course-buttons' );
					?>
					<?php do_action( 'learn-press/after-course-buttons' ); ?>
				</div>
			</div>
			<div class="course-related course-widget">
				<?php get_template_part('learnpress/single/related-course'); ?>
			</div>
		</div>
	</div>
	<div class="col-lg-8">
		<div class="course-entry-content">
			<div class='header--course-meta'>
				<div class="row">
					<div class="col-md-8">
						<ul>
							<li>
								<div class="course-instructor media">
									<div class="course-instructor-thumb">
										<?php echo turitor_kses($instructor->get_profile_picture()); ?>
									</div>
									<div class="media-body">
										<p><?php echo esc_html($instructor->get_display_name()); ?> </p>
										<h4> <?php echo esc_html($turitor_user_designation); ?> </h4>
									</div>
								</div>

							</li>
							<li class="course-category">
								<p class="category-label"> <?php echo esc_html__('Category', 'turitor') . ': '; ?> </p>
								<h4 class="category-items">
									<?php
									if (is_array($category)) {
										foreach ($category as $kl => $type) {
											if ($kl >= 1) {
												echo ' & ';
											}
											echo esc_html($type->name);
										}
									}

									?>
								</h4>
							</li>
						</ul>

					</div>
					<!-- col- end -->
					<div class="col-md-4">
						<div class="course-price text-right">
							<span><?php echo turitor_kses($course->get_price_html()); ?></span>
						</div>
					</div>
					<!-- col end -->
				</div>
				<!-- row end -->
			</div>


			<ul class="header-meta">
				<?php if (defined('WUR_REVIEW_KEY')) {
					$rating = review_kit_rating(['post-id' => get_the_id(), 'ratting-show' => 'yes', 'ratting-style' => 'star', 'count-show' => 'no', 'vote-show' => 'yes', 'vote-text' => 'votes', 'return-type' => '']);
					if ($rating != '') {
				?>
						<li class="course-review">
							<?php
							echo review_kit_rating(['post-id' => get_the_id(), 'ratting-show' => 'yes', 'ratting-style' => 'star', 'count-show' => 'no', 'vote-show' => 'yes', 'vote-text' => 'votes', 'return-type' => '']);
							?>
						</li>
				<?php
					}
				}
				?>
				<li class="course-enrolled">
					<i class="tsicon tsicon-students"></i>
					<?php $student = _n('%s Enrolled student', '%s enrolled students', $course->get_users_enrolled(), 'turitor');
					echo sprintf($student, $course->get_users_enrolled());
					?>
				</li>
				<li class="course-language">
					<i class="tsicon tsicon-tslanguage"></i>
					<?php echo esc_html(turitor_meta_option(get_the_id(), 'course_language', 'english')); ?>
				</li>
			</ul>

			<p class="course-intro">
				<?php echo wp_kses_post(get_the_excerpt()); ?>
			</p>
			<div class="feature-image">
				<?php echo wp_kses_post($course->get_image()); ?>
			</div>

			<div class="course-extra-boxes">
				<?php
				$boxes  = apply_filters(
					'learn-press/course-extra-boxes-data',
					array(
						array(
							'title' => esc_html__( 'Requirements', 'turitor' ),
							'items' => $course->get_extra_info( 'requirements' ),
						),
						array(
							'title' => esc_html__( 'Features', 'turitor' ),
							'items' => $course->get_extra_info( 'key_features' ),
						),
						array(
							'title' => esc_html__( 'Target audiences', 'turitor' ),
							'items' => $course->get_extra_info( 'target_audiences' ),
						)						
					)
				); 
		
				$is_checked = 0;
				foreach ( $boxes as $box ) {
		
					if ( ! isset( $box['items'] ) || ! $box['items'] ) {
						continue;
					}
		
					if ( ! $is_checked ) {
						$box['checked'] = true;
						$is_checked     = true;
					}
		
					learn_press_get_template( 'single-course/extra-info', $box );
				}
				?>
			</div>

			<div class="course-tabs-content">
				<ul class="nav row">

					<li class="col"><a class="active" data-toggle="tab" href="#course-overview"><?php echo esc_html__('Overview', 'turitor'); ?></a></li>
					<li class="col"><a data-toggle="tab" href="#course-curriculum"><?php echo esc_html__('Curriculum', 'turitor'); ?></a></li>
					<li class="col"><a data-toggle="tab" href="#course-instructor"><?php echo esc_html__('Instructors', 'turitor'); ?></a></li>
					<?php if ($hide_students_list != 'yes' && class_exists( 'LP_Addon_Students_List' )) { ?>
						<li class="col"><a data-toggle="tab" href="#student-list"><?php echo esc_html__('Students List', 'turitor'); ?></a></li>
					<?php } ?>
					<li class="col"><a data-toggle="tab" href="#course-review-rating"><?php echo esc_html__('Reviews', 'turitor'); ?></a></li>
					<?php if($questions): ?>
						<li class="col"><a data-toggle="tab" href="#course-faq"><?php echo esc_html__('FAQs', 'turitor'); ?></a></li>
					<?php endif; ?>
				</ul>
				<div class="tab-content">
					<div id="course-overview" class="tab-pane fade in active show">
						<div class="overview-content">
							<?php
							turitor_course_content();
							?>
						</div>
					</div>
					<div id="course-curriculum" class="tab-pane fade">

						<?php
						if(!empty($sections)){
							foreach ($sections  as $kl => $section) {
								$lessons = $section->get_items();
							?>
								<div class="curriculum-content">
									<a href="#" class="curriculmn-title" aria-expanded="true" data-toggle="collapse" data-target="#section-<?php echo esc_attr($kl); ?>"><?php echo esc_html($section->get_title()); ?></a>
									<div id="section-<?php echo esc_attr($kl); ?>" class="collapse show">
										<?php
										echo '<ul class="curricolumn-list">';
										foreach ($lessons as $lesson) {

											echo '<li class="curricolumn-list">';
											?>
											<a href="<?php echo esc_url($lesson->get_permalink()); ?>">
												<i class="tsicon tsicon-tslist" aria-hidden="true"></i>
												<?php echo esc_html($lesson->get_title());  ?>
												<?php if($lesson->is_preview()): ?>
												<span class="curricolumn-preview"> <?php echo esc_html__(' Preview ', 'turitor') ?> </span>
												<?php endif; ?>
											</a>
											<?php
											if ($lesson->is_preview()) {
												$duration = $lesson->get_duration()->get() / 60;
												echo '<span class="curricolumn-duration">' .  $duration . esc_html__(' min ', 'turitor') . '</span>';
											} else {
												echo '<i class="fa fa-lock curricolumn-duration" aria-hidden="true"></i>';
											}

											echo '</li>';
										} //end lesson
										echo '</ul>';
										?>
									</div>
								</div>
							<?php

							}
						}

						?>

					</div>
					<!-- co instractor -->
					<div id="course-instructor" class="tab-pane fade">

						<?php
						$co_instructors = turitor_meta_option(get_the_id(), 'course_co_instructors');


						$co_instructors = turitor_get_users_by_id($co_instructors);
						foreach ($co_instructors as $co_instructor) {

							$teacher_info      = get_userdata($co_instructor->ID);
							$user_designation  = get_user_meta($co_instructor->ID, 'turitor_user_designation', true);
							$user_socials      = get_user_meta($co_instructor->ID, 'user_social_link', true);
							$user_bio          = get_user_meta($co_instructor->ID, 'description', true);

							$dir               = learn_press_user_profile_picture_upload_dir();
							$pro_link          = get_user_meta($teacher_info->ID, '_lp_profile_picture', true);
							$base_url          = isset($dir['baseurl']) ? $dir['baseurl'] : '';
							$profile_link      =  $base_url . '/' . $pro_link;
							$url               = '';

							if (function_exists('learn_press_user_profile_link')) {
								$url = esc_url(learn_press_user_profile_link($teacher_info->ID));
							} else {
								$url = get_author_posts_url($teacher_info->ID);
							}

							if (is_null(LP()->settings->get('learn_press_profile_page_id'))) {
								$url = get_author_posts_url($teacher_info->ID);
							}

						?>

							<div class="co-single-instructor">
								<div class="row co-instructor-head">
									<div class="col-md-8">
										<div class="media">
											<div class="co-instructor-thumb">
												<?php if ($pro_link != '') { ?>
													<img src="<?php echo esc_url($profile_link); ?>" alt="<?php echo  esc_attr($teacher_info->display_name); ?>">
												<?php } else { ?>
													<img src="<?php echo esc_url(get_avatar_url($teacher_info->ID)); ?> " alt="<?php echo esc_attr($teacher_info->display_name); ?>">
												<?php } ?>
											</div>
											<div class="media-body align-self-center">
												<h3 class="co-instructor-title"> <a href="<?php echo esc_url($url); ?>"> <?php echo esc_html($teacher_info->display_name); ?></a> </h3>
												<p class="co-instructor-designation"> <?php echo esc_html($user_designation); ?> </p>
											</div>
										</div>
									</div>
									<div class="col-md-4 align-self-center">
										<ul class='co-instructors-socials'>
											<?php if (is_array($user_socials)) { ?>
												<?php foreach ($user_socials as $social) { ?>
													<?php $url = ($social['url']) ? $social['url'] : ''; ?>
													<li> <a href="<?php echo esc_url($url); ?>" target="_blank"> <span class="<?php echo esc_attr($social['icon']); ?>"> </span> </a></li>
												<?php } ?>
											<?php } ?>
										</ul>
									</div>
								</div>


								<p class="instructor-bio"> <?php echo turitor_kses($user_bio);  ?> </p>

							</div>

						<?php } ?>

					</div>
					<!-- student list -->
					<?php if ($hide_students_list != 'yes' && class_exists( 'LP_Addon_Students_List' )) { ?>
					<div id="student-list" class="tab-pane fade">
						<div class="course-students-list">

							<?php
							$curd  = new LP_Course_CURD();
							$limit = isset($limit) ? $limit : -1;
							?>

							<?php if ($students = $curd->get_user_enrolled($course->get_ID(), $limit)) { ?>
								<?php
								$show_avatar               = apply_filters('learn_press_students_list_avatar', true);
								$students_list_avatar_size = apply_filters('learn_press_students_list_avatar_size', 32);
								$filter                    = isset($filter) ? $filter : 'all';
								$filters                   = apply_filters(
									'learn_press_get_students_list_filter',
									array(
										'all'         => esc_html__('All', 'turitor'),
										'in-progress' => esc_html__('In Progress', 'turitor'),
										'finished'    => esc_html__('Finished', 'turitor')
									)
								);
								?>

								<div class="filter-students">
									<label for="students-list-filter"><?php esc_html_e('Student filter', 'turitor'); ?></label>
									<select class="students-list-filter">
										<?php foreach ($filters as $key => $_filter) {
											echo '<option value="' . esc_attr($key) . '">' . esc_html($_filter) . '</option>';
										} ?>
									</select>
								</div>

								<ul class="students">
									<?php foreach ($students as $student) {
										$result  = $process = '';
										$student = learn_press_get_user($student->ID);

										$course_data       = $student->get_course_data($course->get_id());
										$course_results    = $course_data->get_results(false);
										$passing_condition = $course->get_passing_condition();

										$result = $course_results['result'];
									?>

										<?php $process .= ($result == 100) ? 'finished' : 'in-progress'; ?>

										<?php if ($filter == $process || $filter == 'all') { ?>
											<li class="students-enrolled <?php echo (isset($result)) ? 'user-login ' . $process : ''; ?>">
												<div class="user-info">
													<?php if ($show_avatar) : ?>
														<?php echo get_avatar($student->get_id(), $students_list_avatar_size, '', $student->get_data('display_name'), array('class' => 'students_list_avatar')); ?>
													<?php endif; ?>
													<a class="name" href="<?php echo learn_press_user_profile_link($student->get_id()) ?>" title="<?php echo $student->get_data('display_name') . ' profile'; ?>">
														<?php echo $student->get_data('display_name'); ?>
													</a>
												</div>

												<div class="lp-course-status">
													<span class="number"><?php echo round($course_results['result'], 2); ?>
														<span class="percentage-sign">%</span>
													</span>
													<?php if ($grade = $course_results['grade']) { ?>
														<span class="lp-label grade <?php echo esc_attr($grade); ?>">
															<?php learn_press_course_grade_html($grade); ?>
														</span>
													<?php } ?>
												</div>

												<div class="learn-press-progress lp-course-progress <?php echo $course_data->is_passed() ? ' passed' : ''; ?>" data-value="<?php echo $course_results['result']; ?>" data-passing-condition="<?php echo $passing_condition; ?>">
													<div class="progress-bg lp-progress-bar">
														<div class="progress-active lp-progress-value" style="left: <?php echo $course_results['result']; ?>%;">
														</div>
													</div>
													<div class="lp-passing-conditional" data-content="<?php printf(esc_html__('Passing condition: %s%%', 'turitor'), $passing_condition); ?>" style="left: <?php echo $passing_condition; ?>%;">
													</div>
												</div>
											</li>
										<?php } ?>
									<?php } ?>
								</ul>
								<?php
								$other_student = $course->get_data('fake_students');
								if ($other_student && $limit == -1) {
									echo '<p class="additional-students">and ' . sprintf(_n('one student enrolled.', '%s students enrolled.', $other_student, 'learnpress-students-list'), $other_student) . '</p>';
								} ?>
							<?php } else { ?>
								<div class="students empty">
									<?php if ($course->get_users_enrolled()) {
										echo apply_filters('learn_press_course_count_student', sprintf(_n('One student enrolled.', '%s students enrolled.', $course->get_users_enrolled(), 'learnpress-students-list'), $course->get_users_enrolled()));
									} else {
										echo apply_filters('learn_press_course_no_student', __('No student enrolled.', 'learnpress-students-list'));
									} ?>
								</div>
							<?php } ?>
						</div>

					</div>
					<?php } ?>
					<!-- review tab -->
					<div id="course-review-rating" class="tab-pane fade">
						<?php
						if (function_exists('review_kit_forms')) :
							echo review_kit_forms(['post-id' =>  get_the_ID()]);
						endif;
						?>

					</div>
					<div id="course-faq" class="tab-pane fade">
						<?php if($questions): ?>
							<div class="course-tab-panel-faqs course-tab-panel pt-0">
								<?php 
									foreach($questions as $item){
										$question =  $item['question'];
										$answer = $item['answer'];
										$unique_key = uniqid();
										if ( $question && $answer ) : 
											?>
											<input type="checkbox" name="course-faqs-box-ratio" id="course-faqs-box-ratio-<?php echo sanitize_key( $unique_key ); ?>"/>
											<div class="course-faqs-box">
												<label class="course-faqs-box__title" for="course-faqs-box-ratio-<?php echo sanitize_key( $unique_key ); ?>">
													<?php echo esc_html( $question ); ?>
												</label>
						
												<div class="course-faqs-box__content">
													<div class="course-faqs-box__content-inner">
														<?php echo turitor_kses($answer); ?>
													</div>
												</div>
											</div>
										<?php endif;
									}
								?>
							</div>
						<?php endif; ?>
					</div>
				</div>

			</div>
		</div>

	</div>
</div>