<?php

    defined( 'ABSPATH' ) || exit();


    $terms = get_the_terms( $post->ID, 'course_category' );
    $cat = '';
    $cat_color ='';
    $cat_with_link = '';
    
        if(is_array($terms)):

            foreach($terms as $tkey=>$term):
                
                $cat.= $term->slug.' ';
                $cat_color = turitor_term_meta_option($term->term_id, 'course_category','turitor_course_cat_color');

            endforeach;

        endif; 

        $cat_with_link = turitor_course_cageory_by_id($post->ID);

        $course          = LP_Global::course();
        
        $lessons = $course->get_curriculum_items( 'lp_lesson' )? count( $course->get_curriculum_items( 'lp_lesson' ) ) : 0;
        $students_enrolled = $course->get_users_enrolled();
        $instructor = $course->get_instructor();
        $instructor_link = $course->get_instructor_html();
        $instructor_id = $course->get_id();
        $meta = get_post_meta( $post->ID );
                        
        $featured = isset($meta['_lp_featured'][0]) ? $meta['_lp_featured'][0] : '';
                        
        ?>
        <div class="col-lg-4 col-sm-6 mb-30">
            <div class="single-course-item course-grid-style2" style="--course-color: <?php echo esc_attr($cat_color);?>">
                <div class="single-course ">
                    <div class="course-thumb">
                        <?php $course_intro_img = turitor_meta_option( $post->ID,'course_intro_img' ); ?>
                            <?php if(isset($course_intro_img['url']) && $course_intro_img['url'] !=''){ ?>
                                    <img class="img-fluid"  src="<?php echo esc_url($course_intro_img['url']); ?>" alt="<?php echo esc_html($post->post_title); ?>">
                            <?php }else{ ?>
                                <img class="img-fluid"  src="<?php echo esc_url(get_the_post_thumbnail_url( $post->ID, 'large' )); ?>" alt="<?php echo esc_html($post->post_title); ?>">
                        <?php } ?>
                    </div>
                    <div class="course-title-area">
                        <div class="course-category">
                            <span style="background-color: <?php echo esc_attr($cat_color); ?>">
                                <?php 
                                echo wp_kses_post($cat_with_link);
                                ?> 
                            </span>
                                
                        </div>
                        <h3 class="ts-course-el-title"> 
                            <a href="<?php echo esc_url($course->get_permalink()); ?>">
                                <?php echo esc_html($post->post_title); ?> 
                            </a>	
                        </h3>
                    </div>

                    <div class="course-footer style2">
                            <?php 
                            if(defined('WUR_REVIEW_KEY')) {
                                echo	review_kit_rating( [ 'post-id' => $post->ID, 'ratting-show' => 'yes', 'ratting-style' => 'star', 'count-show' => 'no', 'vote-show' => 'yes', 'vote-text' => 'votes', 'return-type' => '' ]);
                            }
                            ?>
                        <div class="course-price-item">
                            <?php if($course->is_free()): ?>
                            <span class="free-course"> <?php echo esc_html__('Free','turitor'); ?> </span> 
                            <?php else: ?>
                            <span class="course-price">							
                                <?php echo turitor_kses($course->get_price_html()); ?>
                                <?php endif; ?>
                            </span>
                            </div>
                        </div>
                    
                    <!-- hover item -->
                    <div class="single-course hover">
                        <div class="course-category">
                                <?php 
                                echo wp_kses_post($cat_with_link);
                                ?> 
                        </div>
                        <h3 class="ts-course-el-title"> 
                            <a href="<?php echo esc_url($course->get_permalink()); ?>">
                                <?php echo esc_html($post->post_title); ?> 
                            </a>	
                        </h3>
                        <div class="enrol-list-area">
                            <div class="instructor">  
                                <?php 
                                        $dir = learn_press_user_profile_picture_upload_dir();
                                        $user = get_user_by( 'id', $instructor->get_id());
                                        $pro_link = get_user_meta($user->ID,'_lp_profile_picture',true); 
                                        $base_url = isset($dir['baseurl'])?$dir['baseurl']:'';
                                        $profile_link =  $base_url.'/'.$pro_link;
                                ?>
                            
                                <?php if($pro_link !=''){ ?>
                                    <div class="instructor-thumb">
                                        <img src="<?php echo esc_url($profile_link); ?>" alt="<?php  echo  esc_attr($user->display_name); ?>">
                                </div>
                                        <?php  echo wp_kses_post($instructor_link) ?>

                            <?php }else{ ?>
                                <div class="instructor-thumb">
                                        <img src="<?php echo esc_url( get_avatar_url( $instructor->get_id() ) ); ?> " alt="<?php echo esc_attr($user->display_name); ?>"> 
                            </div>
                                        <?php  echo wp_kses_post($instructor_link) ?>

                            <?php } ?>
                            </div>
                        </div>
                            <div class="excerpt-content">
                                    <p>
                                        <?php echo turitor_excerpt(14, ''); ?>
                                    </p>
                            </div>

                    </div>
                </div>

                
                </div>
        </div>