<?php

	/**
	 * Prevent loading this file directly
	 */
   defined( 'ABSPATH' ) || exit();
   $paged    = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;
   $args = array( 
		'post_type'      => LP_COURSE_CPT,
		'orderby'        => 'modified',
		'order'          => 'DESC',
		'posts_per_page' => LP()->settings->get('learn_press_archive_course_limit') ,
		'paged'          => $paged 
	);

	$args = apply_filters('turitor_archive_post_args',$args);

	$query = new WP_Query($args);
	

	$total = $query->found_posts;
	if ( $total == 0 ) {
		$message = '<p class="message message-error">' . esc_html__( 'No courses found!', 'turitor' ) . '</p>';
		$index   = esc_html__( 'There are no available courses!', 'turitor' );
	} elseif ( $total == 1 ) {
		$index = esc_html__( 'Showing only one result', 'turitor' );
	} else {
		$courses_per_page = absint( LP()->settings->get( 'archive_course_limit' ) );
		

		$from = 1 + ( $paged - 1 ) * $courses_per_page;
		$to   = ( $paged * $courses_per_page > $total ) ? $total : $paged * $courses_per_page;

		if ( $from == $to ) {
			$index = sprintf(
				esc_html__( 'Showing last course of %s results', 'turitor' ),
				$total
			);
		} else {
			$index = sprintf(
				esc_html__( 'Showing %s-%s of %s results', 'turitor' ),
				$from,
				$to,
				$total
			);
		}
	}
	?>
	<div class="archive-course-filter">
		<div class="row"> 
			<div class="col-md-4">
				<p class="text-index-result">
					<?php echo esc_html($index); ?> 
				</p>
			</div>
			<div class="col-md-4"> 
				<?php get_template_part('learnpress/filter','category-dropdown'); ?>
			</div>  
			<div class="col-md-4"> 
				<?php get_template_part('learnpress/filter','order'); ?>
			</div> 
		</div>
	</div>
	<div class="course-archive-list styel1">
		    <div class="row">
				<?php 
					if($query->have_posts()):
						while ($query->have_posts()) : $query->the_post();
							get_template_part( 'learnpress/content-course', 'archive' ); 
						endwhile;
						wp_reset_postdata();
					endif;
			    ?> 
			</div>
			<?php
				$GLOBALS['wp_query']->max_num_pages = $query->max_num_pages; 
				get_template_part( 'template-parts/blog/paginations/pagination', 'style1' );
			?>
	</div>


	<?php

	