<?php
/**
 * The header template for the theme
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>> 
    <head>
        <meta charset="<?php bloginfo( 'charset' ); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
		<?php wp_head(); ?>
    </head>
    <body <?php body_class(); ?>>

        <?php wp_body_open(); ?>
        
        <?php 
            
          $class = '';
          $title = '';
          $header_style="default";
          $header_settings = [];
          $header_builder_enable = 'no';
        
          if ( defined( 'FW' ) ) { 
              $header_settings =  turitor_option('theme_header_default_settings');
              if(isset($header_settings['no'])){
                $header_style = $header_settings['no']['header_layout_style'];
              }
          }

          $page_override_header     = turitor_meta_option(get_the_ID(),'page_header_override');
          $page_header_layout_style = turitor_meta_option(get_the_ID(),'page_header_layout_style','default');
        
          get_template_part( 'template-parts/headers/header', $header_style );

        ?>
    
