<?php

/**
 * theme's main functions and globally usable variables, contants etc
 * added: v1.0 
 * textdomain: turitor, class: TURITOR, var: $turitor_, constants: TURITOR_, function: turitor_
 */

// shorthand contants
// ------------------------------------------------------------------------
define('TURITOR_THEME', 'Turitor is a Education WordPress Theme');
define('TURITOR_VERSION', '1.3.9');
define('TURITOR_MINWP_VERSION', '5.2');


// shorthand contants for theme assets url
// ------------------------------------------------------------------------
define('TURITOR_THEME_URI', get_template_directory_uri());
define('TURITOR_IMG', TURITOR_THEME_URI . '/assets/images');
define('TURITOR_CSS', TURITOR_THEME_URI . '/assets/css');
define('TURITOR_JS', TURITOR_THEME_URI . '/assets/js');


// shorthand contants for theme assets directory path
// ----------------------------------------------------------------------------------------
define('TURITOR_THEME_DIR', get_template_directory());
define('TURITOR_IMG_DIR', TURITOR_THEME_DIR . '/assets/images');
define('TURITOR_CSS_DIR', TURITOR_THEME_DIR . '/assets/css');
define('TURITOR_JS_DIR', TURITOR_THEME_DIR . '/assets/js');

define('TURITOR_CORE', TURITOR_THEME_DIR . '/core');
define('TURITOR_COMPONENTS', TURITOR_THEME_DIR . '/components');
define('TURITOR_EDITOR', TURITOR_COMPONENTS . '/editor');
define('TURITOR_EDITOR_ELEMENTOR', TURITOR_EDITOR . '/elementor');
define('TURITOR_EDITOR_GUTENBERG', TURITOR_EDITOR . '/gutenberg');
define('TURITOR_SHORTCODE_DIR_STYLE', TURITOR_EDITOR_ELEMENTOR . '/widgets/style');
define('TURITOR_INSTALLATION', TURITOR_CORE . '/installation-fragments');
define('TURITOR_REMOTE_CONTENT', esc_url('http://themewinter.net/demo-content/turitor'));


// set up the content width value based on the theme's design
// ----------------------------------------------------------------------------------------
if (!isset($content_width)) {
    $content_width = 800;
}

// set up theme default and register various supported features.
// ----------------------------------------------------------------------------------------

function turitor_setup()
{

    // make the theme available for translation
    $lang_dir = TURITOR_THEME_DIR . '/languages';
    load_theme_textdomain('turitor', $lang_dir);

    // add support for post formats
    add_theme_support('post-formats', [
        'standard', 'gallery', 'video', 'audio'
    ]);

    // add support for automatic feed links
    add_theme_support('automatic-feed-links');

    // let WordPress manage the document title
    add_theme_support('title-tag');

    // add support for post thumbnails
    add_theme_support('post-thumbnails');

    add_theme_support('align-wide');


    // hard crop center center
    set_post_thumbnail_size(750, 465, ['center', 'center']);
    add_image_size('turitor-small', 350, 250, ['center', 'center']);

    define ( 'BP_AVATAR_THUMB_WIDTH', 160 );
    define ( 'BP_AVATAR_THUMB_HEIGHT', 160 );

    // woocommerce support
    add_theme_support('woocommerce');
    add_theme_support('woocommerce', array(
        'thumbnail_image_width' => 600,
        'gallery_thumbnail_image_width' => 300,
        'single_image_width' => 600,
    ));
    add_theme_support('wc-product-gallery-lightbox');
    add_theme_support('wc-product-gallery-slider');


    // register navigation menus
    register_nav_menus(
        [
            'primary' => esc_html__('Primary Menu', 'turitor'),
            'footermenu' => esc_html__('Footer Menu', 'turitor'),
            'categorymenu' => esc_html__('Category List Menu', 'turitor'),
        ]
    );

    // HTML5 markup support for search form, comment form, and comments
    add_theme_support('html5', array(
        'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
    ));
}
add_action('after_setup_theme', 'turitor_setup');



// hooks for unyson framework
// ----------------------------------------------------------------------------------------
function turitor_framework_customizations_path($rel_path)
{
    return '/components';
}
add_filter('fw_framework_customizations_dir_rel_path', 'turitor_framework_customizations_path');


function turitor_remove_fw_settings()
{
    remove_submenu_page('themes.php', 'fw-settings');
}
add_action('admin_menu', 'turitor_remove_fw_settings', 999);


//Change sidebar id to your primary sidebar id and add it to 

//themes/theme_name/core/hooks/blog.php
function turitor_body_classes($classes)
{

    if (is_active_sidebar('sidebar-1')) {
        $classes[] = 'sidebar-active';
    } else {
        $classes[] = 'sidebar-inactive';
    }
    return $classes;
}
add_filter('body_class', 'turitor_body_classes');





// include the init.php
// ----------------------------------------------------------------------------------------
require_once(TURITOR_CORE . '/init.php');
require_once(TURITOR_COMPONENTS . '/editor/elementor/elementor.php');


// gutenberg
add_action('enqueue_block_editor_assets', 'turitor_action_enqueue_block_editor_assets');
function turitor_action_enqueue_block_editor_assets()
{
    wp_enqueue_style('turitor-fonts', turitor_google_fonts_url(['Roboto:300,300i,400,400i,500,500i,700,700i,900,900i', 'Rubik:400,400i,500,500i,700,700i,900,900i']), null, TURITOR_VERSION);
    wp_enqueue_style('turitor-gutenberg-editor-font-awesome-styles', TURITOR_CSS . '/font-awesome.css', null, TURITOR_VERSION);
    wp_enqueue_style('turitor-gutenberg-editor-customizer-styles', TURITOR_CSS . '/gutenberg-editor-custom.css', null, TURITOR_VERSION);
    wp_enqueue_style('turitor-gutenberg-editor-styles', TURITOR_CSS . '/gutenberg-custom.css', null, TURITOR_VERSION);
    wp_enqueue_style('turitor-gutenberg-blog-styles', TURITOR_CSS . '/blog.css', null, TURITOR_VERSION);
}


function instructor_follow_requested()
{
    $id = $_REQUEST['instructor_id'];
    turitor_follow_instructor_by_id($id);
    turitor_follower_instructor_by_id($id);
    wp_die();
}
add_action('wp_ajax_instructor_follow', 'instructor_follow_requested');


// preloader function
// ----------------------------------------------------------------------------------------
function preloader_function()
{
    $preloader_show = turitor_option('preloader_show');
    if ($preloader_show == 'yes') {
    $turitor_preloader_logo_url= esc_url(turitor_src('preloader_logo'));
?>
        <div id="preloader">
        <?php if($turitor_preloader_logo_url !=''): ?>
            
            <div class="preloader-logo">
                <img  class="img-fluid" src="<?php echo esc_url($turitor_preloader_logo_url); ?>" alt="<?php echo get_bloginfo('name') ?>">
            </div>
            <?php else: ?>
            <div class="spinner">
                <div class="double-bounce1"></div>
                <div class="double-bounce2"></div>
            </div>
            <?php endif; ?>
            <div class="preloader-cancel-btn-wraper">
                <span class="btn btn-primary preloader-cancel-btn"><?php echo esc_html__('Cancel Preloader', 'turitor'); ?></span>
            </div>
        </div>
        <?php
    }
}
add_action('wp_head', 'preloader_function');


//function for load-more
function load_posts_by_ajax_callback()
{
    check_ajax_referer('load_more_posts', 'security_nonce');
    $paged = $_POST['paged'];
    $posts_per_page = $_POST['posts_per_page'];
    $order = $_POST['order'];
    $cat_id = $_POST['cat_id'];
    $args = array(
        'post_type'           => 'lp_course',
        'posts_per_page' => $posts_per_page,
        'paged' => $paged,
    );
    $the_query = new \WP_Query($args);
    if ($the_query->have_posts()) :
        if (defined('LP_COURSE_CPT')) {
        ?>
            <?php include(locate_template("components/editor/elementor/widgets/style/courses/grid-loadmore.php", false, false)); ?>
<?php
        }
    endif;
    wp_die();
}

add_action('wp_ajax_load_posts_by_ajax', 'load_posts_by_ajax_callback');
add_action('wp_ajax_nopriv_load_posts_by_ajax', 'load_posts_by_ajax_callback');

function turitor_print_categories_of_post($id, $taxonomy)
{
    $terms = get_the_terms($id, $taxonomy);
    $cat = '';
    $cat_with_link = '';
    $cat_color = '';
    if (is_array($terms)) :
        foreach ($terms as $term) :
            $cat .= $term->name . ' ';
            $cat_with_link = sprintf("<a href='%s'><u>%s</u></a>", get_category_link($term->term_id), $term->name);
            echo $cat_with_link . "&nbsp&nbsp";
        endforeach;
    endif;
}


add_filter( 'learn-press/override-templates', function(){ return true; } );
