<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * register required plugins
 */

function turitor_register_required_plugins() {
	$plugins	 = array(
      
		array(
			'name'		 => esc_html__( 'Unyson', 'turitor' ),
			'slug'		 => 'unyson',
			'required'	 => true,
        ), 
      
		array(
			'name'		 => esc_html__( 'Elementor', 'turitor' ),
			'slug'		 => 'elementor',
			'required'	 => true,
		),
		
		array(
            'name'		 => esc_html__( 'Elementskit Lite', 'turitor' ),
            'slug'		 => 'elementskit-lite',
            'required'	 => true,
		),
		
		array(
			'name'		 => esc_html__( 'MetForm', 'turitor' ),
			'slug'		 => 'metform',
			'required'	 => true,
		),

		array(
			'name'		 => esc_html__( 'wp ultimate review ', 'turitor' ),
			'slug'		 => 'wp-ultimate-review',
			'required'	 => true,
						
		),
		array(
			'name'		 => esc_html__( 'LearnPress ', 'turitor' ),
			'slug'		 => 'learnpress',
			'required'	 => true,
		),
		array(
			'name'		 => esc_html__( 'Turitor Essentials', 'turitor' ),
			'slug'		 => 'turitor-essential',
			'required'	 => true,
			'version'	 => '1.6', 
			'source'	 =>  'https://demo.themewinter.com/wp/plugins/turitor/turitor-essential.zip',
		),
	);


	$config = array(
		'id'			 => 'turitor', // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path'	 => '', // Default absolute path to bundled plugins.
		'menu'			 => 'turitor-install-plugins', // Menu slug.
		'parent_slug'	 => 'themes.php', // Parent menu slug.
		'capability'	 => 'edit_theme_options', // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
		'has_notices'	 => true, // Show admin notices or not.
		'dismissable'	 => true, // If false, a user cannot dismiss the nag message.
		'dismiss_msg'	 => '', // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic'	 => true, // Automatically activate plugins after installation or not.
		'message'		 => '', // Message to output right before the plugins table.
	);

	tgmpa( $plugins, $config );
}

add_action( 'tgmpa_register', 'turitor_register_required_plugins' );