<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * hooks for wp blog part
 */

// if there is no excerpt, sets a defult placeholder
// ----------------------------------------------------------------------------------------
function turitor_excerpt( $words = 20, $more = 'BUTTON' ) {
	if($more == 'BUTTON'){
		$more = '<a class="btn btn-primary">'.esc_html__('read more', 'turitor').'</a>';
	}
	$excerpt		 = get_the_excerpt();
	$trimmed_content = wp_trim_words( $excerpt, $words, $more );
	echo turitor_kses( $trimmed_content );
}

if ( ! function_exists( 'wp_body_open' ) ) {
	function wp_body_open() {
			do_action( 'wp_body_open' );
	}
}

// change textarea position in comment form
// ----------------------------------------------------------------------------------------
function turitor_move_comment_textarea_to_bottom( $fields ) {
	$comment_field		 = $fields[ 'comment' ];
	unset( $fields[ 'comment' ] );
	$fields[ 'comment' ] = $comment_field;
	return $fields;
}
add_filter( 'comment_form_fields', 'turitor_move_comment_textarea_to_bottom' );


// change textarea position in comment form
// ----------------------------------------------------------------------------------------
function turitor_search_form( $form ) {
   
	
	$default_course_search = turitor_option('course_search_filter', 'no');

	
	if($default_course_search=='yes'){
		$form = '
        <form  method="get" action="' . esc_url( home_url( '/' ) ) . '" class="turitor-serach">
            <div class="input-group">
				<input type="search" class="form-control" name="s" placeholder="' .esc_attr__( 'Search course', 'turitor' ) . '" value="' . get_search_query() . '">
				<input type="hidden" name="ref" value="course">
                <button type="submit" class="input-group-btn"><i class="tsicon tsicon-search1"></i></button>
            </div>
		</form>';
        return $form;
	}
	$form = '
	<form  method="get" action="' . esc_url( home_url( '/' ) ) . '" class="turitor-serach">
		<div class="input-group">
			<input type="search" class="form-control" name="s" placeholder="' .esc_attr__( 'Search', 'turitor' ) . '" value="' . get_search_query() . '">
			<button type="submit" class="input-group-btn"><i class="tsicon tsicon-search1"></i></button>
		</div>
	</form>';
	return $form;

}

add_filter( 'get_search_form', 'turitor_search_form');






