<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * customizer option: Header
 */

$options =[
    'header_settings' => [
        'title'		 => esc_html__( 'Header settings', 'turitor' ),

        'options'	 => [

            'header_builder_enable' => [
                'type'			   => 'switch',
                'label'			   => esc_html__( 'Header builder Enable', 'turitor' ),
                'desc'			   => '' ,
                'value'           => 'no',
                'left-choice'	 => [
                    'value'	 => 'yes',
                    'label'	 => esc_html__('Yes', 'turitor'),
                ],
                'right-choice'	 => [
                    'value'	 => 'no',
                    'label'	 => esc_html__('No', 'turitor'),
                    ],
                ],
                'theme_header_default_settings' => array(
                    'type' => 'multi-picker',
                    'picker' => 'header_builder_enable',
           
                    'choices' => array(
                       'yes' => array(
                       
                          'edit_header' => array(
                             'type'  => 'html',
                             'help'  => esc_html__('Change header content from below link', 'turitor'),
                             'html'  => '<h3 class="header_builder_edit"><a class="turitor_header_builder_edit_link" target="_blank" href='. admin_url( 'edit.php?post_type=elementskit_template&elementskit_type_filter=header' ). '>'. esc_html__('Edit','turitor'). '</a><h3>' ,
                        ),
                        
                       ),
     
                        
           
                       'no' => array(
                        'header_layout_style' => [
                            'label'	        => esc_html__( 'Header style', 'turitor' ),
                            'desc'	        => esc_html__( 'This is the site\'s main header style.', 'turitor' ),
                            'type'	        => 'image-picker',
                            'choices'       => [
                             
                                'standard'    => [
                                    'small'     => TURITOR_IMG . '/admin/header-style/header-standard.png',
                                    'large'     => TURITOR_IMG . '/admin/header-style/header-standard.png',
                                ],
                                'default'    => [
                                    'small'     => TURITOR_IMG . '/admin/header-style/header-default.png',
                                    'large'     => TURITOR_IMG . '/admin/header-style/header-default.png',
                                ],
                              
                            ],
                            'value'         => 'default',
                         ], //Header style
            
                        //  nav sticky
                        'header_nav_sticky' => [
                            'type'			 => 'switch',
                            'label'			 => esc_html__( 'Show nav sticky?', 'turitor' ),
                            'desc'          => esc_html__('Show or hide the header sticky', 'turitor'),
                            'value'         => 'no',
                            'left-choice'	 => [
                                'value'	 => 'yes',
                                'label'	 => esc_html__( 'Yes', 'turitor' ),
                            ],
                            'right-choice'	 => [
                                'value'	 => 'no',
                                'label'	 => esc_html__( 'No', 'turitor' ),
                            ],
                        ],
                        'shop_btn_show' => [
                            'type'			 => 'switch',
                            'label'			 => esc_html__( 'Show cart button?', 'turitor' ),
                            'desc'          => esc_html__('Show or hide the header cart button', 'turitor'),
                            'value'         => 'no',
                            'left-choice'	 => [
                                'value'	 => 'yes',
                                'label'	 => esc_html__( 'Yes', 'turitor' ),
                            ],
                            'right-choice'	 => [
                                'value'	 => 'no',
                                'label'	 => esc_html__( 'No', 'turitor' ),
                            ],
                        ],

                        'author_btn_show' => [
                            'type'			 => 'switch',
                            'label'			 => esc_html__( 'Login button show?', 'turitor' ),
                            'desc'          => esc_html__('Show or hide the header login button', 'turitor'),
                            'value'         => 'no',
                            'left-choice'	 => [
                                'value'	 => 'yes',
                                'label'	 => esc_html__( 'Yes', 'turitor' ),
                            ],
                            'right-choice'	 => [
                                'value'	 => 'no',
                                'label'	 => esc_html__( 'No', 'turitor' ),
                            ],
                        ],
                        'author_url_link' => [
                            'type'			 => 'text',
                            'label'			 => esc_html__( 'Login URI', 'turitor' ),
                            'desc'          => esc_html__('Login Page link', 'turitor'),
                        ],

                        'course_category_en' =>[

                            'type'  => 'switch',
                            'value' => 'no',
                            'label' => esc_html__('Course Category Enable', 'turitor'),
                                          
                            'left-choice' => array(
                                'value' => 'yes',
                                'label' => esc_html__('Yes', 'turitor'),
                            ),
                            'right-choice' => array(
                                'value' => 'no',
                                'label' => esc_html__('No', 'turitor'),
                            ),
                          
                        ],
                        'course_search_en' =>[

                            'type'  => 'switch',
                            'value' => 'no',
                            'label' => esc_html__('Course search', 'turitor'),
                                          
                            'left-choice' => array(
                                'value' => 'yes',
                                'label' => esc_html__('Yes', 'turitor'),
                            ),
                            'right-choice' => array(
                                'value' => 'no',
                                'label' => esc_html__('No', 'turitor'),
                            ),
                          
                        ],
                        
                        'header_offcanvas_settings' => [
                            'type'        => 'popup',
                            'label'       => esc_html__('Header Offcanvas menu settings', 'turitor'),
                            'popup-title' => esc_html__('Header Offcanvas menu settings', 'turitor'),
                            'button'      => esc_html__('Edit header Offcanvas menu', 'turitor'),
                            'size'        => 'small', // small, medium, large
                            'popup-options' => [
                            
                                'header_offcanvas_show' => [
                                    'type'			 => 'switch',
                                    'label'			 => esc_html__( 'Show offcanvas menu?', 'turitor' ),
                                    'desc'          => esc_html__('Show or hide the header button', 'turitor'),
                                    'value'         => 'no',
                                    'left-choice'	 => [
                                        'value'	 => 'yes',
                                        'label'	 => esc_html__( 'Yes', 'turitor' ),
                                    ],
                                    'right-choice'	 => [
                                        'value'	 => 'no',
                                        'label'	 => esc_html__( 'No', 'turitor' ),
                                    ],
                                ],
                            
                                'offcanvas_desc'	 => [
                                    'type'	 => 'textarea',
                                    'label'	 => esc_html__( 'Description', 'turitor' ),
                                ],
                             
                                'offcanvas_email_icon'	 => [
                                    'type'	 => 'new-icon',
                                    'label'	 => esc_html__( 'Email icon', 'turitor' ),
                                ],
                                'offcanvas_email'	 => [
                                    'type'	 => 'text',
                                    'label'	 => esc_html__( 'Email', 'turitor' ),
                                ],
            
                                'offcanvas_phone_icon'	 => [
                                    'type'	 => 'new-icon',
                                    'label'	 => esc_html__( 'Phone icon', 'turitor' ),
                                ],
                                'offcanvas_phone_number'	 => [
                                    'type'	 => 'text',
                                    'label'	 => esc_html__( 'Phone', 'turitor' ),
                                ],
                             
            
                            ],
                        ],  
                       )
                    )
              ),   

     


        ], //Options end
    ]
];