<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;


class Turitor_User_Login_Widget extends Widget_Base
{


	public $base;

	public function get_name()
	{
		return 'turitor-userlogin';
	}

	public function get_title()
	{
		return esc_html__('User learnpress Login', 'turitor');
	}

	public function get_icon()
	{
		return 'fas fa-user';
	}

	public function get_categories()
	{
		return ['turitor-elements'];
	}

	protected function _register_controls()
	{

		$this->start_controls_section(
			'section_tab',
			[
				'label' => esc_html__('User Btn settings', 'turitor'),
			]
		);


		$this->add_control(
			'user_login_icon',
			[
				'label' => esc_html__('Icon', 'turitor'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'tsicon tsicon-user',
				],
			]
		);
		$this->add_control(
			'icon_with_text_show',
			[
				'label'       => esc_html__('Icon with text ', 'turitor'),
				'type'        => Controls_Manager::SWITCHER,
				'label_on'    => esc_html__('Yes', 'turitor'),
				'label_off'   => esc_html__('No', 'turitor'),
				'default'     => 'no',
			]
		);
		$this->add_control(
			'icon_with_text',
			[
				'label' => esc_html__('Enter your text', 'turitor'),
				'type' => Controls_Manager::TEXT,
				'condition' => ['icon_with_text_show' => 'yes'],
			]
		);

		$this->add_control(
			'custom_link_show',
			[
				'label'       => esc_html__('Use custom link?', 'turitor'),
				'type'        => Controls_Manager::SWITCHER,
				'label_on'    => esc_html__('Yes', 'turitor'),
				'label_off'   => esc_html__('No', 'turitor'),
				'default'     => 'no',
			]
		);
		$this->add_control(
			'user_custom_link',
			[
				'label' => __('Link', 'turitor'),
				'type' => \Elementor\Controls_Manager::URL,
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => ['custom_link_show' => 'yes'],
			]
		);

		$this->add_responsive_control(
			'user_align',
			[
				'label'			 => esc_html__('Alignment', 'turitor'),
				'type'			 => Controls_Manager::CHOOSE,
				'options'		 => [

					'left'		 => [
						'title'	 => esc_html__('Left', 'turitor'),
						'icon'	 => 'fa fa-align-left',
					],
					'center'	 => [
						'title'	 => esc_html__('Center', 'turitor'),
						'icon'	 => 'fa fa-align-center',
					],
					'right'		 => [
						'title'	 => esc_html__('Right', 'turitor'),
						'icon'	 => 'fa fa-align-right',
					],
					'justify'	 => [
						'title'	 => esc_html__('Justified', 'turitor'),
						'icon'	 => 'fa fa-align-justify',
					],
				],
				'default'		 => 'center',
				'selectors' => [
					'{{WRAPPER}} .login-user a ' => 'text-align: {{VALUE}};',
					'{{WRAPPER}} .login-user a ' => 'text-align: {{VALUE}};',

				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'user_login_btn_style',
			[
				'label'	 => esc_html__('User Button Style', 'turitor'),
				'tab'	 => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'user_button_color',
			[
				'label'		 => esc_html__('Button color', 'turitor'),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .login-user a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .login-user a i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .login-user a span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'user_button_hover_color',
			[
				'label'		 => esc_html__('Button hover Color', 'turitor'),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .login-user a:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .login-user a span:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'user_bg_color',
				'label' => esc_html__('User Button hover BG Color', 'turitor'),
				'types' => ['classic', 'gradient'],
				'selector' => '{{WRAPPER}} .login-user a:hover',
			]
		);

		$this->add_control(
			'user_bdr_color',
			[
				'label'		 => esc_html__('Border color', 'turitor'),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .login-user a' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'user_border',
				'label' => esc_html__('Border', 'turitor'),
				'selector' => '{{WRAPPER}} .header-login-user a',
			]
		);

		$this->add_responsive_control(
			'user_border_radius',
			[
				'label' => esc_html__('Border Radius', 'turitor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .login-user a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'user_height',
			[
				'label' => esc_html__('Height', 'turitor'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .login-user a' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'user_padding',
			[
				'label' => esc_html__('padding', 'turitor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'allowed_dimensions' => ['top', 'right', 'bottom', 'left'],
				'selectors' => [
					'{{WRAPPER}} .login-user a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings       = $this->get_settings();
		$custom_link_show = $settings['custom_link_show'];
		$user_custom_link = $settings['user_custom_link'];
		$icon_with_text_show = $settings['icon_with_text_show'];
		$icon_with_text = $settings['icon_with_text'];
		$target = $settings['user_custom_link']['is_external'] ? ' target="_blank"' : '';
		$nofollow = $settings['user_custom_link']['nofollow'] ? ' rel="nofollow"' : '';
		$profile_url = '#';
?>


		<div class="login-user">
			<?php if ($custom_link_show == 'yes') : ?>
				<?php 
				$profile_urls = '';
				if (function_exists('learn_press_get_page_link')) {
					$profile_urls = learn_press_get_page_link('profile');
				}
					$prfolie_url = (is_user_logged_in() ? $profile_urls : $user_custom_link['url']); ?>

				<a href="<?php echo esc_url($prfolie_url); ?>" <?php echo esc_attr($target);
																			echo esc_attr($nofollow); ?>>
					<?php Icons_Manager::render_icon($settings['user_login_icon'], ['aria-hidden' => 'true']); ?>

					<?php if ($icon_with_text_show == 'yes') : ?>
						<?php if (is_user_logged_in()) { ?>
							<span><?php echo esc_html__('My account', 'turitor'); ?></span>
						<?php } else { ?>
							<span><?php echo esc_html($icon_with_text); ?></span>
						<?php } ?>
					<?php endif; ?>
				</a>
			<?php else : ?>

				<?php
				if (function_exists('learn_press_get_page_link')) {
					$profile_url = learn_press_get_page_link('profile');

					if (is_user_logged_in()) {
				?>
						<a href="<?php echo esc_url($profile_url); ?>"><?php Icons_Manager::render_icon($settings['user_login_icon'], ['aria-hidden' => 'true']); ?>
							<?php if ($icon_with_text_show == 'yes') : ?>
								<span><?php echo esc_html__('My account', 'turitor'); ?></span>
							<?php endif; ?>
						</a>
					<?php
					} else {
					?>
						<a href="#" data-toggle="modal" data-target="#exampleModalCenter">
							<?php Icons_Manager::render_icon($settings['user_login_icon'], ['aria-hidden' => 'true']); ?>
							<?php if ($icon_with_text_show == 'yes') : ?>
								<span><?php echo esc_html($icon_with_text); ?></span>
							<?php endif; ?>
						</a>
				<?php
					}
				}
				?>
			<?php endif; ?>
		</div>

		<!-- Modal -->
		<div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							<span aria-hidden="true">&times;</span>
						</button>
					</div>
					<div class="modal-body">
						<div class="row">
							<div class="col-lg-6">
								<div class="lp-login-form turitor-lp-form">
									<?php echo do_shortcode('[turitor_lp_login_form]'); ?>
								</div>
							</div>
							<div class="col-lg-6">
								<div class="lp-reg-form turitor-lp-form">
									<?php echo do_shortcode('[turitor_lp_register_form]'); ?>
								</div>
							</div>
						</div>
					</div>

				</div>
			</div>
		</div>


<?php
	}
	protected function _content_template()
	{
	}
}
