<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Turitor_Topics_Widget extends Widget_Base {


    public $base;

    public function get_name() {
        return 'turitor-topics';
    }

    public function get_title() {
        return esc_html__( 'Topics', 'turitor' );
    }

    public function get_icon() { 
        return 'eicon-info-box';
    }

    public function get_categories() {
        return [ 'turitor-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Turitor Topics Item', 'turitor'),
            ]
		);
        $this->add_control(
			'title', [
				'label'			=> esc_html__( 'Title', 'turitor' ),
				'type'			=> Controls_Manager::TEXT,
				'label_block'	=> true,
				'placeholder'	=> esc_html__( 'Education Theory', 'turitor' ),
				'default'	    => esc_html__( 'Education Theory', 'turitor' ),
			]
		);

        $this->add_control(
			'desc', [
			'label'			=> esc_html__( 'Content', 'turitor' ),
			'type'			=> Controls_Manager::TEXTAREA,
			'label_block'	=> true,
			'placeholder'	=> esc_html__( 'Exclusively for Principals, these sessions look at the chall', 'turitor' ),
            'default'       => esc_html__( 'Exclusively for Principals, these sessions look at the chall', 'turitor' ),
            ]
		);
		
		$this->add_control(
			'icon',
			[
				'label' =>esc_html__( 'Icon', 'turitor' ),
				'type' => Controls_Manager::ICON,
				'label_block' => true,
				'default' => 'icon icon-plus',
			]
        );
        
        $this->add_control(
			'topics_link',
			[
				'label' =>esc_html__( 'Topic Link', 'turitor' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'Press link', 'turitor' ),		
			]
		);

        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'topic_bg',
                'label' =>esc_html__( 'Background', 'turitor' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .single-topics::after',
			]
		);
        
        $this->add_responsive_control('title_align', 
          [
				'label'			 => esc_html__( 'Alignment', 'turitor' ),
				'type'			 => Controls_Manager::CHOOSE,
				'options'		 => [

					'left'		 => [
						'title'	 => esc_html__( 'Left', 'turitor' ),
						'icon'	 => 'fa fa-align-left',
					],
					'center'	 => [
						'title'	 => esc_html__( 'Center', 'turitor' ),
						'icon'	 => 'fa fa-align-center',
					],
					'right'		 => [
						'title'	 => esc_html__( 'Right', 'turitor' ),
						'icon'	 => 'fa fa-align-right',
					],
					'justify'	 => [
						'title'	 => esc_html__( 'Justified', 'turitor' ),
						'icon'	 => 'fa fa-align-justify',
					],
				],
				'default'		 => 'left',
                'selectors' => [
                    '{{WRAPPER}} ..single-topics' => 'text-align: {{VALUE}};',
				],
			]
        );//Responsive control end
        $this->end_controls_section();

		
       
		$this->start_controls_section(
			'section_sub_title_style', [
				'label'	 => esc_html__( 'Title', 'turitor' ),
				'tab'	 => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'title_color', [
				'label'		 => esc_html__( 'Title color', 'turitor' ),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .single-topics .ts-title' => 'color: {{VALUE}};',
				],
			]
		);

        
        $this->add_group_control(Group_Control_Typography::get_type(),
         [
			'name'		 => 'title_typography',
			'selector'	 => '{{WRAPPER}} .single-topics .ts-title',
			]
        );
        
        $this->add_responsive_control(
            'title_margin',
                [
                    'label' =>esc_html__( 'Title Margin', 'turitor' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .single-topics .ts-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
        );

        $this->end_controls_section();
        
        //Content Style Section
      $this->start_controls_section('section_content_style',
         [
				'label'	 => esc_html__( 'Content', 'turitor' ),
				'tab'	    => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'feature_content_color', [
				'label'		 => esc_html__( 'Content color', 'turitor' ),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .single-topics .ts-title' => 'color: {{VALUE}};',
				],
			]
        );

        $this->add_group_control(Group_Control_Typography::get_type(),
         [
			 'name'		 => 'feature_content_typography',
			 'selector'	 => '{{WRAPPER}} .single-topics p',
			]
        );
        $this->add_responsive_control(
            'feature_content_margin',
                [
                    'label' =>esc_html__( 'Content Margin', 'turitor' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .single-topics p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
        );

		$this->end_controls_section();

		//Icon Style Section
      $this->start_controls_section('section_icon_style',
         [
				'label'	 => esc_html__( 'Icon', 'turitor' ),
				'tab'	   => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control('icon_color', 
          [
				'label'		 => esc_html__( 'Icon color', 'turitor' ),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .single-topics  i' => 'color: {{VALUE}};',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(), [
			'name'		 => 'icon_typography',
			'selector'	 => '{{WRAPPER}} .single-topics  i',
			]
		);
        $this->end_controls_section();
        
		// Box Padding
      $this->start_controls_section('box_padding',
         [
				'label'	 => esc_html__( 'Box Style', 'turitor' ),
				'tab'	   => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_responsive_control(
            'topics_box_padding',
                [
                    'label' =>esc_html__( 'Box Padding', 'turitor' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .single-topics' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'label' => esc_html__( 'Box Shadow', 'turitor' ),
                'selector' => '{{WRAPPER}} .single-topics',
            ]
        ); 

		$this->end_controls_section();


    } //Register control end

    protected function render( ) { 
        $settings  = $this->get_settings();
     	$icon      = $settings["icon"];
		$title     = $settings["title"];
        $desc      = $settings["desc"];
        $link      = $settings['topics_link']['url'];
    ?>
 
    <div class="single-topics">
        <h3 class="ts-title"><?php echo esc_html($title); ?></h3>
        <p>
            <?php echo turitor_kses($desc); ?>
        </p>
        <a href="<?php echo esc_url($link); ?>" target="_blank" class="topics-link">
            <i class="<?php echo esc_attr($icon); ?>"></i>
        </a>
    </div><!-- single intro text end-->
    
    <?php  
    }
    protected function _content_template() { }
}