<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Turitor_Testimonial_Widget extends Widget_Base {

    public function get_name() {
        return 'turitor-testimonial';
    }

    public function get_title() {
        return esc_html__( 'Testimonial', 'turitor' );
    }

    public function get_icon() {
        return 'eicon-testimonial';
    }

    public function get_categories() {
        return ['turitor-elements'];
    }

    protected function _register_controls() {
        
        $this->start_controls_section('section_tab_style',
            [
                'label' => esc_html__('Testimonial carousel', 'turitor'),
            ]
         );
         
         $this->add_control(
            'testimonial_style',
            [
               'label' => esc_html__( 'Testimonial Style', 'turitor' ),
               'type' => \Elementor\Controls_Manager::SELECT,
               'default' => 'default',
               'options' => [
                  'default'  => esc_html__( 'Style 1', 'turitor' ),
                  'style2' =>  esc_html__( 'Style 2', 'turitor' ),
                  'style3' =>  esc_html__( 'Style 3', 'turitor' ),
               ],
            ]
         );

         $this->add_control('show_client_image',
            [
            'label'       => esc_html__('Show  image', 'turitor'),
            'type'        => Controls_Manager::SWITCHER,
            'label_on'    => esc_html__('Yes', 'turitor'),
            'label_off'   => esc_html__('No', 'turitor'),
            'default'     => 'yes',
    
            ]
         );

        $this->add_control('show_navigation',
            [
            'label'       => esc_html__('Show Navigation', 'turitor'),
            'type'        => Controls_Manager::SWITCHER,
            'label_on'    => esc_html__('Yes', 'turitor'),
            'label_off'   => esc_html__('No', 'turitor'),
            'default'     => 'yes',
    
            ]
         ); 
        $this->add_control('show_pagination',
            [
            'label'       => esc_html__('Show Pagination', 'turitor'),
            'type'        => Controls_Manager::SWITCHER,
            'label_on'    => esc_html__('Yes', 'turitor'),
            'label_off'   => esc_html__('No', 'turitor'),
            'default'     => 'yes',
    
            ]
         ); 
         
         $this->add_control('auto_play',
            [
            'label'       => esc_html__('Auto play', 'turitor'),
            'type'        => Controls_Manager::SWITCHER,
            'label_on'    => esc_html__('Yes', 'turitor'),
            'label_off'   => esc_html__('No', 'turitor'),
            'default'     => 'yes',
   
            ]
         ); 

         $this->add_control('auto_loop',
            [
            'label'       => esc_html__('Slider loop', 'turitor'),
            'type'        => Controls_Manager::SWITCHER,
            'label_on'    => esc_html__('Yes', 'turitor'),
            'label_off'   => esc_html__('No', 'turitor'),
            'default'     => 'yes',
   
            ]
        ); 

        $this->add_responsive_control(
			'slider_count',
			[
				'label' => esc_html__( 'Carousel Count', 'turitor' ),
				'type' => Controls_Manager::NUMBER,
                'default' => 3,
			]
        );
        
        $this->add_responsive_control(
			'slider_margin',
			[
				'label' => esc_html__( 'Carousel Gapping', 'turitor' ),
				'type' => Controls_Manager::NUMBER,
                'default' => 40,
			]
        );
        
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'qoute_content', [
                'label'        => esc_html__('Testimonial Content', 'turitor'),
                'type'         => Controls_Manager::TEXTAREA,
                'default'      => esc_html__(' A small river named Duden flows by their place and supplies it with the necessary regelialia. It is
                a paradisematic country, in which', 'turitor'),
                'label_block'  => true,
			]
		);
        $repeater->add_control(
			'qoute_title', [
                'label'       => esc_html__('Client Name', 'turitor'),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__('John Doe', 'turitor'),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'qoute_designation', [
                'label'        => esc_html__('Client designation', 'turitor'),
                'type'         => Controls_Manager::TEXT,
                'default'      => esc_html__('CEO,apple', 'turitor'),
                'label_block'  => true,
			]
		);
        $repeater->add_control(
			'qoute_photo', [
                'label'       => esc_html__('Client Photo', 'turitor'),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
          
        $this->add_control(
			'quote_carousel',
			[
				'label'     => esc_html__('Testimonial Carousel', 'turitor'),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'    => $repeater->get_controls(),
				'default'   => [
					[
						'qoute_title' => esc_html__( 'John Doe', 'turitor' ),
					],
			
				],
				'title_field' => '{{{ qoute_title }}}',
			]
        );
        
        $this->end_controls_section();
        

    
    $this->end_controls_section();
    
       

        //style
        $this->start_controls_section('style_section',
            [
               'label'      => esc_html__( 'Style Section', 'turitor' ),
               'tab'        => Controls_Manager::TAB_STYLE,
            ]
       ); 
      
      $this->add_control('testimonial_text_color',
            [
               'label'      => esc_html__('Content color', 'turitor'),
               'type'       => Controls_Manager::COLOR,
               'selectors'  => [

                     '{{WRAPPER}} .testimonial-author-content .testimonial-text' => 'color: {{VALUE}};',
               ],
            ]
        );
      $this->add_control('testimonial_qoute_color',
            [
               'label'      => esc_html__('Qoute color', 'turitor'),
               'type'       => Controls_Manager::COLOR,
               'selectors'  => [

                     '{{WRAPPER}} .testimonial-author-content .testimonial-text i' => 'color: {{VALUE}};',
                     '{{WRAPPER}} .ts-testimonial-standard.classic .active.center .testimonial-author-content .qoute-icon' => 'color: {{VALUE}};',
               ],
            ]
        );

     

      $this->add_group_control(
        Group_Control_Typography::get_type(),
        [
            'name' => 'Content_typogrphy',
            'label' => esc_html__( 'Content Typography', 'turitor' ),
            
            'selector' => '{{WRAPPER}} .testimonial-author-content .testimonial-text',
        ]
       );

       $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'content_background',
				'label' => esc_html__( 'Background', 'turitor' ),
				'types' => [ 'classic', 'gradient' ],
            'selector' => '{{WRAPPER}} .ts-testimonial-standard',
          
			]
      );


      $this->add_control('box_border',
         [
            'label' => esc_html__( 'Box Border', 'turitor' ),
            'type'       => Controls_Manager::HEADING,
            'condition' => ['testimonial_style' => 'style2'],
         ]
      );
      $this->add_group_control(
         Group_Control_Border::get_type(),
         [
           'name' => 'border',
           'label' => esc_html__( 'Box Border', 'turitor' ),
           'label_block' => true,
           'condition' => ['testimonial_style' => 'style2'],
           'selector' => '{{WRAPPER}} .ts-testimonial-standard .testimonial-author-content',
         ]
     );
     $this->add_control('box_border_active',
      [
         'label' => esc_html__( 'Box Active Border', 'turitor' ),
         'type'       => Controls_Manager::HEADING,
         'condition' => ['testimonial_style' => 'style2'],
      ]
     );
      $this->add_group_control(
         Group_Control_Border::get_type(),
         [
           'name' => 'border_active',
           'label' => esc_html__( 'Box Border Active', 'turitor' ),
           'label_block' => true,
           'condition' => ['testimonial_style' => 'style2'],
           'selector' => '{{WRAPPER}} .ts-testimonial-standard .active.center .testimonial-author-content',
         ]
     );

     $this->add_responsive_control(
        'content_margin',
        [
            'label' => esc_html__( 'Content margin', 'turitor' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'condition' => ['testimonial_style' => 'style2'],
            'selectors' => [
                '{{WRAPPER}} .ts-testimonial-standard .testimonial-author-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
        );
     $this->add_responsive_control(
        'content_padding',
        [
            'label' => esc_html__( 'Content Padding', 'turitor' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'condition' => ['testimonial_style' => 'style2'],
            'selectors' => [
                '{{WRAPPER}} .ts-testimonial-standard .testimonial-author-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
        );
      
      $this->end_controls_section(); 
       
        //style
        $this->start_controls_section('author_section',
            [
               'label'      => esc_html__( 'Testimonial Footer Section', 'turitor' ),
               'tab'        => Controls_Manager::TAB_STYLE,
            ]
       ); 
      
       $this->add_control('client_title_color',
            [
               'label'      => esc_html__('Client Title color', 'turitor'),
               'type'       => Controls_Manager::COLOR,
               'selectors'  => [

                     '{{WRAPPER}} .testimonial-author-content .testimonial-footer .author-name' => 'color: {{VALUE}};',
               ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'client_name_typogrphy',
                'label' => esc_html__( 'Title Typography', 'turitor' ),
                
               
                'selector' => '{{WRAPPER}} .testimonial-author-content .testimonial-footer .author-name',
            ]
        ); 

      $this->add_control('client_designation_color',
        [
           'label'      => esc_html__('Designation color', 'turitor'),
           'type'       => Controls_Manager::COLOR,
           'selectors'  => [
               '{{WRAPPER}} .testimonial-author-content .testimonial-footer .author-designation' => 'color: {{VALUE}};',
           ],
     
        ]
      );
      $this->add_control('slide_pagination_color',
        [
           'label'      => esc_html__('Pagination color', 'turitor'),
           'type'       => Controls_Manager::COLOR,
           'selectors'  => [
               '{{WRAPPER}} .ts-testimonial-standard .owl-carousel .owl-dots .owl-dot' => 'background-color: {{VALUE}};',
           ],
      
        ]
      );

      $this->add_group_control(
         Group_Control_Typography::get_type(),
         [
             'name' => 'client_title_typogrphy',
             'label' => esc_html__( 'Author typography', 'turitor' ),
             
             'selector' => '{{WRAPPER}} .testimonial-author-content .testimonial-footer .author-name',
          
         ]
      );
      
      $this->add_group_control(
         Group_Control_Typography::get_type(),
         [
             'name' => 'client_designation_typogrphy',
             'label' => esc_html__( 'Designation typography', 'turitor' ),
             
             'selector' => '{{WRAPPER}} .testimonial-author-content .testimonial-footer .author-designation',
          
         ]
      );
      
      $this->end_controls_section();  

    }

    protected function render( ) {

        $settings           =     $this->get_settings();
        $quote_carousel     =     $settings['quote_carousel'];
        $show_navigation    =     $settings["show_navigation"];
        $show_pagination    =     $settings["show_pagination"];
        $auto_play          =     $settings["auto_play"];
        $auto_loop          =     $settings["auto_loop"];
        $testimonial_style  =     $settings["testimonial_style"];
        $show_client_image  =     $settings["show_client_image"];
        $carousel_gapping  =     $settings["slider_margin"];
        $slider_count       =     $settings["slider_count"];
        
        $controls = [
           'nav'       => $show_navigation,
           'dot'       => $show_pagination,
           'auto_play' => $auto_play,
           'auto_loop' => $auto_loop,
           'gapping' => $carousel_gapping,
           'slider_count' => $slider_count,
        ];
        $controls = json_encode($controls); 

    
        include (locate_template("components/editor/elementor/widgets/style/testimonial/{$testimonial_style}.php", false, false ));  
    }
    protected function _content_template() { }
}