<?php
   global $post, $wpdb;

   $cat_id = $settings['cat_id'] ? $settings['cat_id'] : array();
   $post_sort_by    = ($settings["post_sort_by"] ? $settings["post_sort_by"] : 'DESC');
   $post_count    = ($settings["post_count"] ? $settings["post_count"]  : 3);






   $args = array(
        'post_type'      => 'sfwd-courses',
        'posts_per_page' => $post_count,
        'order'          => $post_sort_by,   
        'post_status'      => 'publish',

    ); 

    if ( is_array($cat_id) && count($cat_id) ) {

		$args['tax_query'] = array(
			array(
				'taxonomy' => 'ld_course_category',
				'field'    => 'term_id',
				'terms'    => $cat_id
			),
		);
	
}

    $the_query = new \WP_Query($args);
?>

<div class="turitor-learndash-course row">   
    <?php
    if ( $the_query->have_posts() ) { 

        while ( $the_query->have_posts() ) : $the_query->the_post();

                    
            global $post; $post_id = $post->ID;
            $course_id = $post_id;
            $user_id   = get_current_user_id();
            $current_id = $post->ID;

            $options = get_option('sfwd_cpt_options');


            $currency = null;

            if ( ! is_null( $options ) ) {
                if ( isset($options['modules'] ) && isset( $options['modules']['sfwd-courses_options'] ) && isset( $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'] ) )
                    $currency = $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'];

            }

            if( is_null( $currency ) )
                $currency = 'USD';

            $course_options = get_post_meta($post_id, "_sfwd-courses", true);

            $price = $course_options && isset($course_options['sfwd-courses_course_price']) ? $course_options['sfwd-courses_course_price'] : esc_html__( 'Free', 'turitor' );

            $has_access   = sfwd_lms_has_access( $course_id, $user_id );
            $is_completed = learndash_course_completed( $user_id, $course_id );

            if( $price == '' )
                $price .= esc_html__( 'Free', 'turitor' );

            if ( is_numeric( $price ) ) {
                if ( $currency == "USD" )
                    $price = '$' . $price;
                else
                    $price .= ' ' . $currency;
            }

            $class       = '';
            $ribbon_text = '';

            if ( $has_access && ! $is_completed ) {
                $class = 'ld_course_grid_price ribbon-enrolled';
                $ribbon_text = esc_html__( 'Enrolled', 'turitor' );
            } elseif ( $has_access && $is_completed ) {
                $class = 'ld_course_grid_price';
                $ribbon_text = esc_html__( 'Completed', 'turitor' );
            } else {
                $class = ! empty( $course_options['sfwd-courses_course_price'] ) ? 'ld_course_grid_price price_' . $currency : 'ld_course_grid_price free';
                $ribbon_text = $price;
            }


            $terms = get_the_terms( $post->ID, 'ld_course_category' );
            $cat = '';
            $cat_with_link = '';
            $cat_color = '';
            if(is_array($terms)):
                foreach($terms as $tkey=>$term):
                    $cat.= $term->name.' ';
                    $cat_color = turitor_term_meta_option($term->term_id, 'ld_course_category','turitor_ld_course_cat_color');

                endforeach;

            endif; 
            $cat_with_link = turitor_ld_course_cageory_by_id($post->ID, 'ld_course_category');
            ?>
            <div class="col-lg-4 col-md-6">

                <div class="ld-single-course">
                    <?php if ( has_post_thumbnail() ):?>
                        <div class="image">
                            <a href="<?php the_permalink(); ?>">
                                <?php the_post_thumbnail();?>
                            </a>
                        </div>
                    <?php endif; ?>


                    <div class="course-category">
                        <span style="background-color: <?php echo esc_attr($cat_color); ?>">
                            <?php 
                                echo turitor_kses($cat_with_link);
                            ?> 
                        </span>
                    </div>
                    <div class="ld-course-conent">
                        <h3 class="ts-title">
                                <a href="<?php the_permalink(); ?>">
                                    <?php echo get_the_title();?>
                                </a>
                        </h3>

                    </div>
                    <div class="ld-course-footer">
                        <span class="ld-course-price"><?php echo esc_html($ribbon_text); ?></span>
                        <?php if( ! $has_access): ?>
                            <span class="ld-course-read-more">
                                <a href="<?php the_permalink(); ?>">
                                    <?php echo esc_html__("Enroll Now","turitor");?>
                                </a>
                                <i class="tsicon tsicon-ts-plus1"></i>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

        <?php 
        
        endwhile;
        
         wp_reset_postdata();
        }
    ?>
 </div><!-- .row -->



 