<?php

global $post, $wpdb;
$random     = rand( 1, 99 );
$limit_tab  = $turitor_course_settings['tabs-options']['limit_tab'] ? $turitor_course_settings['tabs-options']['limit_tab'] : 4;
$cat_id_tab = $turitor_course_settings['tabs-options']['cat_id_tab'] ? $turitor_course_settings['tabs-options']['cat_id_tab'] : array();
$limit      = $turitor_course_settings['limit'];
$featured   = ! empty( $turitor_course_settings['featured'] ) ? true : false;
$sort       = $turitor_course_settings['order'];
$thumb_w    = ( ! empty( $turitor_course_settings['thumbnail_width'] ) && '' != $turitor_course_settings['thumbnail_width'] ) ? $turitor_course_settings['thumbnail_width'] : apply_filters( 'thim_course_thumbnail_width', 450 );
$thumb_h    = ( ! empty( $turitor_course_settings['thumbnail_height'] ) && '' != $turitor_course_settings['thumbnail_height'] ) ? $turitor_course_settings['thumbnail_height'] : apply_filters( 'thim_course_thumbnail_height', 400 );



$condition = array(
	'post_type'           => 'lp_course',
	'posts_per_page'      => $limit,
	
);

if ( count($cat_id_tab) ) {

		$condition['tax_query'] = array(
			array(
				'taxonomy' => 'course_category',
				'field'    => 'term_id',
				'terms'    => $cat_id_tab
			),
		);
	
}

if ( $sort == 'popular' ) {
	global $wpdb;
	$query = $wpdb->prepare( "
	  SELECT ID, a+IF(b IS NULL, 0, b) AS students FROM(
		SELECT p.ID as ID, IF(pm.meta_value, pm.meta_value, 0) as a, (
				SELECT COUNT(*)
			FROM (SELECT COUNT(item_id), item_id, user_id FROM {$wpdb->prefix}learnpress_user_items GROUP BY item_id, user_id) AS Y
			GROUP BY item_id
			HAVING item_id = p.ID
			) AS b
			FROM {$wpdb->posts} p
			LEFT JOIN {$wpdb->postmeta} AS pm ON p.ID = pm.post_id  AND pm.meta_key = %s
			WHERE p.post_type = %s AND p.post_status = %s
			GROUP BY ID
			) AS Z
			ORDER BY students DESC
				LIMIT 0, $limit
			", '_lp_students', 'lp_course', 'publish' );

	$post_in = $wpdb->get_col( $query );

	$condition['post__in'] = $post_in;
	$condition['orderby']  = 'post__in';
}

if( $featured ) {
	$condition['meta_query'] = array(
		array(
			'key' => '_lp_featured',
			'value' =>  'yes',
		)
	);
}


$the_query = new WP_Query( $condition );
?>

	<div class="tab-course-category">
		<ul>
	      	<li class="active filter" data-filter="all"> <?php echo esc_html__('All','turitor'); ?> </li>
			<?php	
				foreach((array)$cat_id_tab as $key=> $tacat_id):
					if($key==$limit_tab){
						break;
					}

				$category =  get_term($tacat_id);
				
			?>
			<li class="filter" data-filter="<?php echo esc_attr('.'.$category->slug); ?>"><?php echo esc_html($category->name); ?></li>
			<?php endforeach; ?>  
		</ul>
	</div>  
	<?php 
	

if ( $the_query->have_posts() ) :
	?>
	  <div class="row ts-mix-tab-course mixcontent" id="mixcontent" >
			<?php
				while ( $the_query->have_posts() ) : $the_query->the_post();
				$terms = get_the_terms( $post->ID, 'course_category' );
				$cat = '';
				$cat_with_link = '';
				
					if(is_array($terms)):

						foreach($terms as $tkey=>$term):
					     	
						  $cat.= $term->slug.' ';
						

						endforeach;

					endif; 
					$cat_with_link = turitor_course_cageory_by_id($post->ID);

				    $course    = LP()->global['course'];
				   
				    $lessons = $course->get_curriculum_items( 'lp_lesson' )? count( $course->get_curriculum_items( 'lp_lesson' ) ) : 0;
					$students_enrolled = $course->get_users_enrolled();
					$instructor = $course->get_instructor();
					$instructor_link = $course->get_instructor_html();
					$instructor_id = $course->get_id();
					$meta = get_post_meta( $post->ID );
									
					$featured = isset($meta['_lp_featured'][0]) ? $meta['_lp_featured'][0] : '';
					
								  
				  ?>
				    <div class="col-lg-4 mix col-sm-6 ts-mb-10 <?php echo trim($cat); ?> ">
						
							<div class="single-course">

								 <div class="course-category">
										<?php 
										  echo wp_kses_post($cat_with_link);
										?> 
								 </div>
								 <h3 class="ts-course-el-title"> 
									<a href="<?php echo esc_url($course->get_permalink()); ?>">
										<?php echo esc_html($post->post_title); ?> 
									</a>	
								</h3>
								<div class="enrol-list-area">
									<ul class="course-enrole-list">
										<li class="lessons">
											<i class="tsicon tsicon-file"></i> 
											<?php echo esc_html($lessons); ?>
											<?php echo esc_html__(' Lessons', 'turitor'); ?>
										</li>
										<li class="students">
												<i class="tsicon tsicon-user_group"></i> 
												<?php echo esc_html($course->count_students()); ?> 
										</li>
									</ul>
									<div class="instructor">  
										<?php 
												$dir = learn_press_user_profile_picture_upload_dir();
												$user = get_user_by( 'id', $instructor->get_id());
												$pro_link = get_user_meta($user->ID,'_lp_profile_picture',true); 
												$base_url = isset($dir['baseurl'])?$dir['baseurl']:'';
												$profile_link =  $base_url.'/'.$pro_link;
										?>
									
										<?php if($pro_link !=''){ ?>
												<div class="instructor-thumb">
													<img src="<?php echo esc_url($profile_link); ?>" alt="<?php  echo  esc_attr($user->display_name); ?>">
												</div>
												<?php  echo wp_kses_post($instructor_link) ?>

                            <?php }else{ ?>
												<div class="instructor-thumb">
													<img src="<?php echo esc_url( get_avatar_url( $instructor->get_id() ) ); ?> " alt="<?php echo esc_attr($user->display_name); ?>"> 
												</div>
												<?php  echo wp_kses_post($instructor_link) ?>

									 <?php } ?>
									</div>
								</div>

								<div class="course-thumb">
										<?php 
										$course_intro_img = turitor_meta_option( $post->ID,'course_intro_img' );
										?>
										<?php if(isset($course_intro_img['url']) && $course_intro_img['url'] !=''){ ?>
												<img class="img-fluid"  src="<?php echo esc_url($course_intro_img['url']); ?>" alt="<?php echo esc_html($post->post_title); ?>">
										<?php }else{ ?>
												<img class="img-fluid"  src="<?php echo esc_url(get_the_post_thumbnail_url( $post->ID, 'large' )); ?>" alt="<?php echo esc_html($post->post_title); ?>">
										<?php } ?>

								</div>


								<img class="course-shap" src="<?php echo esc_url_raw(TURITOR_IMG.'/shape_combined.svg');  ?>" alt="<?php echo esc_attr__('shape', 'turitor'); ?>">
								
								<div class="course-footer">
									<?php 
									if(defined('WUR_REVIEW_KEY')) {
										echo	review_kit_rating( [ 'post-id' => $post->ID, 'ratting-show' => 'yes', 'ratting-style' => 'star', 'count-show' => 'no', 'vote-show' => 'yes', 'vote-text' => 'votes', 'return-type' => '' ]);
									}
									?>
								<div class="course-price-item">
									<?php if($course->is_free()): ?>
									<span class="free-course"> <?php echo esc_html__('Free','turitor'); ?> </span> 
									<?php else: ?>
									<span class="course-price">							
										<?php echo turitor_kses($course->get_price_html()); ?>
										<?php endif; ?>
									</span>
									</div>
								</div>
							</div>
					</div>
				  <?php
				  
				endwhile;
			?>
	 </div>
	<?php
endif;



