<?php

// grid
    $category_limit = $turitor_course_settings['grid-options']['grid_limit'];
    $grid_column    = $turitor_course_settings['grid-options']['grid_column'];
    $categories_id  = $turitor_course_settings['grid-options']['categories_id'];
    $hide_empty     = $turitor_course_settings['hide_empty']=='yes'?'1':'0';
    $course_count_show     = $turitor_course_settings['course_count_show']=='yes'?'yes':'no';

    $taxonomy       = 'course_category';
     
    if(count($categories_id)){
        $cats = $categories_id;
    }else{

        $args_cat = array(
            'taxonomy'     => $taxonomy,
            'number' => $category_limit,
            'hide_empty' => $hide_empty,
        
        );
        
        $cats = get_categories( $args_cat );
    }
  
//view
   ?>
    <div class="ts-course-category grid-style2">
        <div class="row"> 
           <?php  foreach($cats as $value){ ?>
                <div class="col-lg-<?php echo esc_attr($grid_column); ?> col-md-6">
                    <div class="single-course-category">
                    <img class="course-dot-shape" src="<?php echo esc_url( TURITOR_IMG . '/dot_shape.svg'); ?>" alt="<?php echo esc_attr__('shape-img', 'turitor'); ?>">
                
                            <div class="course-media">
                                <?php $term = get_term($value,$taxonomy); ?>
                                <?php 
                                        $image = turitor_term_meta_option($term->term_id,$taxonomy,'turitor_course_cat');
                                    ?>
                                    <?php if(isset($image['url'])): ?>
                                    <img src=" <?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($term->name); ?>">
                                <?php endif; ?>
                            </div>
                 
                        <div class="course-content">
                            <?php 
                            $term_link = get_term_link($term->slug, $taxonomy);
                         
                            ?>
                            <h3 class="course-category-title"> <a href="<?php echo esc_url($term_link); ?>"><?php echo esc_html($term->name); ?></a>  </h3>
                            <?php if($course_count_show == 'yes'): ?>
                                <p class="course-count"> 
                                    <?php
                                    printf( _nx( '%s Course', '%s Courses', $term->count, 'Courses', 'turitor' ), number_format_i18n( $term->count ) );
                                    ?> 
                                </p>
                             <?php endif; ?>
                        </div>
                        <!-- dot shap -->
                    </div> 
                 </div> 
           <?php } ?>
        </div>
    </div>
   <?php 
   





