<?php
$members_args = array(
    'per_page'        => $member_count,
    'type'        => $member_order
);

$column_count = round(12/$post_col);
$class[] = 'col-md-4 col-sm-6 col-lg-'.$column_count;

if ( bp_has_members( $members_args ) ) : ?> 
 
 <?php do_action( 'bp_before_directory_members_list' );  ?>
        <div id="members-dir-list" class="row members dir-list">
            <?php while ( bp_members() ) : bp_the_member(); ?>
                <div <?php bp_member_class($class); ?>>
                    <?php turitor_bp_member_item(); ?>
                </div>
            <?php endwhile; ?>
        </div><!-- #members-dir-list -->
    <?php

    /**
     * Fires and displays the members content.
     *
     * @since 1.1.0
     */
    do_action( 'bp_directory_members_content' ); ?>

    <?php wp_nonce_field( 'directory_members', '_wpnonce-member-filter' ); ?>

    <?php

    /**
     * Fires after the display of the members content.
     *
     * @since 1.1.0
     */
    do_action( 'bp_after_directory_members_content' ); ?>


<?php do_action( 'bp_after_directory_members_list' ); ?>

<?php bp_member_hidden_fields(); ?>

<?php else: ?>

  <div id="message" class="info">
	 <p><?php esc_html_e( 'Sorry, no members were found.', 'turitor' ); ?></p>
  </div>

<?php endif; ?>