<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Turitor_Service_Slider_Widget extends Widget_Base {


  public $base;

    public function get_name() {
        return 'turitor-service-slider';
    }

    public function get_title() {

        return esc_html__( 'Turitor Service slider', 'turitor' );

    }

    public function get_icon() { 
        return 'eicon-slider-push';
    }
    public function get_categories() {
        return [ 'turitor-elements' ];
    }
    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Slider settings', 'turitor'),
            ]
        );
       
        $this->add_control(
			'style',
			[
				'label' => esc_html__( 'Slider Style', 'turitor' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1'  => esc_html__( 'Style 1', 'turitor' ),
					'style2'  => esc_html__( 'Style 2', 'turitor' ),
					
				],
			]
         );

         $this->add_control(
			'count_show',
			[
				'label' => esc_html__( 'count', 'turitor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 3,
				'max' => 100,
				'step' => 1,
				'default' => 3,
			]
		);
   
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'slider_main_title', [
                'label' => esc_html__('Slider  Title','turitor'),
                'type'         => Controls_Manager::TEXT,
                'default'      => esc_html__('Learn Anytime, Anywhere Accelerate ', 'turitor'),
                'label_block'  => true,
			]
        );
        $repeater->add_control(
			'service_slider_icon', [
                'label'       => esc_html__('Slider Icon', 'turitor'),
                'type' => Controls_Manager::ICONS,
                'label_block' => true,
                'separator'   => 'after',
                'default' => [
                    'value' => 'fa fa-clock-o',
                    'library' => 'solid',
                ]
			]
        );
        $repeater->add_control(
			'slider_desc', [
                'label' => esc_html__('Slider description','turitor'),
                'type'         => Controls_Manager::WYSIWYG,
                'default'      => esc_html__('We believe everyone has the ', 'turitor'),
                'label_block'  => true,
			]
        );
        $repeater->add_control(
			'slider_bg_image', [
                'label'       => esc_html__('Background Image', 'turitor'),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'separator'   => 'after',
			]
        );
        $repeater->add_control(
			'button_text', [
                'label'        => esc_html__('Read more', 'turitor'),
                'type'         => Controls_Manager::TEXT,
                'default'      => esc_html__('Button', 'turitor'),
                'label_block'  => true,
			]
        );
        $repeater->add_control(
			'button_url', [
                'label'            => esc_html__( 'Read more url ', 'turitor' ),
                'type'             => \Elementor\Controls_Manager::URL,
                'label_block'      => true,
                'separator'        => 'after', 
			]
        );

        $this->add_control(
			'slider_items',
			[
				'label'     => esc_html__( 'Service Slider', 'turitor' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'    => $repeater->get_controls(),
				'default'   => [
					[
						'slider_main_title' => esc_html__('Learn Anytime, Anywhere Accelerate ', 'turitor'),
					],
					[
						'slider_main_title' => esc_html__('Learn Anytime, Anywhere Accelerate ', 'turitor'),
					],
					[
						'slider_main_title' => esc_html__('Learn Anytime, Anywhere Accelerate ', 'turitor'),
					],
			
				],
				'title_field' => '{{{ slider_main_title }}}',
			]
		);
        
     
      $this->end_controls_section();

        //style
        $this->start_controls_section('style_section',
            [
               'label'    => esc_html__( 'Style Section', 'turitor' ),
               'tab'      => Controls_Manager::TAB_STYLE,
            ]
       ); 
     
          
       $this->add_control(
        'ts_slider_autoplay',
            [
            'label' => esc_html__( 'Autoplay', 'turitor' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'turitor' ),
            'label_off' => esc_html__( 'No', 'turitor' ),
            'return_value' => 'yes',
            'default' => 'no'
            ]
        );

        $this->add_control(
			'ts_slider_speed',
            [
               'label' => esc_html__( 'Slider Speed', 'turitor' ),
               'type' => \Elementor\Controls_Manager::NUMBER,
               'placeholder' => esc_html__( 'Enter Slider Speed', 'turitor' ),
               'default' => 5000,
               'condition' => ["ts_slider_autoplay" => ['yes']],
            ]
		  );

        $this->add_control(
        'ts_slider_nav_show',
            [
            'label' => esc_html__( 'Nav show', 'turitor' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'turitor' ),
            'label_off' => esc_html__( 'No', 'turitor' ),
            'return_value' => 'yes',
            'condition' => ['style' => ['style1']],
            'default' => 'yes'
            ]
        );
        $this->add_control(
         'ts_slider_dot_nav_show',
             [
             'label' => esc_html__( 'Dot nav', 'turitor' ),
             'type' => \Elementor\Controls_Manager::SWITCHER,
             'label_on' => esc_html__( 'Yes', 'turitor' ),
             'label_off' => esc_html__( 'No', 'turitor' ),
             'return_value' => 'yes',
             'default' => 'yes'
             ]
         );

         $this->add_responsive_control(
			'slide_gap',
			[
				'label' => esc_html__( 'Slide Gap', 'turitor' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 15,
				'max' => 100,
				'step' => 1,
                'default' => 15,
                'condition' => ['style' => ['style1']],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section('title_style_section',
         [
            'label'    => esc_html__( 'Slider Content ', 'turitor' ),
            'tab'      => Controls_Manager::TAB_STYLE,
         ]
       );

     
     

        $this->add_responsive_control(
            'slider_icon_radius',
            [
                'label' => esc_html__( 'Slider icon Radius', 'turitor' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .service-slider .owl-item .item .single-service .service-info .service-info-content .service-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => ['style' => ['style1']],
            ]
        );
  
        $this->add_control('slider_icon_color',
            [
                'label'     => esc_html__('Icon color', 'turitor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .service-slider .owl-item .item .single-service .service-info .service-info-content .service-icon i' => 'color: {{VALUE}};',
                ],
                'condition' => ['style' => ['style1']],
            ]
        );  

        $this->add_control('slider_iconhv_color',
        [
            'label'     => esc_html__('Icon hv color', 'turitor'),
            'type'      => Controls_Manager::COLOR,
            'default'   => '',
            'selectors' => [
                '{{WRAPPER}} .service-slider .owl-item .item .single-service:hover .service-info .service-info-content .service-icon i' => 'color: {{VALUE}} !important;',
            ],
            'condition' => ['style' => ['style1']],
        ]
       );  

       $this->add_control('slider_icon_bgcolor',
            [
                'label'     => esc_html__('Icon bgcolor', 'turitor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .service-slider .owl-item .item .single-service .service-info .service-info-content .service-icon' => 'background: {{VALUE}};',
                ],
                'condition' => ['style' => ['style1']],
            ]
        );
        $this->add_control('slider_icon_hv_bgcolor',
            [
                'label'     => esc_html__('Icon hover bgcolor', 'turitor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .service-slider .owl-item .item .single-service:hover .service-info .service-info-content .service-icon' => 'background: {{VALUE}};',
                ],
                'condition' => ['style' => ['style1']],
            ]
        );
      
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'icons_typography',
				'label' => esc_html__( 'Icon Typography', 'turitor' ),
				
                'selector' => '{{WRAPPER}} .service-slider .owl-item .item .single-service .service-info .service-info-content .service-icon i',
                'condition' => ['style' => ['style1']],
			]
        );
         $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__( 'Title Typography', 'turitor' ),
				
                'selector' => '{{WRAPPER}} .service-slider-area .service-title ',
			]
        );
        
        $this->add_control('slider_titles_color',
        [
            'label'     => esc_html__('Title color', 'turitor'),
            'type'      => Controls_Manager::COLOR,
            'default'   => '',
            'selectors' => [
                '{{WRAPPER}} .service-slider-area .service-title' => 'color: {{VALUE}};',
            ],
        ]
       ); 
      
        $this->add_control('slider_titles_active_color',
        [
            'label'     => esc_html__('Title active color', 'turitor'),
            'type'      => Controls_Manager::COLOR,
            'default'   => '',
            'selectors' => [
                '{{WRAPPER}} .service-slider-area .owl-item.active.current .service-title' => 'color: {{VALUE}};',
            ],
            'condition' => ['style' => ['style2']],
        ]
       ); 
      
       $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__( 'title Margin', 'turitor' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .service-slider-area .service-info-content .service-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .service-slider-2.searvice-slider-list-item li h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control('slider_desc_color',
        [
            'label'     => esc_html__('Desc color', 'turitor'),
            'type'      => Controls_Manager::COLOR,
            'default'   => '',
            'selectors' => [
                '{{WRAPPER}} .service-slider-area .service-info-content p' => 'color: {{VALUE}};',
            ],
        ]
       ); 

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_desc_typography',
				'label' => esc_html__( 'Desc typography', 'turitor' ),
				
				'selector' => '{{WRAPPER}} .service-slider-area .service-info-content p',
			]
        );
     
       $this->add_group_control(
        Group_Control_Background::get_type(),
            [
                'name' => 'slider_box_background',
                'label' => esc_html__( 'Box Background', 'turitor' ),
                'types' => [ 'classic'],
                'selectors' => [
                    '{{WRAPPER}} .service-slider .owl-item .item .single-service:after',
                ],
                'condition' => ['style' => ['style1']],
            ]
        ); 

        $this->add_control('slider_desc_bg_color',
        [
            'label'     => esc_html__('Content Box color', 'turitor'),
            'type'      => Controls_Manager::COLOR,
            'default'   => '',
            'selectors' => [
                '{{WRAPPER}} .service-slider-2 .service-info-content' => 'background-color: {{VALUE}};',
            ],
            'condition' => ['style' => ['style2']],
        ]
       ); 
     
        $this->end_controls_section();  

      $this->start_controls_section('button_style_section',
         [
            'label'    => esc_html__( 'Read more', 'turitor' ),
            'tab'      => Controls_Manager::TAB_STYLE,
         ]
      );

      $this->add_control('slider_button_text_color',
      [
      'label'     => esc_html__('Read more color', 'turitor'),
      'type'      => Controls_Manager::COLOR,
      'default'   => '',
      'selectors' => [
              '{{WRAPPER}} .service-slider-area .service-info-content .ts-btn a' => 'color: {{VALUE}};',
      
          ],
        ]
      );

    $this->add_group_control(
        Group_Control_Typography::get_type(),
        [
            'name' => 'service_btn_typography',
            'label' => esc_html__( 'Read more typography', 'turitor' ),
            
            'selector' => '{{WRAPPER}} .service-slider-area .service-info-content .ts-btn a',
        ]
    );
      
    $this->end_controls_section(); 

    $this->start_controls_section('nav_style_section',
        [
        'label'    => esc_html__( 'Nav', 'turitor' ),
        'tab'      => Controls_Manager::TAB_STYLE,
        ]
    );

    $this->add_control('slider_nav_color',
    [
        'label'     => esc_html__('Nav Color', 'turitor'),
        'type'      => Controls_Manager::COLOR,
        'default'   => '',
        'selectors' => [
            '{{WRAPPER}} .service-slider .owl-nav .owl-next' => 'color: {{VALUE}};',
        ],
        'condition' => ['style' => ['style1']],
    ]
    ); 

    $this->add_control('slider_nav_bgcolor',
    [
        'label'     => esc_html__(' nav bg Color', 'turitor'),
        'type'      => Controls_Manager::COLOR,
        'default'   => '',
        'selectors' => [
            '{{WRAPPER}} .service-slider .owl-nav .owl-prev,.service-slider .owl-nav .owl-next' => 'background-color: {{VALUE}};border-color:{{VALUE}} ',
        ],
        'condition' => ['style' => ['style1']],
    ]
    ); 

    $this->add_control('slider_nav_hvcolor',
    [
        'label'     => esc_html__('hover Color', 'turitor'),
        'type'      => Controls_Manager::COLOR,
        'default'   => '',
        'selectors' => [
            '{{WRAPPER}} .service-slider .owl-nav .owl-next:hover' => 'color: {{VALUE}};',
        ],
        'condition' => ['style' => ['style1']],
    ]
    ); 

    $this->add_control('slider_nav_hvbgcolor',
    [
        'label'     => esc_html__(' hover bg Color', 'turitor'),
        'type'      => Controls_Manager::COLOR,
        'default'   => '',
        'selectors' => [
            '{{WRAPPER}} .service-slider .owl-nav .owl-prev:hover,.service-slider .owl-nav .owl-next:hover' => 'background-color: {{VALUE}}; border-color:{{VALUE}}',
        ],
        'condition' => ['style' => ['style1']],
    ]
    ); 

    $this->add_control('slider_dot_color',
    [
        'label'     => esc_html__(' Dot Color', 'turitor'),
        'type'      => Controls_Manager::COLOR,
        'default'   => '',
        'selectors' => [
            '{{WRAPPER}} .owl-carousel .owl-dots .owl-dot' => 'background-color: {{VALUE}};',
        ],
        'condition' => ['style' => ['style2']],
    ]
    ); 
    $this->add_control('slider_dot_active_color',
    [
        'label'     => esc_html__(' Dot Active Color', 'turitor'),
        'type'      => Controls_Manager::COLOR,
        'default'   => '',
        'selectors' => [
            '{{WRAPPER}} .owl-carousel .owl-dots .owl-dot.active' => 'border-color: {{VALUE}}; background: transparent;',
        ],
        'condition' => ['style' => ['style2']],
    ]
    ); 

    $this->end_controls_section(); 

    
    }

    protected function render( ) { 
        $settings = $this->get_settings();
        $slider_items = $settings['slider_items'];
       
        $show_navigation   =   $settings["ts_slider_nav_show"]=="yes"?true:false;
        $auto_nav_slide    =   $settings['ts_slider_autoplay'];
        $dot_nav_show      =   $settings['ts_slider_dot_nav_show'];
        $ts_slider_speed   =   $settings['ts_slider_speed'];
        $count_show   =   $settings['count_show'];
        $slide_gap   =   $settings['slide_gap'];


        $slide_controls    = [
         'show_nav'=>$show_navigation, 
         'dot_nav_show'=>$dot_nav_show, 
         'auto_nav_slide'=>$auto_nav_slide, 
         'ts_slider_speed'=>$ts_slider_speed, 
         'count_show'=>$count_show, 
         'slide_gap'=>$slide_gap, 
        ];
   
        $slide_controls = \json_encode($slide_controls); 

        if($settings['style']=='style1'):   
            include (locate_template("components/editor/elementor/widgets/style/service-slider/default.php", false, false ));  
        endif;

        if($settings['style']=='style2'):   
            include (locate_template("components/editor/elementor/widgets/style/service-slider/style2.php", false, false ));  
        endif;

     
    ?>
    
    <?php  
    }
    protected function _content_template() { }
}