<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Turitor_News_Widget extends Widget_Base {


    public $base;

    public function get_name() {
        return 'turitor-latestnews';
    }

    public function get_title() {
        return esc_html__( 'News blog ', 'turitor' );
    }

    public function get_icon() { 
        return 'eicon-posts-grid';
    }

    public function get_categories() {
        return [ 'turitor-elements' ];
    }

    protected function _register_controls() {
		$this->start_controls_section(
			'section_tab', [
				'label' => esc_html__( 'Latest news', 'turitor' ),
			]
        );
      
      $this->add_control(
         'post_count',
                     [
                        'label'         => esc_html__( 'Post count', 'turitor' ),
                        'type'          => Controls_Manager::NUMBER,
                        'default'       => '3',

                     ]
      );

      $this->add_control('post_category',
         [
            'label'     => esc_html__( 'Category', 'turitor' ),
            'type'      => \Elementor\Controls_Manager::SELECT2,
            'multiple'  => true,
            'default'   => [],
            'options'   => $this->getCategories(),
         
         ]
      ); 

      $this->add_control(
			'post_col',
			[
				'label'   => esc_html__( 'Post Column', 'turitor' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '3',
				'options' => [
					'3'  => esc_html__( '4 Column ', 'turitor' ),
					'4'  => esc_html__( '3 Column', 'turitor' ),
					'6'  => esc_html__( '2 Column', 'turitor' ),
			
				],
			]
		);
      $this->add_control(
         'post_title_crop',
         [
           'label'         => esc_html__( 'Title limit', 'turitor' ),
           'type'          => Controls_Manager::NUMBER,
           'default'       => '3',
           
         ]
       ); 

       $this->add_control(
         'post_sort_by',
         [
            'label' => esc_html__( 'Sort By', 'turitor' ),
            'type' => Controls_Manager::SELECT,
            'default' => 'DESC',
            'options' => [
                    'ASC'  => esc_html__( 'ASC', 'turitor' ),
                    'DESC'  => esc_html__( 'DESC', 'turitor' ),
                ],
               
         ]
      );
       
      $this->add_control(
         'show_desc',
         [
             'label'     => esc_html__('Show description', 'turitor'),
             'type'      => Controls_Manager::SWITCHER,
             'label_on'  => esc_html__('Yes', 'turitor'),
             'label_off' => esc_html__('No', 'turitor'),
             'default'   => 'yes',
            
         ]
      ); 
      $this->add_control('desc_limit',
            [
              'label'         => esc_html__( 'Description limit', 'turitor' ),
              'type'          => Controls_Manager::NUMBER,
              'default'       => '10',
              'condition'     => [ 
                 'show_desc' => ['yes'] 
               ],
              
            ]
      );   
    
      $this->add_control('show_cat',
            [
                'label'     => esc_html__('Show category', 'turitor'),
                'type'      => Controls_Manager::SWITCHER,
                'label_on'  => esc_html__('Yes', 'turitor'),
                'label_off' => esc_html__('No', 'turitor'),
                'default'   => 'yes',
            ]
        );

      $this->add_control('show_date',
        [
            'label'     => esc_html__('Show Date', 'turitor'),
            'type'      => Controls_Manager::SWITCHER,
            'label_on'  => esc_html__('Yes', 'turitor'),
            'label_off' => esc_html__('No', 'turitor'),
            'default'   => 'yes',
        ]
     ); 

      $this->add_control(
         'show_author',
               [
                  'label'     => esc_html__('Show Author', 'turitor'),
                  'type'      => Controls_Manager::SWITCHER,
                  'label_on'  => esc_html__('Yes', 'turitor'),
                  'label_off' => esc_html__('No', 'turitor'),
                  'default'   => 'no',
         
               ]
         );

      $this->add_control('show_readmore',
                  [
                     'label'     => esc_html__('Show Readmore', 'turitor'),
                     'type'      => Controls_Manager::SWITCHER,
                     'label_on'  => esc_html__('Yes', 'turitor'),
                     'label_off' => esc_html__('No', 'turitor'),
                     'default'   => 'yes',
            
                  ]
            );   

       
      $this->end_controls_section();

      $this->start_controls_section('style_meta_section',
         [
            'label' => esc_html__( 'meta', 'turitor' ),
            'tab' => Controls_Manager::TAB_STYLE,
         ]
      ); 
   
   $this->add_control(
      'post_meta_colors',
      [
          'label' => esc_html__('meta color', 'turitor'),
          'type' => Controls_Manager::COLOR,
          'default' => '',
          'selectors' => [
               '{{WRAPPER}} .latest-blog .post .post-meta span' => 'color: {{VALUE}};',
          ],
      ]
     );

      $this->add_control(
         'post_meta_color_hover',
            [
               'label'     => esc_html__('meta hover', 'turitor'),
               'type'      => Controls_Manager::COLOR,
               'default'   => '',
               'selectors' => [
                  '{{WRAPPER}} .latest-blog .post .post-meta span:hover' => 'color: {{VALUE}};',
                  '{{WRAPPER}} .latest-blog .post .post-meta span:before' => 'background: {{VALUE}};',
            
               ],
            ]
      );

      $this->add_group_control(
         Group_Control_Typography::get_type(), [
         'name'		 => 'meta_typography',
         'selector'	 => '{{WRAPPER}} .latest-blog .post .post-meta span',
         ]
      );
   
      $this->end_controls_section();
      
      $this->start_controls_section('style_title_section',
			[
				'label' => esc_html__( 'Title', 'turitor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
      ); 
      
      $this->add_control(
         'post_text_color',
         [
             'label' => esc_html__('Title color', 'turitor'),
             'type' => Controls_Manager::COLOR,
             'default' => '',
             'selectors' => [
                  '{{WRAPPER}} .post .entry-title a' => 'color: {{VALUE}};',
             ],
         ]
        );

      $this->add_control(
         'post_text_color_hover',
            [
               'label'     => esc_html__('Title hover', 'turitor'),
               'type'      => Controls_Manager::COLOR,
               'default'   => '',
               'selectors' => [
                  '{{WRAPPER}} .post .entry-title a:hover' => 'color: {{VALUE}};',
            
               ],
            ]
        );

      $this->add_group_control(
         Group_Control_Typography::get_type(), [
         'name'		 => 'title_typography',
         'selector'	 => '{{WRAPPER}} .post .entry-title',
         ]
      );
      $this->add_responsive_control(
         'title_margin',
         [
            'label' => esc_html__( 'Tilte margin', 'turitor' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
               '{{WRAPPER}} .post .entry-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
         ]
         );


      $this->end_controls_section();
     
      $this->start_controls_section('style_content_section',
         [
            'label' => esc_html__( 'Content', 'turitor' ),
            'tab' => Controls_Manager::TAB_STYLE,
            'condition'     => [ 
               'show_desc' => ['yes'] 
             ],
         ]
      ); 
      
      $this->add_control(
         'post_content_color',
         [
             'label' => esc_html__('Content color', 'turitor'),
             'type' => Controls_Manager::COLOR,
             'default' => '',
             'selectors' => [
                  '{{WRAPPER}} .post .entry-content p' => 'color: {{VALUE}};',
             ],
         ]
        );

      $this->add_group_control(
         Group_Control_Typography::get_type(), [
         'name'		 => 'content_typography',
         'selector'	 => '{{WRAPPER}} .post .entry-content p',
         ]
      );
      $this->add_responsive_control(
         'content_margin',
         [
            'label' => esc_html__( 'Content  margin', 'turitor' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
               '{{WRAPPER}} .post .entry-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
         ]
         );
      
      $this->end_controls_section();  

      $this->start_controls_section('style_readmore_section',
         [
            'label' => esc_html__( 'Readmore', 'turitor' ),
            'tab' => Controls_Manager::TAB_STYLE,
            
         ]
      ); 

      $this->add_control(
         'post_readmore_color',
         [
             'label' => esc_html__('Readmore color', 'turitor'),
             'type' => Controls_Manager::COLOR,
             'default' => '',
             'selectors' => [
                  '{{WRAPPER}} .post .post-footer a ' => 'color: {{VALUE}};',
             ],
         ]
        );

        $this->add_control(
         'post_readmore_color_hover',
         [
             'label' => esc_html__('Readmore hover', 'turitor'),
             'type' => Controls_Manager::COLOR,
             'default' => '',
             'selectors' => [
                  '{{WRAPPER}} .post .post-footer a:hover' => 'color: {{VALUE}};',
             ],
         ]
        );

        $this->add_group_control(
         Group_Control_Typography::get_type(), [
         'name'		 => 'readmore_typography',
         'selector'	 => '{{WRAPPER}} .post .post-footer a',
         ]
      );

      $this->end_controls_section();  

      $this->start_controls_section('style_advance_section',
         [
            'label' => esc_html__( 'Advance', 'turitor' ),
            'tab' => Controls_Manager::TAB_STYLE,
            
         ]
      ); 
      $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'box_border',
				'label' => esc_html__( 'Border', 'turitor' ),
				'selector' => '{{WRAPPER}} .latest-blog .post',
			]
		);

      $this->add_responsive_control(
         'box_border_radius',
         [
            'label' => esc_html__( 'Border Radius', 'turitor' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
               '{{WRAPPER}} .latest-blog .post' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
         ]
         );


      $this->end_controls_section();  
    } 

    protected function render() {
     
    $settings        = $this->get_settings();
    $post_title_crop = $settings["post_title_crop"];
    $show_desc       = $settings["show_desc"];
    $desc_limit      = $settings["desc_limit"];
    $post_count      = $settings["post_count"];
    $show_date       = $settings["show_date"];
    $show_cat        = $settings["show_cat"];
    $show_author     = $settings["show_author"];
    $show_readmore   = $settings["show_readmore"];
    $post_col        = $settings["post_col"];
    $post_sort_by    = $settings["post_sort_by"];
    $post_category   = $settings["post_category"];
    $args = array(
        'numberposts'      => $post_count,
        'orderby'          => 'post_date',
        'order'            => $post_sort_by,
        'post_type'        => 'post',
        'post_status'      => 'publish',
        'suppress_filters' => true
    );
   if(is_array($post_category) && count($post_category)){
      $args['category__in'] = $post_category;
   }
     
   $recent_posts = wp_get_recent_posts( $args, ARRAY_A );
  
   include (locate_template("components/editor/elementor/widgets/style/blog/default.php", false, false ));  

    }

    public function getCategories(){
      
      $terms = get_terms( array(
                  'taxonomy'    => 'category',
                  'hide_empty'  => false,
                  'posts_per_page' => -1, 
          ) );

      
      $cat_list = [];
    
      foreach($terms as $post) {
     
          $cat_list[$post->term_id]  = [$post->name];
      }
      
      return $cat_list;

  } 

   
}