<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Turitor_Main_Slider_Widget extends Widget_Base {


  public $base;

    public function get_name() {
        return 'turitor-main-slider';
    }

    public function get_title() {

        return esc_html__( 'Turitor main slider', 'turitor' );

    }

    public function get_icon() { 
        return 'eicon-slider-push';
    }

    public function get_categories() {
        return [ 'turitor-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Slider settings', 'turitor'),
            ]
        );
       
        $this->add_control(
			'style',
			[
				'label' => esc_html__( 'Slider Style', 'turitor' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1'  => esc_html__( 'Style 1', 'turitor' ),
					'style2'  => esc_html__( 'Style 2', 'turitor' ),
					'style3'  => esc_html__( 'Style 3', 'turitor' ),
				],
			]
        );
       
            $repeater = new \Elementor\Repeater();

            $repeater->add_control(
                'slider_main_title', [
                    'label' => esc_html__('Slider Main Title','turitor'),
                    'type'         => Controls_Manager::TEXT,
                    'default'      => esc_html__('Learn Anytime, Anywhere Accelerate ', 'turitor'),
                    'label_block'  => true,
                ]
            );
            $repeater->add_control(
                'slider_sub_title', [
                    'label' => esc_html__('Slider Sub Title','turitor'),
                    'type'         => Controls_Manager::TEXT,
                    'default'      => esc_html__('#Improving lives through learning', 'turitor'),
                    'label_block'  => true,
                ]
            );
            $repeater->add_control(
                'slider_desc', [
                    'label' => esc_html__('Slider description','turitor'),
                    'type'         => Controls_Manager::TEXTAREA,
                    'default'      => esc_html__('We believe everyone has the ', 'turitor'),
                    'label_block'  => true,
                ]
            );
            $repeater->add_control(
                'slider_bg_heading', [
                    'label' => esc_html__( 'Slider Background Image', 'turitor' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $repeater->add_control(
                'slider_bg_image', [
                    'label'       => esc_html__('Background Image', 'turitor'),
                    'type'        => Controls_Manager::MEDIA,
                    'label_block' => true,
                    'separator'   => 'after',
                ]
            );
            $repeater->add_control(
                'slider_three_heading', [
                    'label' => esc_html__( 'Slider Image For Style 3', 'turitor' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $repeater->add_control(
                'style3_slider_image_one', [
                    'label'       => esc_html__('Image One', 'turitor'),
                    'type'        => Controls_Manager::MEDIA,
                    'label_block' => true,
                ]
            );
            $repeater->add_control(
                'style3_slider_image_two', [
                    'label'       => esc_html__('Image Two ', 'turitor'),
                    'type'        => Controls_Manager::MEDIA,
                    'label_block' => true,
                    'separator'   => 'after',
                ]
            );
            $repeater->add_control(
                'button_one_heading', [
                    'label' => esc_html__( 'Button One', 'turitor' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $repeater->add_control(
                'button_text_one', [
                    'label'        => esc_html__('Text', 'turitor'),
                    'type'         => Controls_Manager::TEXT,
                    'default'      => esc_html__('Button', 'turitor'),
                    'label_block'  => true,
                ]
            );
            $repeater->add_control(
                'button_one_icon', [
                    'label'        => esc_html__('Icon', 'turitor'),
                    'type'         => Controls_Manager::ICONS,
                    'label_block'  => true,
                    'default' => [
                        'value' => 'tsicon tsicon-plus-circle',
                    ],
                ]
            );
            $repeater->add_control(
                'button_url_one', [
                    'label'            => esc_html__( 'URL', 'turitor' ),
                    'type'             => \Elementor\Controls_Manager::URL,
                    'label_block'      => true,
                    'separator'        => 'after', 
                ]
            );
            $repeater->add_control(
                'button_two_heading', [
                    'label' => esc_html__( 'Button Two', 'turitor' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $repeater->add_control(
                'button_text_two', [
                    'label'        => esc_html__('Text', 'turitor'),
                    'type'         => Controls_Manager::TEXT,
                    'default'      => esc_html__('Button ', 'turitor'),
                    'label_block'  => true,
                ]
            );
            $repeater->add_control(
                'button_two_icon', [
                    'label'        => esc_html__('Icon', 'turitor'),
                    'type'         => Controls_Manager::ICONS,
                    'label_block'  => true,
                    'default' => [
                        'value' => 'tsicon tsicon-plus-circle',
                    ],
                ]
            );
            $repeater->add_control(
                'button_url_two', [
                    'label'            => esc_html__( 'URL', 'turitor' ),
                    'type'             => \Elementor\Controls_Manager::URL,
                    'label_block'      => true,
                    'separator'        => 'after', 
                ]
            );
            $repeater->add_control(
                'content_align_text', [
                    'label' => esc_html__( 'Content Alignment', 'turitor' ),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'mr-auto',
                    'options' => [
                       'mr-auto'  => esc_html__( 'Left', 'turitor' ),
                       'mx-auto text-center' => esc_html__( 'Center', 'turitor' ),
                       'ml-auto text-right' => esc_html__( 'Right', 'turitor' ),
                    ],
                ]
            );
            $repeater->add_control(
                'justify_content_text', [
                    'label' => esc_html__( 'Justify content', 'turitor' ),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Yes', 'turitor' ),
                    'label_off' => esc_html__( 'No', 'turitor' ),
                    'return_value' => 'yes',
                    'default' => 'yes'
                ]
            );

            $this->add_control(
                'slider_items',
                [
                    'label' => esc_html__( 'Main Slider', 'turitor' ),
                    'type' => \Elementor\Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'slider_main_title' => esc_html__('Learn Anytime, Anywhere Accelerate ', 'turitor'),
                            'slider_sub_title' => esc_html__('Learn Anytime, Anywhere Accelerate ', 'turitor'),
                        ],
                        [
                            'slider_main_title' => esc_html__('Learn Anytime, Anywhere Accelerate ', 'turitor'),
                            'slider_sub_title' => esc_html__('Learn Anytime, Anywhere Accelerate ', 'turitor'),
                        ],
                        [
                            'slider_main_title' => esc_html__('Learn Anytime, Anywhere Accelerate ', 'turitor'),
                            'slider_sub_title' => esc_html__('Learn Anytime, Anywhere Accelerate ', 'turitor'),
                        ],
                    ],
                    'title_field' => '{{{ slider_main_title }}}',
                ]
            );

            
            $this->add_responsive_control(
                'thumbnail_height',
                [
                    'label' =>esc_html__( 'Slider Height', 'turitor' ),
                    'type' => \Elementor\Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'devices' => [ 'desktop', 'tablet', 'mobile' ],
                    'desktop_default' => [
                        'size' => 645,
                        'unit' => 'px',
                    ],
                    'tablet_default' => [
                        'size' => 400,
                        'unit' => 'px',
                    ],
                    'mobile_default' => [
                        'size' => 400,
                        'unit' => 'px',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .main-slider .banner-item' => 'min-height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'heading_type',
                [
                    'label' => esc_html__( 'Heading Type', 'turitor' ),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'h1',
                    'options' => [
                        'h1'  => esc_html__( 'H1', 'turitor' ),
                        'h2' => esc_html__( 'H2', 'turitor' ),
                        'h3' => esc_html__( 'H3', 'turitor' ),
                        'h4' => esc_html__( 'H4', 'turitor' ),
                        'h5' => esc_html__( 'H5', 'turitor' ),
                        'h6' => esc_html__( 'H6', 'turitor' ),
                        'p' =>  esc_html__( 'P', 'turitor' ),
                    ],
                ]
            );

            $this->add_control(
                'title_position',
                [
                    'label' => esc_html__( 'Title position', 'turitor' ),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'after',
                    'options' => [
                        'after'  => esc_html__( 'After', 'turitor' ),
                        'before' => esc_html__( 'Before', 'turitor' ),
                    
                    ],
                ]
            );

        $this->end_controls_section();

        //style
        $this->start_controls_section('style_section',
            [
               'label'    => esc_html__( 'Style Section', 'turitor' ),
               'tab'      => Controls_Manager::TAB_STYLE,
            ]
       ); 
     
          
       $this->add_control(
            'ts_slider_autoplay',
            [
                'label' => esc_html__( 'Autoplay', 'turitor' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'turitor' ),
                'label_off' => esc_html__( 'No', 'turitor' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );

        $this->add_control(
			'ts_slider_speed',
            [
               'label' => esc_html__( 'Slider Speed', 'turitor' ),
               'type' => \Elementor\Controls_Manager::NUMBER,
               'placeholder' => esc_html__( 'Enter Slider Speed', 'turitor' ),
               'default' => 5000,
               'condition' => ["ts_slider_autoplay" => ['yes']],
            ]
		  );

        $this->add_control(
        'ts_slider_nav_show',
            [
            'label' => esc_html__( 'Nav show', 'turitor' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'turitor' ),
            'label_off' => esc_html__( 'No', 'turitor' ),
            'return_value' => 'yes',
            'default' => 'yes'
            ]
        );
        $this->add_control(
         'ts_slider_dot_nav_show',
             [
             'label' => esc_html__( 'Dot nav', 'turitor' ),
             'type' => \Elementor\Controls_Manager::SWITCHER,
             'label_on' => esc_html__( 'Yes', 'turitor' ),
             'label_off' => esc_html__( 'No', 'turitor' ),
             'return_value' => 'yes',
             'default' => 'yes'
             ]
         );

        $this->end_controls_section();

        $this->start_controls_section('title_style_section',
         [
            'label'    => esc_html__( 'Slider Content ', 'turitor' ),
            'tab'      => Controls_Manager::TAB_STYLE,
         ]
       );

       $this->add_control('slider_content',
            [
                'label'     => esc_html__('Slider content BG', 'turitor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                        '{{WRAPPER}} .slider-content ' => 'background: {{VALUE}};',
                
                ],
                'condition' => ["style" => ['style1','style2']],
            ]
        );

        $this->add_responsive_control(
            'slider_content_padding',
            [
                'label' => esc_html__( 'Slider content padding', 'turitor' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider .slider-content ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slider_content_radius',
            [
                'label' => esc_html__( 'Slider content Radius', 'turitor' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider .slider-content ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => ["style" => ['style1','style2']],
            ]
        );


       $this->add_control('slider_top_title_color',
            [
                'label'     => esc_html__('Sub title color', 'turitor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .main-slider .slider-content .sub-title' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'sub_title_shape_color',
            [
                'label'     => esc_html__('Sub title Shape color', 'turitor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .main-slider .slider-content .sub-title::before' => 'background: {{VALUE}};',
                ],
                'condition' => ["style" => ['style3']],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'top_title_typography',
				'label' => esc_html__( 'Sub title Typography', 'turitor' ),
				
                'selector' => '{{WRAPPER}} .main-slider .slider-content .sub-title',
			]
        );
        
        $this->add_responsive_control(
            'top_title_margin',
            [
                'label' => esc_html__( 'Sub Title Margin', 'turitor' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}}  .main-slider .slider-content .sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
     
        
        $this->add_control('slider_title_color',
            [
               'label'     => esc_html__('Main title color', 'turitor'),
               'type'      => Controls_Manager::COLOR,
               'default'   => '',
               'selectors' => [
                     '{{WRAPPER}} .main-slider .slider-content .main-title' => 'color: {{VALUE}};',
               
               ],
            ]
        );
      
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__( 'Title Typography', 'turitor' ),
				
				'selector' => '{{WRAPPER}} .main-slider .slider-content .main-title',
			]
       );
       $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__( 'Main title Margin', 'turitor' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider .slider-content .main-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

       
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_desc_typography',
				'label' => esc_html__( 'Desc  Typography', 'turitor' ),
				
				'selector' => '{{WRAPPER}} .main-slider .slider-content .slider-desc',
			]
        );

        $this->add_responsive_control(
            'slider_desc_margin',
            [
                'label' => esc_html__( 'Slider Desc Margin', 'turitor' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider .slider-content .slider-desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control('slider_sub_text_color',
            [
            'label'     => esc_html__('Desc color', 'turitor'),
            'type'      => Controls_Manager::COLOR,
            'default'   => '',
            'selectors' => [
                '{{WRAPPER}} .main-slider .slider-content .slider-desc' => 'color: {{VALUE}};',
             ],
            ]
        );
   
      $this->end_controls_section();  

      $this->start_controls_section('button_style_section',
         [
            'label'    => esc_html__( 'Button', 'turitor' ),
            'tab'      => Controls_Manager::TAB_STYLE,
         ]
      );

    //    Style start
    
     $this->start_controls_tabs(
			'btn_style_tabs'
		);

		$this->start_controls_tab(
			'btn_style_normal_tab',
			[
				'label' => __( 'Normal', 'turitor' ),
			]
        );
        
        $this->add_control('slider_button_text_color',
        [
        'label'     => esc_html__('Button Text color', 'turitor'),
        'type'      => Controls_Manager::COLOR,
        'default'   => '',
        'selectors' => [
                '{{WRAPPER}} .slider-content .btn' => 'color: {{VALUE}};',
                ],
            ]
        );
      $this->add_control(
        'button_shape_color',
        [
            'label'     => esc_html__('Button Shape color', 'turitor'),
            'type'      => Controls_Manager::COLOR,
            'default'   => '',
            'selectors' => [
                '{{WRAPPER}} .main-slider .slider-content .btn-wrapper .btn::after' => 'background: {{VALUE}};',
            ],
            'condition' => ["style" => ['style3']],
        ]
    );

    
    $this->add_group_control(
        Group_Control_Background::get_type(),
        [
            'name' => 'slider_button_text_bgcolor',
            'label' => __( 'Button One BG color', 'turitor' ),
            'types' => [ 'classic', 'gradient', 'video' ],
            'selector' => '{{WRAPPER}} .main-slider .slider-content .btn',
        ]
    );

    $this->add_group_control(
        Group_Control_Border::get_type(),
        [
            'name' => 'border',
            'label' => esc_html__( 'Border', 'turitor' ),
            'selector' => '{{WRAPPER}} .main-slider .slider-content .btn',
        ]
    );
 
 
    // btn two styles
  

    $this->add_control('slider_button_two_color',
        [
        'label'     => esc_html__('Button Two Text color', 'turitor'),
        'type'      => Controls_Manager::COLOR,
        'default'   => '',
        'selectors' => [
                '{{WRAPPER}} .slider-content .btn.btn-border' => 'color: {{VALUE}};',
                ],
            ]
    );
    $this->add_group_control(
        Group_Control_Background::get_type(),
        [
            'name' => 'slider_button_two_bgcolor',
            'label' => __( 'Button Two BG color', 'turitor' ),
            'types' => [ 'classic', 'gradient', 'video' ],
            'selector' => '{{WRAPPER}} .main-slider .slider-content .btn-border',
        ]
    );
    
    $this->add_group_control(
        Group_Control_Border::get_type(),
         [
               'name' => 'slider_button_two_bdrcolor',
               'label' => esc_html__( 'Border', 'turitor' ),
               'selector' => '{{WRAPPER}} .main-slider .slider-content .btn-border',
         ]
      );

       
      $this->add_group_control(
        Group_Control_Typography::get_type(),
        [
            'name' => 'btn_typography',
            'label' => esc_html__( 'Button Typography', 'turitor' ),
            
            'selector' => '{{WRAPPER}} .main-slider .slider-content .btn',
        ]
    );
   
      $this->add_responsive_control(
        'btn_radius',
         [
               'label' => esc_html__( 'Button Radius', 'turitor' ),
               'type' => Controls_Manager::DIMENSIONS,
               'size_units' => [ 'px', '%', 'em' ],
               'selectors' => [
                  '{{WRAPPER}} .main-slider .slider-content .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
               ],
         ]
      );
      $this->add_responsive_control(
        'btn_margin',
         [
               'label' => esc_html__( 'Button Padding', 'turitor' ),
               'type' => Controls_Manager::DIMENSIONS,
               'size_units' => [ 'px', '%', 'em' ],
               'selectors' => [
                  '{{WRAPPER}} .main-slider .slider-content .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
               ],
         ]
      );

      $this->add_group_control(
        Group_Control_Box_Shadow::get_type(),
        [
            'name' => 'box_shadow',
            'label' => __( 'Box Shadow', 'turitor' ),
            'selector' => '{{WRAPPER}} .slider-content .btn',
        ]
    );

		

		$this->end_controls_tab();

		$this->start_controls_tab(
			'btn_style_hover_tab',
			[
				'label' => __( 'Hover', 'turitor' ),
			]
        );
        $this->add_control('slider_button_hov_text_color',
        [
        'label'     => esc_html__('Button Text color', 'turitor'),
        'type'      => Controls_Manager::COLOR,
        'default'   => '',
        'selectors' => [
                '{{WRAPPER}} .slider-content .btn:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'slider_button_hover_text_bgcolor',
				'label' => __( 'Background', 'turitor' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .main-slider .slider-content .btn:hover',
			]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'btn_hov_border',
                'label' => esc_html__( 'Button Border', 'turitor' ),
                'selector' => '{{WRAPPER}} .main-slider .slider-content .btn',
            ]
        );
        
        $this->add_control('slider_buttontwo_hov_text_color',
        [
        'label'     => esc_html__('Button Two Text color', 'turitor'),
        'type'      => Controls_Manager::COLOR,
        'default'   => '',
        'selectors' => [
                '{{WRAPPER}} .slider-content .btn-border:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'slider_button_two_hov_bg_bdr',
                'label' => __( 'Button Two  BG color', 'turitor' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .main-slider .slider-content .btn.btn-border:hover',
            ]
        );
        
        
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'slider_button_hover_shadow_color',
                'label' => __( 'Box Shadow', 'turitor' ),
                'selector' => '{{WRAPPER}}  .main-slider .slider-content .btn:hover',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'slider_button_two_hover_bg_bdr',
                'label' => esc_html__( 'Button Two Border', 'turitor' ),
                'selector' => '{{WRAPPER}} .main-slider .slider-content .btn-border:hover',
            ]
        );

     



		$this->end_controls_tab();

		$this->end_controls_tabs();

      
        $this->end_controls_section(); 
        //  Button Style Tab END
   
        $this->start_controls_section(
               'additional_style_section',
                [
                'label'    => esc_html__( 'Additional', 'turitor' ),
                'tab'      => Controls_Manager::TAB_STYLE,
                ]
        );

    
        $this->add_responsive_control(
			'boxed',
			[
				'label' => esc_html__( 'Boxed Width', 'turitor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 80,
				],
				'selectors' => [
					'{{WRAPPER}} .main-slider-style2 .slider-content .boxed' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => ["style" => ['style2']],
			]
        );
        $this->add_responsive_control(
			'boxed_bdr_width',
			[
				'label' => esc_html__( 'Boxed Border Width', 'turitor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 18,
				],
				'selectors' => [
					'{{WRAPPER}} .main-slider-style2 .slider-content .boxed' => 'border-width: {{SIZE}}{{UNIT}};',
				    '{{WRAPPER}} .main-slider-style2 .slider-content .boxed::after' => 'width: {{SIZE}}{{UNIT}};',
				    '{{WRAPPER}} .main-slider-style2 .slider-content .boxed::before' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => ["style" => ['style2']],
			]
        );

        $this->add_control(
                'boxed_bdr_color',
                [
                    'label' => esc_html__( 'Boxed Border Color', 'turitor' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .main-slider-style2 .slider-content .boxed' => 'border-color: {{VALUE}}',
                        '{{WRAPPER}} .main-slider-style2 .slider-content .boxed::after' => 'background: {{VALUE}}',
                        '{{WRAPPER}} .main-slider-style2 .slider-content .boxed::before' => 'background: {{VALUE}}',
                    ],
                    'condition' => ["style" => ['style2']],
                ]
            );

        $this->add_responsive_control(
            'slider3_image_one_width',
            [
                'label' => esc_html__( 'Slider Image One Width', 'turitor' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 350,
                ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-style3 .slider-image .image-box.image-one' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => ["style" => ['style3']],
            ]
        );
        
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'slider3_imge_one_border',
				'label' => esc_html__( 'Image One Border', 'turitor' ),
                'selector' => '{{WRAPPER}} .main-slider-style3 .slider-image .image-box.image-one',
                'condition' => [ "style" => ['style3'] ],
			]
		);
      
     
        $this->add_responsive_control(
            'slider3_image_two_width',
            [
                'label' => esc_html__( 'Slider Image Two Width', 'turitor' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 280,
                ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-style3 .slider-image .image-box.image-two' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => ["style" => ['style3']],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'slider3_imge_two_border',
                'label' => esc_html__( 'Image One Border', 'turitor' ),
                'selector' => '{{WRAPPER}} .main-slider-style3 .slider-image .image-box.image-two',
                'condition' => ["style" => ['style3']],
            ]
            
        );

        $this->add_responsive_control(
            'slider_padding',[
                'label' => esc_html__( 'Content Padding', 'turitor' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .slider-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
    
      $this->add_group_control(
        Group_Control_Background::get_type(),
        [
            'name' => 'slider_background',
            'label' => esc_html__( 'Background', 'turitor' ),
            'types' => [ 'classic', 'gradient' ],
            'selector' => '{{WRAPPER}} .banner-item::before',
        ]
    );

      $this->end_controls_section();  

   
    }

    protected function render( ) { 
        $settings = $this->get_settings();
        $slider_items = $settings['slider_items'];
        $title_position =  $settings['title_position'];

        $show_navigation   =   $settings["ts_slider_nav_show"]=="yes"?true:false;
        $auto_nav_slide    =   $settings['ts_slider_autoplay'];
        $dot_nav_show      =   $settings['ts_slider_dot_nav_show'];
        $ts_slider_speed   =   $settings['ts_slider_speed'];

        $slide_controls    = [
            'show_nav'=>$show_navigation, 
            'dot_nav_show'=>$dot_nav_show, 
            'auto_nav_slide'=>$auto_nav_slide, 
            'ts_slider_speed'=>$ts_slider_speed, 
        ];
   
        $slide_controls = \json_encode($slide_controls); 

        if($settings['style']=='style1'):   
            include (locate_template("components/editor/elementor/widgets/style/main-slider/default.php", false, false ));  
        endif;
        if($settings['style']=='style2'): 
            include (locate_template("components/editor/elementor/widgets/style/main-slider/style2.php", false, false ));  
        endif;
        if($settings['style']=='style3'): 
            include (locate_template("components/editor/elementor/widgets/style/main-slider/style3.php", false, false ));  
        endif;
    ?>
    
    <?php  
    }
    protected function _content_template() { }
}