<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;


class learndash_User_Login_Widget extends Widget_Base
{


	public $base;

	public function get_name()
	{
		return 'learndash-userlogin';
	}

	public function get_title()
	{
		return esc_html__('Learndash Login', 'turitor');
	}

	public function get_icon()
	{
		return 'fas fa-user';
	}

	public function get_categories()
	{
		return ['turitor-elements'];
	}

	protected function _register_controls()
	{

		$this->start_controls_section(
			'section_tab',
			[
				'label' => esc_html__('User Btn settings', 'turitor'),
			]
		);
		$this->add_control(
			'learndash_login_text',
			[
				'label'       => esc_html__('Title', 'turitor'),
				'type'        => Controls_Manager::TEXT,
				'default' => esc_html__('Login', 'turitor'),
				'placeholder' => esc_html__('Login', 'turitor'),
			]
		);

		$this->add_control(
			'user_login_icon',
			[
				'label' => esc_html__('Icon', 'turitor'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'tsicon tsicon-user',
				],
			]
		);

		$this->add_control(
			'custom_link_show',
			[
				'label'       => esc_html__('Use custom link?', 'turitor'),
				'type'        => Controls_Manager::SWITCHER,
				'label_on'    => esc_html__('Yes', 'turitor'),
				'label_off'   => esc_html__('No', 'turitor'),
				'default'     => 'no',
			]
		);
		$this->add_control(
			'user_custom_link',
			[
				'label' => __('Link', 'turitor'),
				'type' => Controls_Manager::URL,
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => ['custom_link_show' => 'yes'],
			]
		);

		$this->add_responsive_control(
			'user_align',
			[
				'label'			 => esc_html__('Alignment', 'turitor'),
				'type'			 => Controls_Manager::CHOOSE,
				'options'		 => [

					'left'		 => [
						'title'	 => esc_html__('Left', 'turitor'),
						'icon'	 => 'fa fa-align-left',
					],
					'center'	 => [
						'title'	 => esc_html__('Center', 'turitor'),
						'icon'	 => 'fa fa-align-center',
					],
					'right'		 => [
						'title'	 => esc_html__('Right', 'turitor'),
						'icon'	 => 'fa fa-align-right',
					],
					'justify'	 => [
						'title'	 => esc_html__('Justified', 'turitor'),
						'icon'	 => 'fa fa-align-justify',
					],
				],
				'default'		 => 'center',
				'selectors' => [
					'{{WRAPPER}} .learndash-login-user' => 'text-align: {{VALUE}};',

				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'learndash_login_style',
			[
				'label'	 => esc_html__('Button Style', 'turitor'),
				'tab'	 => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'learndash_login_text_color',
			[
				'label'		 => esc_html__('Text color', 'turitor'),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .learndash-login-user a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'learndash_login_text_hover_color',
			[
				'label'		 => esc_html__('Text hover Color', 'turitor'),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .learndash-login-user a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings       = $this->get_settings();
		$custom_link_show = $settings['custom_link_show'];
		$user_custom_link = $settings['user_custom_link'];

		$target = $settings['user_custom_link']['is_external'] ? ' target="_blank"' : '';
		$nofollow = $settings['user_custom_link']['nofollow'] ? ' rel="nofollow"' : '';
		$learndash_login_title =  $settings['learndash_login_text'];

?>



		<div class="learndash-login-user">
			<?php if ($custom_link_show == 'yes') : ?>
				<a href="<?php echo esc_url($user_custom_link['url']); ?>" <?php echo esc_attr($target);
																			echo esc_attr($nofollow); ?>>
					<?php Icons_Manager::render_icon($settings['user_login_icon'], ['aria-hidden' => 'true']); ?>
					<?php if (isset($learndash_login_title) && $learndash_login_title != '') { ?>
						<?php if (is_user_logged_in()) { ?>
							<span><?php echo esc_html__('My account', 'turitor'); ?></span>
						<?php } else { ?>
							<span><?php echo esc_html($learndash_login_title); ?></span>
					<?php }
					}
					?>
				</a>
			<?php else : ?>
				<?php $profile_url = (is_user_logged_in() ? home_url( '/profile' ) : '#');
				?>
				<a href="<?php echo esc_url($profile_url); ?>" class="ts-login-popup">
					<?php Icons_Manager::render_icon($settings['user_login_icon'], ['aria-hidden' => 'true']);
					do_shortcode("[learndash_login]")
					?>
					<?php if (isset($learndash_login_title) && $learndash_login_title != '') { ?>
						<?php if (is_user_logged_in()) { ?>
							<span><?php echo esc_html__('My account', 'turitor'); ?></span>
						<?php } else { ?>
							<span><?php echo esc_html($learndash_login_title); ?></span>
					<?php }
					}
					?>
				</a>
			<?php endif; ?>
		</div>
<?php
	}
	protected function _content_template()
	{
	}
}
