<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Turitor_Learndash_Course_Widget extends Widget_Base {


    public $base;

    public function get_name() {
        return 'turitor-learndash-course';
    }

    public function get_title() {
        return esc_html__( 'Turitor Learndash Course', 'turitor' );
    }

    public function get_icon() { 
        return 'eicon-bullet-list';
    }

    public function get_categories() {
        return [ 'turitor-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Learndash Course settings', 'turitor'),
            ]
        );
        $this->add_control(
            'cat_id',
            [
              'label'     => esc_html__('Select Category', 'turitor'),
              'type'      => Controls_Manager::SELECT2,
              'options'   => $this->ld_category(),
              'multiple'    => true,
              'label_block' => true,
              'default'     => 'all',
      
            ]
          );

        $this->add_control(
            'post_count',
             [
                'label'         => esc_html__( 'Post count', 'turitor' ),
                'type'          => Controls_Manager::NUMBER,
                'default'       => '3',

            ]
         );
        $this->add_control(
            'post_sort_by',
            [
                'label' => esc_html__( 'Sort By', 'turitor' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                        'ASC'  => esc_html__( 'ASC', 'turitor' ),
                        'DESC'  => esc_html__( 'DESC', 'turitor' ),
                    ],
                    
            ]
            );

      $this->end_controls_section();  

       

   } 

   protected function render( ) { 
      $settings       = $this->get_settings();
      $cat_id = $settings['cat_id'] ? $settings['cat_id'] : array();
      $post_sort_by    = $settings["post_sort_by"];
      $post_count    = $settings["post_count"];

   
    //   include file start
     include (locate_template("components/editor/elementor/widgets/style/learndash/learndash-course-style1.php", false, false ));  
    //  include file end
     
    }



    protected function _content_template() { }


    // Get list courses category
    public function ld_category(){
        if ( ! class_exists( 'SFWD_LMS' ) ) {
            return [];
        }
        $tax_terms = get_terms('ld_course_category', array('hide_empty' => false));

        $category_list = [];
            
        foreach($tax_terms as $term_single) {      
            $category_list[$term_single->term_id] = [$term_single->name];
            
        }
        
        return $category_list;
    }
}