<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Turitor_Feature_Standard_Widget extends Widget_Base {


    public $base;

    public function get_name() {
        return 'standard-feature';
    }

    public function get_title() {
        return esc_html__( 'Feature Standard', 'turitor' );
    }

    public function get_icon() { 
        return 'eicon-info-box';
    }

    public function get_categories() {
        return [ 'turitor-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Turitor Featured Standard Box', 'turitor'),
            ]
		);

		$this->add_control(
			'style',
			[
				'label' => esc_html__( 'Feature Style', 'turitor' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1'  => esc_html__( 'Style 1', 'turitor' ),
					'style2'  => esc_html__( 'Style 2', 'turitor' ),
				],
			]
         );

        $this->add_control(
			'title', [
				'label'			=> esc_html__( 'Title', 'turitor' ),
				'type'			=> Controls_Manager::TEXT,
				'label_block'	=> true,
				'placeholder'	=> esc_html__( 'Best quality', 'turitor' ),
				'default'	    => esc_html__( 'Best quality', 'turitor' ),
			]
			
		);
		$this->add_responsive_control('title_align', 
          [
				'label'			 => esc_html__( 'Alignment', 'turitor' ),
				'type'			 => Controls_Manager::CHOOSE,
				'options'		 => [

					'left'		 => [
						'title'	 => esc_html__( 'Left', 'turitor' ),
						'icon'	 => 'fa fa-align-left',
					],
					'center'	 => [
						'title'	 => esc_html__( 'Center', 'turitor' ),
						'icon'	 => 'fa fa-align-center',
					],
					'right'		 => [
						'title'	 => esc_html__( 'Right', 'turitor' ),
						'icon'	 => 'fa fa-align-right',
					],
					'justify'	 => [
						'title'	 => esc_html__( 'Justified', 'turitor' ),
						'icon'	 => 'fa fa-align-justify',
					],
				],
				'default'		 => 'left',
                'selectors' => [
                    '{{WRAPPER}} .ts-title' => 'text-align: {{VALUE}};',
                    '{{WRAPPER}} .ts-feature-standard.style2' => 'text-align: {{VALUE}};',
				],
			]
        );//Responsive control end

        $this->add_control(
			'desc', [
			'label'			=> esc_html__( 'Content', 'turitor' ),
			'type'			=> Controls_Manager::TEXTAREA,
			'label_block'	=> true,
			'placeholder'	=> esc_html__( 'Which i enjoy with my whole heart', 'turitor' ),
         	'default'      => esc_html__( 'Which i enjoy with my whole heart.', 'turitor' ),
           
			]
		);
		$this->add_responsive_control('desc_align', 
          [
				'label'			 => esc_html__( 'Alignment', 'turitor' ),
				'type'			 => Controls_Manager::CHOOSE,
				'options'		 => [

					'left'		 => [
						'title'	 => esc_html__( 'Left', 'turitor' ),
						'icon'	 => 'fa fa-align-left',
					],
					'center'	 => [
						'title'	 => esc_html__( 'Center', 'turitor' ),
						'icon'	 => 'fa fa-align-center',
					],
					'right'		 => [
						'title'	 => esc_html__( 'Right', 'turitor' ),
						'icon'	 => 'fa fa-align-right',
					],
					'justify'	 => [
						'title'	 => esc_html__( 'Justified', 'turitor' ),
						'icon'	 => 'fa fa-align-justify',
					],
				],
				'default'		 => 'left',
                'selectors' => [
                    '{{WRAPPER}} .intro-content p' => 'text-align: {{VALUE}};',
                    '{{WRAPPER}} .ts-feature-standard.style2 .featured-content' => 'text-align: {{VALUE}};',
				],
			]
        );//Responsive control end
		


		$this->add_control(
			'fs_button_text',
			[
				'label'    => esc_html__( 'Button Text', 'turitor' ),
				'type'     => Controls_Manager::TEXT,
				'default'  	=> esc_html__('Learn More', 'turitor'),
				'condition' => ["style" => ['style2']],
			]
		);
		 
		$this->add_control(
			'fs_button_icon',
			[
				'label' => esc_html__( 'Icon', 'turitor' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'tsicon tsicon-cart',
				],
				'condition' => ["style" => ['style1']],
			]
		);

		
		$this->add_control('fs_button_url',
			[
			'label'    => esc_html__( 'Button Link', 'turitor' ),
			'type'     => Controls_Manager::URL,
			
			]
		);

        $this->add_responsive_control('btn_align', 
          [
				'label'			 => esc_html__( 'Alignment', 'turitor' ),
				'type'			 => Controls_Manager::CHOOSE,
				'options'		 => [

					'left'		 => [
						'title'	 => esc_html__( 'Left', 'turitor' ),
						'icon'	 => 'fa fa-align-left',
					],
					'center'	 => [
						'title'	 => esc_html__( 'Center', 'turitor' ),
						'icon'	 => 'fa fa-align-center',
					],
					'right'		 => [
						'title'	 => esc_html__( 'Right', 'turitor' ),
						'icon'	 => 'fa fa-align-right',
					],
					'justify'	 => [
						'title'	 => esc_html__( 'Justified', 'turitor' ),
						'icon'	 => 'fa fa-align-justify',
					],
				],
				'default'		 => 'left',
                'selectors' => [
                    '{{WRAPPER}} .single-intro-text' => 'text-align: {{VALUE}};',
				],
			]
		);//Responsive control end
		
		$this->add_control(
			'image',
			[
				'label' => esc_html__( 'Choose Image', 'turitor' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'section_sub_title_style', [
				'label'	 => esc_html__( 'Title', 'turitor' ),
				'tab'	 => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'title_color', [
				'label'		 => esc_html__( 'Title color', 'turitor' ),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .single-intro-text h3' => 'color: {{VALUE}};',
				],
			]
		);
        
        $this->add_group_control(Group_Control_Typography::get_type(),
         [
			'name'		 => 'title_typography',
			'selector'	 => '{{WRAPPER}} .single-intro-text h3',
			]
		);

		$this->add_responsive_control(
			'title_margin',
			[
				'label' => esc_html__( 'Title Margin', 'turitor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .single-intro-text h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .ts-feature-standard.style2 .featured-content .ts-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
      );
     

        $this->end_controls_section();
        
        //Content Style Section
      $this->start_controls_section('section_content_style',
         [
				'label'	 => esc_html__( 'Content', 'turitor' ),
				'tab'	    => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->start_controls_tabs( 'feature_content_style' );


		$this->start_controls_tab(
			'feature_content_normal',
			[
				'label' => esc_html__( 'Normal', 'turitor' ),
			]
		);

		$this->add_control(
			'feature_content_color', [
				'label'		 => esc_html__( 'Content color', 'turitor' ),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .single-intro-text p' => 'color: {{VALUE}};',
					'{{WRAPPER}} .ts-feature-standard.style2 .featured-content p' => 'color: {{VALUE}};',
					'{{WRAPPER}} .ts-feature-standard.style2 .featured-content .ts-title' => 'color: {{VALUE}};',
				],
			]
        );

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'feature_content_bg',
				'label' => esc_html__( 'Feature BG Color', 'turitor' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .fsbtn .fs-link .fs-contents',
				'selector' => '{{WRAPPER}} .ts-feature-standard.style2 .featured-content ',
			]
		); 
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'feature_content_border',
				'label' => esc_html__( 'Border', 'turitor' ),
				'selector' => '{{WRAPPER}} .ts-feature-standard.style2 .featured-content',
			]
	  	);
    
		$this->end_controls_tab();

		$this->start_controls_tab(
			'feature_content_hover',
				[
					'label' =>esc_html__( 'Hover', 'turitor' ),
				]
		);
		$this->add_control(
			'feature_content_hov_color', [
				'label'		 => esc_html__( 'Content color', 'turitor' ),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .ts-feature-standard:hover .single-intro-text p' => 'color: {{VALUE}};',
					'{{WRAPPER}} .ts-feature-standard.style2:hover .featured-content p' => 'color: {{VALUE}};',
					'{{WRAPPER}} .ts-feature-standard.style2:hover .featured-content .ts-title' => 'color: {{VALUE}};',
				],
			]
        );

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'feature_content_hov_bg',
				'label' => esc_html__( 'Feature BG Color', 'turitor' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .ts-feature-standard.style2:hover .featured-content ',
			]
		); 
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'feature_content_hov_border',
				'label' => esc_html__( 'Border', 'turitor' ),
				'selector' => '{{WRAPPER}} .ts-feature-standard.style2:hover .featured-content',
			]
	  	);

		$this->end_controls_tab();
		$this->end_controls_tabs();

        $this->add_group_control(Group_Control_Typography::get_type(),
         [
			 'name'		 => 'feature_content_typography',
			 'selector'	 => '{{WRAPPER}} .single-intro-text p',
			]
		);

		$this->add_responsive_control(
			'feature_content_pad',
			[
				'label' => esc_html__( 'Feature Content Padding', 'turitor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .ts-feature-standard.style2 .featured-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	
		$this->end_controls_section();

		$this->start_controls_section(
			'fs_btn_style', [
				'label'	 => esc_html__( 'Feature Button Style', 'turitor' ),
				'tab'	 => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs( 'feature_button_style' );


		$this->start_controls_tab(
			'feature_btn_normal',
			[
				'label' => esc_html__( 'Normal', 'turitor' ),
			]
		);

		$this->add_control(
			'fs_btn_color', [
				'label'		 => esc_html__( 'Feature Button Color', 'turitor' ),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .fsbtn .fs-link .fs-contents' => 'color: {{VALUE}};',
					'{{WRAPPER}} .ts-feature-standard .single-intro-text .feature-btn a.fs-btn' => 'color: {{VALUE}};',
					'{{WRAPPER}} .ts-feature-standard.style2 .feature-btn .btn.btn-outline' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'fs_btn_bg_color',
				'label' => esc_html__( 'Feature Button BG Color', 'turitor' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .fsbtn .fs-link .fs-contents',
				'selector' => '{{WRAPPER}} .ts-feature-standard.style2 .feature-btn .btn.btn-outline',
				'selector' => '{{WRAPPER}} .ts-feature-standard .single-intro-text .feature-btn a.fs-btn',
			]
		); 
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'feature_btn_border',
				'label' => esc_html__( 'Border', 'turitor' ),
				'selector' => '{{WRAPPER}} .ts-feature-standard.style2 .feature-btn .btn.btn-outline',
				'selector' => '{{WRAPPER}} .ts-feature-standard .single-intro-text .feature-btn a.fs-btn',
			]
		);
		  
		$this->add_responsive_control(
			'button_position',
			[
				'label' => esc_html__( 'Position', 'turitor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 10,
				],
				'condition' => ["style" => ['style1']],
				'selectors' => [
					'{{WRAPPER}} .ts-feature-standard .single-intro-text .feature-btn a.fs-btn' => 'left: {{SIZE}}{{UNIT}};',
				],
			]
		);
    
		$this->end_controls_tab();

		$this->start_controls_tab(
			'feature_btn_hover',
				[
					'label' =>esc_html__( 'Hover', 'turitor' ),
				]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'fs_btn_bg_hove_color',
				'label' => esc_html__( 'Feature Button hover BG Color', 'turitor' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .fsbtn .fs-link .fs-contents:hover',
				'selector' => '{{WRAPPER}} .ts-feature-standard.style2 .feature-btn .btn.btn-outline:hover',
				'selector' => '{{WRAPPER}} .ts-feature-standard .single-intro-text .feature-btn a.fs-btn:hover',
			]
		); 

		$this->add_control(
			'fs_btn_hover_color', [
				'label'		 => esc_html__( 'Feature Button hover Color', 'turitor' ),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .fsbtn .fs-link .fs-contents:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .ts-feature-standard.style2 .feature-btn .btn.btn-outline:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .ts-feature-standard .single-intro-text .feature-btn a.fs-btn:hover' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'feature_btn_hov_border',
				'label' => esc_html__( 'Hover Border', 'turitor' ),
				'selector' => '{{WRAPPER}} .ts-feature-standard.style2 .feature-btn .btn.btn-outline:hover',
				'selector' => '{{WRAPPER}} .ts-feature-standard .single-intro-text .feature-btn a.fs-btn:hover',
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();


    } //Register control end

    protected function render( ) { 

        $settings    =  $this->get_settings();
		$title       =  $settings["title"];
        $desc        =  $settings["desc"];
		$button_text =  $settings["fs_button_text"]; 
		$button_icon =  $settings["fs_button_icon"]; 
		$button_url  =  $settings["fs_button_url"];
      		
		$title_1 = str_replace(["{"  ,  "}"] , ["<span>"  ,  "</span>"], $title);

		if($settings['style']=='style1'): 
			 
    ?>
		<div class="ts-feature-standard">
			<div class="single-intro-text">
				<div class="intro-content">
					<h3 class="ts-title"><?php echo turitor_kses($title_1); ?></h3>
					<p>
						<?php echo turitor_kses($desc); ?>
					</p>
				</div>
				<div class="feature-btn">
					<a href="<?php echo esc_url($button_url["url"]); ?>" class="fs-btn"> 
						<?php Icons_Manager::render_icon( $settings['fs_button_icon'], [ 'aria-hidden' => 'true' ] ); ?>
					</a>
				</div>  
				<div class="feature-img">
					<img src="<?php echo esc_attr($settings['image']['url']) ?>" alt="<?php echo esc_attr($title_1); ?>">
				</div>
			</div><!-- single intro text end-->
		</div>
 		
		<?php
		 endif;
		 if($settings['style']=='style2'):  
		?>
		<div class="ts-feature-standard style2">
			<div class="featured-content">
				<h3 class="ts-title"><?php echo turitor_kses($title_1); ?></h3>
				<p>
					<?php echo turitor_kses($desc); ?>
				</p>
				<div class="feature-btn">
					<a href="<?php echo esc_url($button_url["url"]); ?>" class="btn btn-outline"><?php echo esc_html($button_text); ?></a>
				</div>  
			</div>
			<div class="feature-img">
				<img src="<?php echo esc_attr($settings['image']['url']) ?>" alt=" <?php echo esc_attr($title_1); ?> ">
			</div>
		</div>
		<?php endif; ?>
 
    <?php  
	}
	
	protected function _content_template() { }
	
	
}