<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Turitor_Course_Widget extends Widget_Base {


    public $base;

    public function get_name() {
        return 'turitor-course';
    }

    public function get_title() {
        return esc_html__( 'Course', 'turitor' );
    }

    public function get_icon() { 
        return 'eicon-person';
    }

    public function get_categories() {
        return [ 'turitor-elements' ];
    }

    	// Get list courses category
      public function course_category(){
        if(!defined('LP_COURSE_CPT')){
          return [];
	    	}
        $tax_terms = get_terms('course_category', array('hide_empty' => false));
        $category_list = [];
         
        foreach($tax_terms as $term_single) {      
          $category_list[$term_single->term_id] = [$term_single->name];
         
        }
        
        return $category_list;
        }

    protected function _register_controls() {
      $this->start_controls_section(
        'content',
        [
          'label' => esc_html__( 'Courses', 'turitor' )
        ]
      );
  

      $this->add_control(
        'layout',
        [
          'label'   => esc_html__( 'Layout', 'turitor' ),
          'type'    => Controls_Manager::SELECT,
          'options' => [
            'grid-single'         => esc_html__( 'Grid single', 'turitor' ),
            'grid-1'         => esc_html__( 'Grid 1', 'turitor' ),
            'grid-2'         => esc_html__( 'Grid 2', 'turitor' ),
            'tabs'         => esc_html__( 'Category Tabs', 'turitor' ),
            
          ],
          'default' => 'grid-1'  
        ]
      );
  
      $this->add_control(
        'order',
        [
          'label'   => esc_html__( 'Order By', 'turitor' ),
          'type'    => Controls_Manager::SELECT,
          'options' => [
            'popular'  => esc_html__( 'Popular', 'turitor' ),
            'latest'   => esc_html__( 'Latest', 'turitor' ),
          ],
          'default' => 'latest',
          'condition' => array(
            'layout' => ['grid-1', 'tabs', 'grid-2']
          )
        ]
      );
  
  
  
   
      $this->add_control(
        'limit',
        [
          'label'   => esc_html__( 'Limit Number Courses', 'turitor' ),
          'type'    => Controls_Manager::NUMBER,
          'default' => 8,
          'min'     => 1,
          'step'    => 1,
          'condition' => array(
            'layout' => ['grid-1', 'tabs', 'grid-2']
          )
        ]
      );
  
      $this->add_control(
        'cat_id',
        [
          'label'     => esc_html__( 'Select Category', 'turitor' ),
          'type'      => Controls_Manager::SELECT2,
          'options'   => $this->course_category(),
          'multiple'    => true,
          'default'     => 'all',
          'label_block' => true,
          'condition' => array(
            'layout' => ['grid-1', 'grid-2']
          )
        ]
      );
      $this->add_control(
        'course_list',
        [
          'label'     => esc_html__( 'Select Category', 'turitor' ),
          'type'      => Controls_Manager::SELECT,
          'options'   => $this->course_list(),
          'label_block' => true,
          'condition' => array(
            'layout' => ['grid-single']
          )
        ]
      );

      $this->add_control(
        'featured',
        [
          'label'        => esc_html__( 'Display Featured Courses?', 'turitor' ),
          'type'         => Controls_Manager::SWITCHER,
          'label_on'     => esc_html__( 'Yes', 'turitor' ),
          'label_off'    => esc_html__( 'No', 'turitor' ),
          'return_value' => 'yes',
          'default'      => '',
          'condition' => array(
            'layout' => ['grid-1', 'tabs', 'grid-2']
          )
        ]
      );
  
  
      $this->end_controls_section();
  
 

  
      $this->start_controls_section(
        'tab-options',
        [
          'label'     => esc_html__( 'Tab Options', 'turitor' ),
          'condition' => array(
            'layout' => [ 'tabs' ]
          )
        ]
      );
  
      $this->add_control(
        'limit_tab',
        [
          'label'   => esc_html__( 'Limit Items Per Tab', 'turitor' ),
          'type'    => Controls_Manager::NUMBER,
          'default' => 4,
          'min'     => 1,
          'step'    => 1
        ]
      );
  
      $this->add_control(
        'cat_id_tab',
        [
          'label'       => esc_html__( 'Select Category Tabs', 'turitor' ),
          'label_block' => true,
          'type'        => Controls_Manager::SELECT2,
          'options'     => $this->course_category(),
          'multiple'    => true,
          'default'     => 'all'
        ]
      );
  
      $this->end_controls_section();

      $this->start_controls_section(
        'tab_menu_style', [
          'label'	 => esc_html__( 'Tab Menu', 'turitor' ),
          'tab'	 => Controls_Manager::TAB_STYLE,
          'condition' => ['layout'=> 'tabs']
        ]
      );
      $this->add_control(
        'tab_menu_color', [
          'label'		 => esc_html__( 'color', 'turitor' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .tab-course-category ul li' => 'color: {{VALUE}};',
          ],
        ]
        );

      $this->add_control(
        'tab_menu_active_color', [
          'label'		 => esc_html__( 'Tab menu active color', 'turitor' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .tab-course-category ul li.active' => 'color: {{VALUE}};',
            '{{WRAPPER}} .tab-course-category ul li:before' => 'background: {{VALUE}};',
          ],
        ]
        );
  
         
        $this->add_group_control(
        Group_Control_Typography::get_type(), [
        'name'		 => 'tab_menu_typography',
        'selector'	 => '{{WRAPPER}} .tab-course-category ul li',
        ]
        );
        
        $this->add_responsive_control(
          'tab_menu_margin',
          [
            'label' => esc_html__( 'Tab Menu margin', 'turitor' ),
            'type' => Controls_Manager::DIMENSIONS,
            'allowed_dimensions' => [ 'bottom' ],
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
              '{{WRAPPER}} .tab-course-category' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->add_responsive_control(
          'tab_menu_padding',
          [
            'label' => esc_html__( 'Tab Menu padding', 'turitor' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
              '{{WRAPPER}} .tab-course-category ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->add_responsive_control(
          'tab_menu_border_radius',
          [
            'label' => esc_html__( 'Border Radius', 'turitor' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
              '{{WRAPPER}} .tab-course-category ul' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );

 
      $this->end_controls_section();

      $this->start_controls_section(
        'title_style', [
          'label'	 => esc_html__( 'Title', 'turitor' ),
          'tab'	 => Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'title_color', [
          'label'		 => esc_html__( 'Title color', 'turitor' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course .ts-course-el-title a' => 'color: {{VALUE}};',
          ],
        ]
        );

      $this->add_control(
        'title_hover_color', [
          'label'		 => esc_html__( 'Title hover color', 'turitor' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course:hover .ts-course-el-title a' => 'color: {{VALUE}};',
          ],
        ]
        );
  
         
        $this->add_group_control(
        Group_Control_Typography::get_type(), [
        'name'		 => 'title_typography',
        'selector'	 => '{{WRAPPER}} .single-course .ts-course-el-title',
        ]
        );
        
        $this->add_responsive_control(
          'title_margin',
          [
            'label' => esc_html__( 'Tilte margin', 'turitor' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
              '{{WRAPPER}} .single-course .ts-course-el-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
      
      $this->end_controls_section();

      $this->start_controls_section(
        'category_meta_style', [
          'label'	 => esc_html__( 'Meta Style', 'turitor' ),
          'tab'	 => Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'meta_color', [
          'label'		 => esc_html__( 'color', 'turitor' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course .course-category a' => 'color: {{VALUE}};',
            '{{WRAPPER}} .single-course .course-enrole-list li' => 'color: {{VALUE}};',
          ],
        ]
        );

      $this->add_control(
        'meta_hover_color', [
          'label'		 => esc_html__( 'Meta  color', 'turitor' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course:hover .course-category a' => 'color: {{VALUE}};',
            '{{WRAPPER}} .single-course:hover .course-enrole-list li' => 'color: {{VALUE}};',
          ],
        ]
        );
  
         
        $this->add_group_control(
        Group_Control_Typography::get_type(), [
        'name'		 => 'meta_title_typography',
        'selector'	 => '{{WRAPPER}} .single-course .course-category a, {{WRAPPER}} .single-course .course-enrole-list li',
        ]
        );
      $this->end_controls_section();
     
      $this->start_controls_section(
        'instructor_style', [
          'label'	 => esc_html__( 'Instructor Style', 'turitor' ),
          'tab'	 => Controls_Manager::TAB_STYLE,
        ]
      );

      $this->add_control(
        'instructor_hover_color', [
          'label'		 => esc_html__( 'Instructor color', 'turitor' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course .instructor a' => 'color: {{VALUE}};',
          ],
        ]
        );
  
         
        $this->add_group_control(
        Group_Control_Typography::get_type(), [
        'name'		 => 'instructor_title_typography',
        'selector'	 => '{{WRAPPER}} .single-course .instructor a',
        ]
        );
      $this->end_controls_section();

      $this->start_controls_section(
        'price_style', [
          'label'	 => esc_html__( 'Price Style', 'turitor' ),
          'tab'	 => Controls_Manager::TAB_STYLE,
        ]
      );

      $this->add_control(
        'price_bg_color', [
          'label'		 => esc_html__( 'Background color', 'turitor' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course .course-footer .course-price-item span' => 'background-color: {{VALUE}};',
            '{{WRAPPER}} .course-single-wrap .single-course .course-price-item span' => 'background-color: {{VALUE}};',
          ],
        ]
        );
      $this->add_control(
        'price_bg_hover_color', [
          'label'		 => esc_html__( 'Hover Background color', 'turitor' ),
          'type'		 => Controls_Manager::COLOR,
          'condition' => ['layout' => 'grid-single'],
          'selectors'	 => [
            '{{WRAPPER}} .course-single-wrap .single-course:hover .course-price-item span' => 'background-color: {{VALUE}};',
          ],
        ]
        );
      $this->add_control(
        'price_color', [
          'label'		 => esc_html__( 'Color', 'turitor' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course .course-footer .course-price-item span' => 'color: {{VALUE}};',
            '{{WRAPPER}} .course-single-wrap .single-course .course-price-item span' => 'color: {{VALUE}};',
          ],
        ]
        );
  
         
        $this->add_group_control(
        Group_Control_Typography::get_type(), [
        'name'		 => 'price_title_typography',
        'selector'	 => '{{WRAPPER}} .single-course .course-price-item span',
        ]
        );
      $this->end_controls_section();

      $this->start_controls_section(
        'btn_link', [
          'label'	 => esc_html__( 'Course footer Style', 'turitor' ),
          'tab'	 => Controls_Manager::TAB_STYLE,
          'condition' => ['layout' => 'grid-single'],
        ]
      );
      $this->add_control(
        'button_bg_color', [
          'label'		 => esc_html__( 'BTN background color', 'turitor' ),
          'type'		 => Controls_Manager::COLOR,
          'condition' => ['layout' => 'grid-single'],
          'selectors'	 => [
            '{{WRAPPER}} .course-single-wrap .single-course .btn-link' => 'background-color: {{VALUE}};',
          ],
        ]
        );

      $this->add_control(
        'button_bg_hover_color', [
          'label'		 => esc_html__( 'BTN background hover color', 'turitor' ),
          'type'		 => Controls_Manager::COLOR,
          'condition' => ['layout' => 'grid-single'],
          'selectors'	 => [
            '{{WRAPPER}} .course-single-wrap .single-course:hover .btn-link' => 'background-color: {{VALUE}};',
          ],
        ]
        );
        
        $this->add_group_control(
         Group_Control_Border::get_type(),
         [
           'name' => 'footer_top_border',
           'label' => esc_html__( 'footer top border', 'turitor' ),
           'selector' => '{{WRAPPER}} .course-single-wrap .single-course .border-bar',
         ]
     );

       $this->end_controls_section();


      $this->start_controls_section(
        'advance_style', [
          'label'	 => esc_html__( 'Advance Style', 'turitor' ),
          'tab'	 => Controls_Manager::TAB_STYLE,
        ]
      );

      $this->add_control(
        'img_bg_color', [
          'label'		 => esc_html__( 'Image background color', 'turitor' ),
          'type'		 => Controls_Manager::COLOR,
          'condition' => ['layout' => 'grid-single'],
          'selectors'	 => [
            '{{WRAPPER}} .course-single-wrap .course-thumbnail' => 'background-color: {{VALUE}};',
          ],
        ]
        );

      $this->add_control(
        'box_bg_color', [
          'label'		 => esc_html__( 'Box background color', 'turitor' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course' => 'background-color: {{VALUE}};',
          ],
        ]
        );
      $this->add_control(
        'box_bg_color_hover', [
          'label'		 => esc_html__( 'Box background hover color', 'turitor' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course:hover' => 'background-color: {{VALUE}};',
          ],
        ]
        );
      $this->add_control(
        'box_shape_color1', [
          'label'		 => esc_html__( 'Box shape 1 color', 'turitor' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course .course-shap path:first-of-type' => 'fill: {{VALUE}};',
          ],
          'layout' => ['grid-1', 'tabs', 'grid-single'],
        ]
      );
      $this->add_control(
        'box_shape_hover_color1', [
          'label'		 => esc_html__( 'Box hover shape 1 color', 'turitor' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course:hover .course-shap path:first-of-type' => 'fill: {{VALUE}};',
          ],
          'layout' => ['grid-1', 'tabs', 'grid-single'],
        ]
        );
      $this->add_control(
        'box_shape_color2', [
          'label'		 => esc_html__( 'Box  shape 2 color', 'turitor' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course .course-shap path:last-of-type' => 'fill: {{VALUE}};',
          ],
          'layout' => ['grid-1', 'tabs', 'grid-single'],
        ]
        );
      $this->add_control(
        'box_shape_hover_color2', [
          'label'		 => esc_html__( 'Box hover shape 2 color', 'turitor' ),
          'type'		 => Controls_Manager::COLOR,
          'selectors'	 => [
            '{{WRAPPER}} .single-course:hover .course-shap path:last-of-type' => 'fill: {{VALUE}};',
          ],
          'layout' => ['grid-1', 'tabs', 'grid-single'],
        ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
              'name' => 'course_price_shadow',
              'label' => esc_html__( 'Course price Shadow', 'turitor' ),
              'selector' => '{{WRAPPER}} .single-course .course-footer .course-price-item .course-price',
              'layout' => ['grid-1', 'tabs', 'grid-single'],
            ]
        );

        $this->add_responsive_control(
         'content_margin',
         [
           'label' => esc_html__( 'Box margin', 'turitor' ),
           'type' => Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px', '%', 'em' ],
           'allowed_dimensions' => [ 'bottom' ],
           'selectors' => [
             '{{WRAPPER}} .single-course' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
           ],
         ]
         );
        $this->add_responsive_control(
         'content_padding',
         [
           'label' => esc_html__( 'Box Padding', 'turitor' ),
           'type' => Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px', '%', 'em' ],
           'selectors' => [
             '{{WRAPPER}} .single-course' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
           ],
           'layout' => ['grid-1', 'tabs', 'grid-single'],
         ]
         );

        $this->add_responsive_control(
          'box_border_radius',
          [
            'label' => esc_html__( 'Box border radius', 'turitor' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
              '{{WRAPPER}} .single-course' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
              '{{WRAPPER}} .course-single-wrap .course-thumbnail img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
              '{{WRAPPER}} .course-single-wrap .course-thumbnail' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
          );
          $this->start_controls_tabs( 'boxed_border_styled' );

        $this->start_controls_tab(
             'boxed_border_style_normal',
             [
                'label' =>esc_html__( 'Normal', 'turitor' ),
             ]
        );
   
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border_noromal',
                'label' => esc_html__( 'Box Border', 'turitor' ),
                'selector' => '{{WRAPPER}} .single-course',
            ]
        );
        $this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'feature_box_shadow',
				'label' => esc_html__( 'Box Shadow', 'turitor' ),
				'selector' => '{{WRAPPER}} .single-course',
			]
		);
         
        $this->end_controls_tab();

        $this->start_controls_tab(
        'boxed_border_style_hover',
            [
                'label' =>esc_html__( 'Hover', 'turitor' ),
            ]
        );
 
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'hover_border',
                'label' => esc_html__( 'Box Border', 'turitor' ),
                'selector' => '{{WRAPPER}} .single-course:hover',
            ]
        );
        $this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'feature_box_hov_shadow',
                'label' => esc_html__( 'Box hover Shadow', 'turitor' ),
				'selector' => '{{WRAPPER}} .single-course:hover',
			]
		);
        $this->end_controls_tab();
        $this->end_controls_tabs();
    
      $this->end_controls_section();
     
    }    
    protected function render() {
   
      $settings   = $this->get_settings();

      $turitor_course_settings = array(
       
        'order'             => $settings['order'],
        'cat_id'            => $settings['cat_id'],
        'course_list'            => $settings['course_list'],
        'layout'            => $settings['layout'],
        'limit'             => $settings['limit'],
     
        'tabs-options'      => array(
          'limit_tab'  => $settings['limit_tab'],
          'cat_id_tab' => $settings['cat_id_tab']
        ),
        'featured'          => $settings['featured'],
        'all_category' => $this->course_category()
      );

      if(defined('LP_COURSE_CPT')){
        include (locate_template("components/editor/elementor/widgets/style/courses/{$settings['layout']}.php", false, false ));  
      }
  
      
    }
   
    public function course_list(){
      if(!defined('LP_COURSE_CPT')){
        return [];
      }
      $args = array(

        'post_type'   => 'lp_course',
        'orderby' => 'post_date', 
        'order' => 'DESC',
        'post_status'  => 'publish',
        'posts_per_page' => -1
                  
        );  

        $lp_course = get_posts( $args ); 
        $course_list = [];
       
        foreach ($lp_course as $postdata) {
            setup_postdata( $postdata );
            $course_list[$postdata->ID] = [$postdata->post_title];
         
        }
      
        return $course_list;
    }

 

}