<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Turitor_Course_category_Widget extends Widget_Base {


  public $base;

    public function get_name() {
        return 'turitor-course-category';
    }

    public function get_title() {

        return esc_html__( 'Turitor course category', 'turitor' );

    }

    public function get_icon() { 
        return 'eicon-search';
    }

    public function get_categories() {
        return [ 'turitor-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'Course Categories', 'turitor' )
			]
		);


		$this->add_control(
			'layout',
			[
				'label'   => esc_html__( 'Layout', 'turitor' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'grid'       => esc_html__( 'Grid style 1', 'turitor' ),
					'grid2'      => esc_html__( 'Grid style 2', 'turitor' ),
					'grid3'      => esc_html__( 'Grid style 3', 'turitor' ),
					
				],
				'default' => 'grid'
			]
		);


		$this->add_control(
			'grid-options',
			[
				'label'     => esc_html__( 'Grid Layout Options', 'turitor' ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'grid_limit',
			[
				'label'   => esc_html__( 'Limit categories', 'turitor' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 6,
				'min'     => 1,
				'step'    => 1,
			]
		);

		$this->add_control(
			'grid_column',
			[
				'label'   => esc_html__( 'Number Column', 'turitor' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'6'     => esc_html__( '2', 'turitor' ),
					'4'       => esc_html__( '3', 'turitor' ),
					'3' => esc_html__( '4', 'turitor' ),
				],
				'default' => '3',
			]
		);
		$this->add_control(
			'course_count_show',
			[
				'label'     => esc_html__( 'Course Count Show?', 'turitor' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'yes',
			]
		);
		$this->add_control(
			'hide_empty',
			[
				'label'     => esc_html__( 'hide Empty?', 'turitor' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => '',
			]
		);
		$this->add_control(
			'cat_id',
			[
			  'label'     => esc_html__( 'Select Category', 'turitor' ),
			  'type'      => Controls_Manager::SELECT2,
			  'options'   => $this->course_category(),
			  'multiple' =>true,
			]
		  );

		  $this->add_responsive_control(
			'content_align', [
				'label'			 => esc_html__( 'Alignment', 'turitor' ),
				'type'			 => Controls_Manager::CHOOSE,
				'options'		 => [

					'left'		 => [
						'title'	 => esc_html__( 'Left', 'turitor' ),
						'icon'	 => 'fa fa-align-left',
					],
					'center'	 => [
						'title'	 => esc_html__( 'Center', 'turitor' ),
						'icon'	 => 'fa fa-align-center',
					],
					'right'		 => [
						'title'	 => esc_html__( 'Right', 'turitor' ),
						'icon'	 => 'fa fa-align-right',
					],
					'justify'	 => [
						'title'	 => esc_html__( 'Justified', 'turitor' ),
						'icon'	 => 'fa fa-align-justify',
					],
				],
				'default'		 => 'center',
                'selectors' => [
                    '{{WRAPPER}} .single-course-category' => 'text-align: {{VALUE}};',
                    
				],
			]
        );


		$this->end_controls_section();

		
		$this->start_controls_section(
			'section_style', [
				'label'	 => esc_html__( 'Title', 'turitor' ),
				'tab'	 => Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'title_color', [
					'label'		 => esc_html__( 'Title color', 'turitor' ),
					'type'		 => Controls_Manager::COLOR,
					'selectors'	 => [
						'{{WRAPPER}} .single-course-category .course-category-title a' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'title_hover_color', [
					'label'		 => esc_html__( 'Title Hover color', 'turitor' ),
					'type'		 => Controls_Manager::COLOR,
					'selectors'	 => [
						'{{WRAPPER}} .single-course-category:hover .course-category-title a' => 'color: {{VALUE}};',
					],
				]
			);
	
			 
			$this->add_group_control(
				Group_Control_Typography::get_type(), [
				'name'		 => 'title_typography',
				'selector'	 => '{{WRAPPER}} .single-course-category .course-category-title',
				]
				);
				
				$this->add_responsive_control(
					'title_margin',
					[
						'label' => esc_html__( 'Tilte margin', 'turitor' ),
						'type' => Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', '%', 'em' ],
						'selectors' => [
							'{{WRAPPER}} .single-course-category .course-category-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
					);
			
			$this->end_controls_section();

			
		$this->start_controls_section(
			'section_sub_title_style', [
				'label'	 => esc_html__( 'Course count Title', 'turitor' ),
				'tab'	 => Controls_Manager::TAB_STYLE,
				'condition' => ['course_count_show' => 'yes'],
				]
			);
			$this->add_control(
				'sub_title_color', [
					'label'		 => esc_html__( 'Course count color', 'turitor' ),
					'type'		 => Controls_Manager::COLOR,
					'selectors'	 => [
						'{{WRAPPER}} .single-course-category .course-count' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'sub_title_hover_color', [
					'label'		 => esc_html__( 'Course count hover color', 'turitor' ),
					'type'		 => Controls_Manager::COLOR,
					'selectors'	 => [
						'{{WRAPPER}} .single-course-category:hover .course-count' => 'color: {{VALUE}};',
					],
				]
			);
	
			 
			$this->add_group_control(
				Group_Control_Typography::get_type(), [
				'name'		 => 'sub_title_typography',
				'selector'	 => '{{WRAPPER}} .single-course-category .course-count',
				]
				);
				
				$this->add_responsive_control(
					'course_count_margin',
					[
						'label' => esc_html__( 'Course count margin', 'turitor' ),
						'type' => Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', '%', 'em' ],
						'selectors' => [
							'{{WRAPPER}} .single-course-category .course-count' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
					);
			
			$this->end_controls_section();


			$this->start_controls_section(
				'img_style', [
					'label'	 => esc_html__( 'Image Icon', 'turitor' ),
					'tab'	 => Controls_Manager::TAB_STYLE,
					]
				);
				$this->add_control(
					'img_width',
					[
						'label' => esc_html__( 'Width', 'turitor' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => [ 'px', '%' ],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 300,
							],
							'%' => [
								'min' => 0,
								'max' => 100,
							],
						],
					
						'selectors' => [
							'{{WRAPPER}} .ts-course-category .single-course-category .course-media img' => 'width: {{SIZE}}{{UNIT}};',
						],
					]
				);
				$this->add_control(
					'img_height',
					[
						'label' => esc_html__( 'Height', 'turitor' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => [ 'px', '%' ],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 300,
								'step' => 5,
							],
							'%' => [
								'min' => 0,
								'max' => 100,
							],
						],
					
						'selectors' => [
							'{{WRAPPER}} .ts-course-category .single-course-category .course-media img' => 'height: {{SIZE}}{{UNIT}};',
						],
					]
				);


				$this->end_controls_section();
	
			$this->start_controls_section(
				'advance_style', [
					'label'	 => esc_html__( 'Advance', 'turitor' ),
					'tab'	 => Controls_Manager::TAB_STYLE,
					]
				);

				$this->add_control(
					'hover_shape_color', [
						'label'		 => esc_html__( 'Hover Shape color', 'turitor' ),
						'type'		 => Controls_Manager::COLOR,
						'selectors'	 => [
							'{{WRAPPER}} .course-dot-shape path' => 'fill: {{VALUE}};',
							'{{WRAPPER}} .course-round-shape' => 'background-color: {{VALUE}};',
						],
					]
				);

				$this->add_control(
					'box_bg_color', [
						'label'		 => esc_html__( 'Box BG color', 'turitor' ),
						'type'		 => Controls_Manager::COLOR,
						'selectors'	 => [
							'{{WRAPPER}} .ts-course-category .single-course-category' => 'background-color: {{VALUE}};',
						],
					]
				);
				$this->add_control(
					'box_bg_hover_color', [
						'label'		 => esc_html__( 'Box BG hover color', 'turitor' ),
						'type'		 => Controls_Manager::COLOR,
						'selectors'	 => [
							'{{WRAPPER}} .ts-course-category .single-course-category:hover' => 'background-color: {{VALUE}};',
						],
					]
				);

			$this->add_responsive_control(
				'content_padding',
				[
					'label' => esc_html__( 'Content padding', 'turitor' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors' => [
						'{{WRAPPER}} .single-course-category' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'content_margin',
				[
					'label' => esc_html__( 'Content margin', 'turitor' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors' => [
						'{{WRAPPER}} .single-course-category' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'content_border',
					'label' => esc_html__( 'Border', 'turitor' ),
					'selector' => '{{WRAPPER}} .single-course-category',
				]
			);

			$this->add_responsive_control(
				'content_border_radius',
				[
					'label' => esc_html__( 'Border Radius', 'turitor' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors' => [
						'{{WRAPPER}} .single-course-category' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		

			$this->end_controls_section();
		}

    protected function render( ) { 

		  $settings = $this->get_settings();

        
        $turitor_course_settings = array(
		
			'layout'         => $settings['layout'],
			'hide_empty'    => $settings['hide_empty'],
			'course_count_show'    => $settings['course_count_show'],
			'grid-options'   => array(
				'grid_limit'  => $settings['grid_limit'],
				'grid_column' => $settings['grid_column'],
				'categories_id'  => $settings['cat_id']
			)

        );
        if(defined('LP_COURSE_CPT')){
			include (locate_template("components/editor/elementor/widgets/style/course-category/{$settings['layout']}.php", false, false ));  
		}
		
    }
	protected function _content_template() { }
	
	public function course_category(){
		if(!defined('LP_COURSE_CPT')){
          return [];
		}
		$tax_terms = get_terms('course_category', array('hide_empty' => false));
		$category_list = [];
		 
		foreach($tax_terms as $term_single) {      
			$category_list[$term_single->term_id] = [$term_single->name];
		 
		}
	  
		return $category_list;
	  }
}