<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;


class Turitor_Cartbtn_Widget extends Widget_Base
{


	public $base;

	public function get_name()
	{
		return 'turitor-cartbtn';
	}

	public function get_title()
	{
		return esc_html__('Cart Button', 'turitor');
	}

	public function get_icon()
	{
		return 'fas fa-cart-arrow-down';
	}

	public function get_categories()
	{
		return ['turitor-elements'];
	}

	protected function _register_controls()
	{

		$this->start_controls_section(
			'section_tab',
			[
				'label' => esc_html__('Cart Btn settings', 'turitor'),
			]
		);


		$this->add_control(
			'cart_btn_icon',
			[
				'label' => esc_html__('Icon', 'turitor'),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'tsicon tsicon-cart',
				],
			]
		);



		$this->add_responsive_control(
			'title_align',
			[
				'label'			 => esc_html__('Alignment', 'turitor'),
				'type'			 => Controls_Manager::CHOOSE,
				'options'		 => [

					'left'		 => [
						'title'	 => esc_html__('Left', 'turitor'),
						'icon'	 => 'fa fa-align-left',
					],
					'center'	 => [
						'title'	 => esc_html__('Center', 'turitor'),
						'icon'	 => 'fa fa-align-center',
					],
					'right'		 => [
						'title'	 => esc_html__('Right', 'turitor'),
						'icon'	 => 'fa fa-align-right',
					],
					'justify'	 => [
						'title'	 => esc_html__('Justified', 'turitor'),
						'icon'	 => 'fa fa-align-justify',
					],
				],
				'default'		 => 'center',
				'selectors' => [
					'{{WRAPPER}} .cartbtn .cart-link ' => 'text-align: {{VALUE}};',
					'{{WRAPPER}} .cartbtn .cart-link ' => 'text-align: {{VALUE}};',

				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'cart_btn_style',
			[
				'label'	 => esc_html__('Cart Button Style', 'turitor'),
				'tab'	 => Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_control(
			'cartbtn_color',
			[
				'label'		 => esc_html__('Cart Button Color', 'turitor'),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .cartbtn .cart-link .cart-contents' => 'color: {{VALUE}};',
				],
			]
		);


		$this->add_control(
			'cartbtn_hover_color',
			[
				'label'		 => esc_html__('Cart Button hover Color', 'turitor'),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .cartbtn .cart-link .cart-contents:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'cartbtn_bg_color',
				'label' => esc_html__('Cart Button hover BG Color', 'turitor'),
				'types' => ['classic', 'gradient', 'video'],
				'selector' => '{{WRAPPER}} .cartbtn .cart-link .cart-contents:hover',
			]
		);

		$this->add_control(
			'cartbtn_bdr_color',
			[
				'label'		 => esc_html__('Border color', 'turitor'),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .cartbtn .cart-link .cart-contents' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'cartbtn_hover_bdr_color',
			[
				'label'		 => esc_html__('Hover Border color', 'turitor'),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .cartbtn .cart-link .cart-contents:hover' => 'border-color: {{VALUE}};',
				],
			]
		);


		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'		 => 'cartbtn_typography',
				'selector'	 => '{{WRAPPER}} .cartbtn .cart-link .cart-contents',
			]
		);
		$this->end_controls_section();
	}

	protected function render()
	{
		$settings       = $this->get_settings();

		if (defined('LP_COURSE_CPT')) { ?>
			<div class="cartbtn">
				<div class="cart-link">
					<a class="cart-contents" href="<?php echo esc_url(learn_press_get_checkout_url()); ?>">
						<?php Icons_Manager::render_icon($settings['cart_btn_icon'], ['aria-hidden' => 'true']); ?>
						<sup><?php turitor_cart_count(); ?></sup>
					</a>
				</div>
			</div>
		<?php
		} elseif (class_exists('WooCommerce')) { ?>
			<div class="cartbtn">
				<div class="cart-link">
					<a class="cart-contents" href="<?php echo wc_get_cart_url(); ?>" title="<?php esc_attr_e('View your shopping cart', 'turitor'); ?>">
						<?php Icons_Manager::render_icon($settings['cart_btn_icon'], ['aria-hidden' => 'true']); ?>
					</a>
					<sup><?php echo sprintf(_n('%d item', '%d', WC()->cart->cart_contents_count, 'turitor'), WC()->cart->cart_contents_count); ?></sup>
				</div>
			</div>
		<?php } ?>
<?php
	}
	protected function _content_template()
	{
	}
}
