<?php
   namespace Elementor;
   
   if ( ! defined( 'ABSPATH' ) ) exit;

   class Turitor_Buddypress_Unreadmessage_Widget extends Widget_Base {
   
   
      public $base;
   
      public function get_name() {
         return 'buddypress-unreadmessage';
      }
   
      public function get_title() {
         return esc_html__( 'Buddypress Unread Messages', 'turitor' );
      }
   
      public function get_icon() { 
         return 'eicon-testimonial';
      }
   
      public function get_categories() {
         return [ 'turitor-elements' ];
      }
   
      protected function _register_controls() {
         $this->start_controls_section(
            'section_tab', [
               'label' => esc_html__( 'Unread messages', 'turitor' ),
            ]
         );
      
         $this->add_control(
            'bp_message_icon',
            [
               'label' => esc_html__('Icon', 'turitor'),
               'type' => Controls_Manager::ICONS,
               'default' => [
                  'value' => 'fas fa-comment',
                  'library' => 'solid',
               ],
            ]
         );
   
   
      $this->end_controls_section();
      
		$this->start_controls_section(
			'buddypress_message_style',
			[
				'label'	 => esc_html__('Message Style', 'turitor'),
				'tab'	 => Controls_Manager::TAB_STYLE,
			]
		);

      $this->add_responsive_control(
			'buddypress_message_padding',
			[
				'label' => esc_html__('Message Item Padding', 'turitor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} #buddypress .activity-list > li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);

      $this->end_controls_section();
   
   } 
   
    protected function render() {
      
      $settings        = $this->get_settings();

      ?>
         <?php $user_id = get_current_user_id(); ?>
         <div class="bp-notify">
            <a class="notify-icon" href="#">
               <?php 
                  Icons_Manager::render_icon($settings['bp_message_icon'], ['aria-hidden' => 'true']); 
               ?>
            </a>
            <?php if(is_user_logged_in()){ ?>
               <sup> <?php echo messages_get_unread_count( $user_id ); ?> </sup>
            <?php } else { ?>
               <sup>0</sup>
            <?php } ?>
         </div>
      <?php
   
    }
}