<?php
   namespace Elementor;
   
   if ( ! defined( 'ABSPATH' ) ) exit;

   class Turitor_Buddypress_Member_Widget extends Widget_Base {
   
   
      public $base;
   
      public function get_name() {
         return 'buddypress-member';
      }
   
      public function get_title() {
         return esc_html__( 'Buddypress Member', 'turitor' );
      }
   
      public function get_icon() { 
         return 'fas fa-user-friends';
      }
   
      public function get_categories() {
         return [ 'turitor-elements' ];
      }
   
      protected function _register_controls() {
         $this->start_controls_section(
            'section_tab', [
               'label' => esc_html__( 'Latest Member', 'turitor' ),
            ]
         );
      
         $this->add_control(
            'member_count',
            [
               'label'         => esc_html__( 'Member count', 'turitor' ),
               'type'          => Controls_Manager::NUMBER,
               'default'       => '4',
            ]
         );
   
         $this->add_control(
            'member_style',
            [
               'label'   => esc_html__( 'Member Style', 'turitor' ),
               'type'    => Controls_Manager::SELECT,
               'default' => 'style1',
               'options' => [
                  'style1'  => esc_html__( 'Style 1 ', 'turitor' ),
               ],
            ]
         );

         $this->add_control(
            'member_order',
            [
               'label'   => esc_html__( 'Order By', 'turitor' ),
               'type'    => Controls_Manager::SELECT,
               'default' => 'active',
               'options' => [
                  'active'  => esc_html__( 'Last Active ', 'turitor' ),
                  'newest'  => esc_html__( 'Newest Registered', 'turitor' ),
                  'alphabetical'  => esc_html__( 'Alphabetical', 'turitor' ),
                  'popular'  => esc_html__( 'Popular', 'turitor' ),
                  'online'  => esc_html__( 'Online', 'turitor' ),
                  'random'  => esc_html__( 'Random', 'turitor' ),
               ],
            ]
         );
      
      $this->add_control(
         'post_col',
         [
            'label'   => esc_html__( 'Post Column', 'turitor' ),
            'type'    => Controls_Manager::SELECT,
            'default' => '4',
            'options' => [
               '3'  => esc_html__( '4 Column ', 'turitor' ),
               '4'  => esc_html__( '3 Column', 'turitor' ),
               '6'  => esc_html__( '2 Column', 'turitor' ),
            ],
         ]
      );
   
      $this->end_controls_section();
      
		$this->start_controls_section(
			'buddypress_member_style',
			[
				'label'	 => esc_html__('Member Style', 'turitor'),
				'tab'	 => Controls_Manager::TAB_STYLE,
			]
		);

      $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'overlay_color',
				'label' => esc_html__('Member Overlay BG Color', 'turitor'),
				'types' => ['classic', 'gradient', 'video'],
				'selector' => '{{WRAPPER}} .bp-single-item.bp-single-group::before',
			]
		);

      $this->add_responsive_control(
			'buddypress_member_margin',
			[
				'label' => esc_html__('Item Margin', 'turitor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .bp-single-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);
      

      $this->add_responsive_control(
			'member_cover_height',
			[
				'label' => esc_html__('Cover Image Height', 'turitor'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}}  .bp-single-item .author-area' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

      $this->end_controls_section();
   
    } 
   
    protected function render() {
      
      $settings        = $this->get_settings();

      $member_style = $settings['member_style'];
      $member_count = $settings['member_count'];
      $post_col = $settings['post_col'];
      $member_order = $settings['member_order'];
      

      include (locate_template("components/editor/elementor/widgets/style/buddypress/member/{$member_style}.php", false, false ));  
   
    }
}