<?php
//users profile

add_action( 'show_user_profile', 'turitor_show_extra_profile_fields' );
add_action( 'edit_user_profile', 'turitor_show_extra_profile_fields' );

function turitor_show_extra_profile_fields( $user ) {

	$user_social_link = get_the_author_meta( 'user_social_link', $user->ID );
	$turitor_user_designation = get_the_author_meta( 'turitor_user_designation', $user->ID );
	
	?>

	<h2> <?php esc_html_e( 'User Basic information', 'turitor' ); ?> </h2>

	<table class="form-table designation-table">
		<tr>
			<th>
				<h3><?php esc_html_e( 'Designation', 'turitor' ); ?></h3>
			</th>
			<td>
				<input type="text" name="designation" value="<?php echo esc_attr($turitor_user_designation); ?>" placeholder='designation'/>
			</td>
		</tr>
	</table>

	  <table class="form-table social-table">
		  <tr>
			  <th>
			  		<h3><?php esc_html_e( 'Social share', 'turitor' ); ?></h3>
			  </th>
			  <td>
			  		<div class='social_repeater'>

					<div data-repeater-list="user_social_link" class="social_list">
						<?php if(is_array($user_social_link)): ?> 
								<?php foreach($user_social_link as $social): ?> 
									<div data-repeater-item>
										<input type="text" name="icon" list="brands" value="<?php echo esc_attr($social['icon']); ?>" placeholder='<?php echo esc_attr__('icon','turitor-essential'); ?>'/>
										<input type="text" name="url" value="<?php echo esc_attr($social['url']); ?>" placeholder='<?php echo esc_attr__('url','turitor-essential'); ?>'/>
										<input type="text" name="title" value="<?php echo esc_attr($social['title']); ?>" placeholder='<?php echo esc_attr__('title','turitor-essential'); ?>'/>
										<input data-repeater-delete type="button" value="<?php echo esc_html('Delete','turitor'); ?>"/>
									</div>
								<?php endforeach; ?>
						<?php else: ?>		
						<div data-repeater-item>
							<input type="text" name="icon" list="brands"  placeholder='<?php echo esc_attr__('Icon','turitor-essential'); ?>'/>
							<input type="text" name="url" placeholder='<?php echo esc_attr__('Url','turitor-essential'); ?>'/>
							<input type="text" name="title" placeholder='<?php echo esc_attr__('Title','turitor-essential'); ?>'/>
							
							<input data-repeater-delete type="button" class="button button-primary danger" value="<?php echo esc_html('Delete','turitor'); ?>"/>
						</div>
							<?php endif; ?>

					</div>
					<input data-repeater-create type="button" class="button button-primary success" value="<?php echo esc_html('Add social','turitor'); ?>"/>

					</div>	
					<datalist id="brands">
					    <?php if(function_exists('turitor_fontawesome_icons')): $s_icons = turitor_fontawesome_icons(); ?>
						    <?php foreach($s_icons as $s_key => $s_icon) { ?>
					        	<option value="<?php echo esc_attr($s_key); ?>"> <?php echo esc_html($s_icon); ?> </option> 
						    <?php } ?>
						<?php endif; ?>
					</datalist>	
					
			  </td>
		  </tr>
	  </table>
	
	
	<?php
}


add_action( 'personal_options_update', 'turitor_update_profile_fields' );
add_action( 'edit_user_profile_update', 'turitor_update_profile_fields' );

function turitor_update_profile_fields( $user_id ) {
	if ( ! current_user_can( 'edit_user', $user_id ) ) {
		return false;
	}
  if(isset($_POST['user_social_link'])){
	update_user_meta( $user_id, 'user_social_link',  $_POST['user_social_link']  );
  }
  if(isset($_POST['designation'])){
	update_user_meta( $user_id, 'turitor_user_designation',  $_POST['designation']  );
  }
 

}

//frontend

function turitor_save_profile_basic_information(){
 if(isset($_POST['save-profile-basic-information'])){
	if(isset($_POST['user_social_link'])){
		update_user_meta( get_current_user_id(), 'user_social_link',  $_POST['user_social_link']  );
	} 

	if(isset($_POST['designation'])){
		update_user_meta( get_current_user_id(), 'turitor_user_designation',  $_POST['designation']  );
	}
	
	
 }
 

}
add_action('init','turitor_save_profile_basic_information');



