<?php
$service = happyforms_get_integrations()->get_service( 'stripe' );
$credentials = $service->get_credentials();
$enabled = $service->is_enabled();
?>
<div id="happyforms-service-<?php echo $service->id; ?>" class="happyforms-service-integration<?php echo ( $enabled ) ? ' enabled' : ''; ?>">
	<p>
		<label>
			<input type="checkbox" class="happyforms-service-toggle" name="credentials[stripe][enabled]" value="1" <?php checked( $enabled, true ); ?>> <?php _e( 'Stripe', 'happyforms' ); ?>
		</label>
	</p>

	<div class="nested-block">
		<div class="widget-content <?php if ( $service->is_connected() ) : ?>authenticated<?php endif; ?>">
			<input type="hidden" name="services[]" value="<?php echo $service->id; ?>">
			<?php
			happyforms_credentials_input(
				$service->id,
				'key',
				__( 'Publishable key (live)', 'happyforms' ),
				$credentials['key']
			);
			?>
			<?php
			happyforms_credentials_input(
				$service->id,
				'secret_key',
				__( 'Secret key (live)', 'happyforms' ),
				$credentials['secret_key']
			);
			?>
			<?php
			happyforms_credentials_input(
				$service->id,
				'test_key',
				__( 'Publishable key (test)', 'happyforms' ),
				$credentials['test_key']
			);
			?>
			<?php
			happyforms_credentials_input(
				$service->id,
				'test_secret_key',
				__( 'Secret key (test)', 'happyforms' ),
				$credentials['test_secret_key']
			);
			?>
			<p>
				<label>
					<?php $checked = happyforms_is_truthy( $credentials['test_mode'] ); ?>
					<input type="checkbox" name="credentials[stripe][test_mode]" value="1" <?php checked( $checked, true ); ?>> <?php _e( 'Use test mode', 'happyforms' ); ?>
				</label>
			</p>
		</div>
	</div>
</div>
