<?php

$integrations = happyforms_get_integrations();
$service = $integrations->get_service( 'recaptchav3' );
$credentials = $service->get_credentials();
?>
<div id="happyforms-service-<?php echo $service->id; ?>" class="happyforms-service-integration">
	<div class="widget-content <?php if ( $service->is_connected() ) : ?>authenticated<?php endif; ?>">
		<?php
		happyforms_credentials_input(
			$service->id,
			'site',
			__( 'Site key', 'happyforms' ),
			$credentials['site']
		);
		?>
		<?php
		happyforms_credentials_input(
			$service->id,
			'secret',
			__( 'Secret key', 'happyforms' ),
			$credentials['secret']
		);
		?>
		<p>
			<label for="happyforms_integrations_recaptchav3_min_score"><?php _e( 'Min accepted score:', 'happyforms' ); ?></label>
			<select id="happyforms_integrations_recaptchav3_min_score" name="credentials[recaptchav3][min_score]" class="widefat">
				<option value="0.1" <?php selected( '0.1', $credentials['min_score'] ); ?>>0.1</option>
				<option value="0.2" <?php selected( '0.2', $credentials['min_score'] ); ?>>0.2</option>
				<option value="0.3" <?php selected( '0.3', $credentials['min_score'] ); ?>>0.3</option>
				<option value="0.4" <?php selected( '0.4', $credentials['min_score'] ); ?>>0.4</option>
				<option value="0.5" <?php selected( '0.5', $credentials['min_score'] ); ?>>0.5 <?php _e( '(recommended)', 'happyforms' ); ?></option>
				<option value="0.6" <?php selected( '0.6', $credentials['min_score'] ); ?>>0.6</option>
				<option value="0.7" <?php selected( '0.7', $credentials['min_score'] ); ?>>0.7</option>
				<option value="0.8" <?php selected( '0.8', $credentials['min_score'] ); ?>>0.8</option>
				<option value="0.9" <?php selected( '0.9', $credentials['min_score'] ); ?>>0.9</option>
				<option value="1.0" <?php selected( '1.0', $credentials['min_score'] ); ?>>1.0</option>
			</select>
		</p>
	</div>
</div>
