<?php

class HappyForms_Service_PayPal extends HappyForms_Service {

	public $id = 'paypal';
	public $group = 'payments';

	public function __construct() {
		$this->label = __( 'PayPal', 'happyforms' );
	}

	public function set_credentials( $credentials = array(), $raw = array() ) {
		$this->credentials = array(
			'enabled' => '',
			'client_id' => '',
			'client_secret' => '',
			'sandbox_client_id' => '',
			'sandbox_client_secret' => '',
			'sandbox_mode' => '',
		);

		foreach ( $this->credentials as $key => $value ) {
			if ( isset( $credentials[$key] ) && '' !== $credentials[$key] ) {
				$this->credentials[$key] = $credentials[$key];
			} else {
				$this->credentials[$key] = '';
			}
		}

		if ( ! empty( $raw ) ) {
			$this->credentials['enabled']      = ( isset( $raw['enabled'] ) ) ? 1 : 0;
			$this->credentials['sandbox_mode'] = ( isset( $raw['sandbox_mode'] ) ) ? 1 : 0;
		}
	}

	public function is_enabled() {
		if ( 1 === (int) $this->credentials['enabled'] ) {
			return true;
		}

		if (
			'' === $this->credentials['enabled'] &&
			( ! empty( $this->credentials['client_id'] ) || ! empty( $this->credentials['sandbox_client_id'] ) )
		) {
			return true;
		}

		return false;
	}

	public function is_connected() {
		$enabled = $this->is_enabled();

		$authenticated_live = (
			! empty( $this->credentials['client_id'] )
			&& ! empty( $this->credentials['client_secret'] )
		);

		$authenticated_sandbox = (
			! empty( $this->credentials['sandbox_client_id'] )
			&& ! empty( $this->credentials['sandbox_client_secret'] )
			&& happyforms_is_truthy( $this->credentials['sandbox_mode'] )
		);

		$authenticated = $enabled && ( $authenticated_live || $authenticated_sandbox );

		return $authenticated;
	}

	public function admin_widget( $previous_credentials = array() ) {
		require_once( happyforms_get_integrations_folder() . '/services/paypal/partial-widget.php' );
	}

	public function configure() {
		$this->load();
	}

	public function load() {
		if ( $this->is_connected() ) {
			require_once( happyforms_get_integrations_folder() . '/services/paypal/class-integration-paypal.php' );
		}
	}

}
