(function ($, _, Backbone, api, paymentsSettings, settings ) {

	happyForms.classes.models.parts.payments = happyForms.classes.models.Part.extend( {
		defaults: function () {
			return _.extend(
				{},
				settings.formParts.payments.defaults,
				_.result( happyForms.classes.models.Part.prototype, 'defaults' ),
			);
		},
	} );

	happyForms.classes.views.parts.payments = happyForms.classes.views.Part.extend( {
		template: '#happyforms-customize-payments-template',
		editor: null,

		initialize: function() {
			happyForms.classes.views.Part.prototype.initialize.apply( this, arguments );

			this.listenTo( this.model, 'change:show_user_price_field', this.onUserPriceFieldChange );

			this.listenTo( this.model, 'change:price_label', this.onPriceLabelChange );
			this.listenTo( this.model, 'change:price', this.onPriceChange );
			this.listenTo( this.model, 'change:stripe_option_label', this.onStripeOptionLabelChange );
			this.listenTo( this.model, 'change:payment_method_choice_label', this.onPaymentMethodChoiceLabelChange );
			this.listenTo( this.model, 'change:user_price_label', this.onUserPriceLabelChange );
			this.listenTo( this.model, 'change:user_price_placeholder', this.onUserPricePlaceholderChange );
			this.listenTo( this.model, 'change:currency', this.onCurrencyChange );
		},

		ready: function () {
			happyForms.classes.views.Part.prototype.ready.apply(this, arguments);
		},

		onUserPriceFieldChange: function( model, value ) {
			var $labelField = $( '[data-trigger=show_user_price_field]', this.$el );

			if ( 1 == value ) {
				$( '.price-field', this.$el ).hide();
				$( '[data-logic-id=price]', this.$el ).hide();

				$labelField.show();
			} else {
				$( '.price-field', this.$el ).show();
				$( '[data-logic-id=price]', this.$el ).show();

				$labelField.hide();
			}

			this.refreshPart();
		},

		onPriceChange: function() {
			var data = {
				id: this.model.get( 'id' ),
				callback: 'onPaymentsPriceChange'
			};

			happyForms.previewSend( 'happyforms-part-dom-update', data );
		},

		onPriceLabelChange: function() {
			var data = {
				id: this.model.get( 'id' ),
				callback: 'onPaymentsPriceLabelChange',
			};

			happyForms.previewSend( 'happyforms-part-dom-update', data );
		},

		onStripeOptionLabelChange: function() {
			var data = {
				id: this.model.get( 'id' ),
				callback: 'onPaymentsStripeOptionLabelChange',
			};

			happyForms.previewSend( 'happyforms-part-dom-update', data );
		},

		onPaymentMethodChoiceLabelChange: function() {
			var data = {
				id: this.model.get( 'id' ),
				callback: 'onPaymentsPaymentMethodChoiceLabelChange',
			};

			happyForms.previewSend( 'happyforms-part-dom-update', data );
		},

		onUserPriceLabelChange: function() {
			var data = {
				id: this.model.get( 'id' ),
				callback: 'onPaymentsUserPriceLabelChange',
			};

			happyForms.previewSend( 'happyforms-part-dom-update', data );
		},

		onUserPricePlaceholderChange: function() {
			var data = {
				id: this.model.get( 'id' ),
				callback: 'onPaymentsUserPricePlaceholderChange'
			};

			happyForms.previewSend( 'happyforms-part-dom-update', data );
		},

		onCurrencyChange: function( model, value ) {
			var currencyData = paymentsSettings.currencies[value];
			var symbol = currencyData.symbol;

			var data = {
				id: this.model.get( 'id' ),
				callback: 'onPaymentsCurrencyChange',
				options: {
					symbol: symbol
				}
			};

			happyForms.previewSend( 'happyforms-part-dom-update', data );
		}

	} );

	happyForms.previewer = _.extend( happyForms.previewer, {
		onPaymentsPriceLabelChange: function( id, html, options ) {
			var part = this.getPartModel( id );
			var $part = this.getPartElement( html );
			var $label = this.$( '.happyforms-payments__price .label', $part );

			$label.text( part.get( 'price_label' ) );
		},

		onPaymentsPriceChange: function( id, html, options ) {
			var part = this.getPartModel( id );
			var $part = this.getPartElement( html );
			var $price = this.$( '.happyforms-payments__price .price strong', $part );
			var $priceInput = this.$( '.happyforms-payments__price input', $part );

			var language = navigator.language ? navigator.language : 'en-US';
			var formattedPrice = new Intl.NumberFormat(
				language,
				{
					style: 'decimal',
					minimumFractionDigits: 2,
					maximumFractionDigits: 2
				}
			).format( part.get( 'price' ) );

			$priceInput.attr( 'data-default', part.get( 'price' ) );
			$price.text( formattedPrice );
		},

		onPaymentsStripeOptionLabelChange: function( id, html, options ) {
			var part = this.getPartModel( id );
			var $part = this.getPartElement( html );
			var $label = this.$( '.happyforms-payments__choice-stripe .label', $part );

			$label.text( part.get( 'stripe_option_label' ) );
		},

		onPaymentsPaymentMethodChoiceLabelChange: function( id, html, options ) {
			var part = this.getPartModel( id );
			var $part = this.getPartElement( html );
			var $label = this.$( '.happyforms-payments__payment-method-choice .happyforms-part__label .label', $part );

			$label.text( part.get( 'payment_method_choice_label' ) );
		},

		onPaymentsUserPriceLabelChange: function( id, html, options ) {
			var part = this.getPartModel( id );
			var $part = this.getPartElement( html );
			var $label = this.$( '.happyforms-payments__user-price .label', $part );

			$label.text( part.get( 'user_price_label' ) );
		},

		onPaymentsUserPricePlaceholderChange: function( id, html, options ) {
			var part = this.getPartModel( id );
			var $part = this.getPartElement( html );
			var $input = this.$( '.happyforms-payments__user-price input', $part );

			$input.attr( 'placeholder', part.get( 'user_price_placeholder' ) );
		},

		onPaymentsCurrencyChange: function( id, html, options ) {
			var $part = this.getPartElement( html );

			var $currencySymbol = this.$( '.happyforms-payments__price .price span', $part );

			if ( $currencySymbol.length ) {
				$currencySymbol.html( options.symbol );
			}

			var $currencySymbolUserPrefix = this.$( '.happyforms-payments__user-price .happyforms-input-group__prefix span', $part );

			if ( $currencySymbolUserPrefix.length ) {
				$currencySymbolUserPrefix.html( options.symbol );
			}
		},
	} );

	var FormBuild = happyForms.classes.views.FormBuild;

	happyForms.classes.views.FormBuild = FormBuild.extend( {
		ready: function() {
			FormBuild.prototype.ready.apply( this, arguments );

			var paymentPart = happyForms.form.get( 'parts' ).findWhere( { type: 'payments' } );

			if ( paymentPart ) {
				this.$el.addClass( 'has-payments-part' );
				this.drawer.$el.addClass( 'has-payments-part' );
			}
		},

		onPartAdd: function( type, options ) {
			if ( 'payments' === type ) {
				var paymentPart = happyForms.form.get( 'parts' ).findWhere( { type: 'payments' } );

				if ( paymentPart ) {
					return;
				}

				this.$el.addClass( 'has-payments-part' );
				this.drawer.$el.addClass( 'has-payments-part' );
			}

			FormBuild.prototype.onPartAdd.apply( this, arguments );
		},

		onPartModelRemove: function( model ) {
			FormBuild.prototype.onPartModelRemove.apply( this, arguments );

			if ( 'payments' === model.get( 'type' ) ) {
				this.$el.removeClass( 'has-payments-part' );
				this.drawer.$el.removeClass( 'has-payments-part' );
			}
		}
	} );

} )( jQuery, _, Backbone, wp.customize, _happyFormsPaymentsPartSettings, _happyFormsSettings );
