<?php

class HappyForms_Integration_MailerLite {

	private static $instance;
	private static $hooked = false;

	private $service;

	public $field_parts = array(
		'single_line_text',
		'multi_line_text',
		'email',
		'website_url',
		'radio',
		'checkbox',
		'select',
		'number',
		'poll',
		'phone',
		'date',
		'scale',
		'rich_text',
		'title',
		'legal',
		'rating'
	);

	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function __construct() {
		$this->service = happyforms_get_integrations()->get_service( 'mailerlite' );
	}

	public function hook() {
		if ( self::$hooked ) {
			return;
		}

		self::$hooked = true;

		foreach ( $this->field_parts as $part_slug ) {
			add_filter( "happyforms_part_customize_fields_{$part_slug}", array( $this, 'add_part_fields' ) );
			add_action( "happyforms_part_customize_{$part_slug}_before_advanced_options", array( $this, "add_part_controls" ) );
		}

		add_filter( 'happyforms_meta_fields', array( $this, 'meta_fields' ) );
		add_filter( 'happyforms_email_controls', array( $this, 'setup_controls' ) );
		add_filter( 'happyforms_conditional_enabled_setup_controls', array( $this, 'add_logic_to_controls' ) );

		add_action( 'happyforms_customize_enqueue_scripts', array( $this, 'customize_enqueue_scripts' ) );
		add_action( 'happyforms_submission_success', array( $this, 'handle_submit' ), 10, 3 );
	}

	public function meta_fields( $fields ) {
		$fields["enable_{$this->service->id}"] = array(
			'default' => 0,
			'sanitize' => 'happyforms_sanitize_checkbox'
		);

		$fields["{$this->service->id}_group"] = array(
			'default' => 0,
			'sanitize' => 'sanitize_text_field'
		);

		return $fields;
	}

	public function setup_controls( $controls ) {
		$controls[150] = array(
			'type' => 'checkbox',
			'field' => "enable_{$this->service->id}",
			'label' => __( 'Use MailerLite', 'happyforms' ),
			'tooltip' => __( 'Send mapped fields to MailerLite.', 'happyforms' )
		);

		$controls[151] = array(
			'type' => 'group_start',
			'trigger' => "enable_{$this->service->id}",
		);

		$groups = $this->service->get_groups();
		$groups_options = array();

		foreach ( $groups as $group ) {
			$groups_options[$group['id']] = $group['name'];
		}

		$controls[152] = array(
			'type' => 'select',
			'field' => "{$this->service->id}_group",
			'placeholder' => __( '— Select —', 'happyforms' ),
			'label' => __( 'Group to add user\'s email to', 'happyforms' ),
			'options' => $groups_options,
			'allow_empty' => true,
		);

		$controls[153] = array(
			'type' => 'group_end'
		);

		return $controls;
	}

	public function add_logic_to_controls( $controls ) {
		$groups = array();
		$groups = $this->service->get_groups();
		$groups_options = array();

		if ( empty( $groups ) ) {
			return $controls;
		}

		foreach ( $groups as $group ) {
			$groups_options[$group['id']] = $group['name'];
		}

		$controls["{$this->service->id}_group"] = array(
			'type' => 'select',
			'options' => $groups_options,
			'then_text' => __( 'Then add to…', 'happyforms' )
		);

		return $controls;
	}

	public function add_part_fields( $fields ) {
		$fields["{$this->service->id}_field"] = array(
			'default'  => '',
			'sanitize' => 'sanitize_text_field'
		);

		return $fields;
	}

	public function add_part_controls() {
		?>
		<% if ( 1 == happyForms.form.get( 'enable_mailerlite' ) ) { %>
		<p>
			<label for="<%= instance.id %>_mailerlite_field"><?php _e( 'Map field to MailerLite field', 'happyforms' ); ?></label>
			<select class="widefat happyforms-client-updated" data-bind="mailerlite_field" data-var="_happyFormsMailerLiteData" data-var-prop="fields">
				<option value="" selected>– <?php _e( 'Select', 'happyforms' ); ?> –</option>
			</select>
		</p>
		<% } %>
		<?php
	}

	public function handle_submit( $submission, $form, $message ) {
		$form_controller        = happyforms_get_form_controller();
		$email_integration_part = $form_controller->get_first_part_by_type( $form, 'email_integration' );

		if ( $email_integration_part && 'yes' !== $submission[$email_integration_part['id']] ) {
			return;
		}

		$form_controller = happyforms_get_form_controller();
		$form            = happyforms_get_conditional_controller()->get( $form, $_REQUEST );
		$group_id        = happyforms_get_form_property( $form, 'mailerlite_group' );

		$fields = array();

		foreach ( $form['parts'] as $part ) {
			if ( empty( $part['mailerlite_field'] ) ) {
				continue;
			}

			$fields[$part['mailerlite_field']] = $submission[$part['id']];
		}

		$data = array(
			'group_id' => $group_id,
			'fields'   => $fields,
		);

		$this->service->add_subscriber( $data );
	}

	public function customize_enqueue_scripts() {
		$fields = $this->service->get_fields();

		$data = array(
			'fields' => $fields,
		);

		wp_localize_script(
			'happyforms-customize',
			'_happyFormsMailerLiteData',
			$data
		);
	}

}

if ( ! function_exists( 'happyforms_get_integration_mailerlite' ) ):

function happyforms_get_integration_mailerlite() {
	$instance = HappyForms_Integration_MailerLite::instance();
	$instance->hook();

	return $instance;
}

endif;

happyforms_get_integration_mailerlite();
