<?php
class HappyForms_Integration_Mailchimp {

	private static $instance;

	public $service = '';

	public $field_parts = array(
		'single_line_text',
		'multi_line_text',
		'email',
		'website_url',
		'radio',
		'checkbox',
		'select',
		'number',
		'poll',
		'phone',
		'date',
		'scale',
		'rich_text',
		'title',
		'legal',
		'rating'
	);

	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		self::$instance->hook();

		return self::$instance;
	}

	public function hook() {
		$this->service = happyforms_get_integrations()->get_service( 'mailchimp' );

		add_filter( 'happyforms_meta_fields', array( $this, 'meta_fields' ) );

		if ( isset( $_GET['happyforms'] ) && isset( $_GET['form_id'] ) ) {
			add_filter( 'happyforms_email_controls', array( $this, 'email_controls' ) );
			add_filter( 'happyforms_conditional_enabled_setup_controls', array( $this, 'add_logic_to_controls' ) );
		}

		foreach ( $this->field_parts as $part_slug ) {
			add_filter( "happyforms_part_customize_fields_{$part_slug}", array( $this, 'add_part_fields' ) );
			add_action( "happyforms_part_customize_{$part_slug}_before_advanced_options", array( $this, 'add_part_controls' ) );
		}

		add_action( 'happyforms_customize_enqueue_scripts', array( $this, 'customize_enqueue_scripts' ) );
		add_action( 'happyforms_submission_success', array( $this, 'handle_submit' ), 10, 3 );
		add_action( 'happyforms_do_email_control', array( $this, 'add_mailchimp_groups_control' ), 10, 3 );
		add_action( 'customize_controls_print_footer_scripts', array( $this, 'add_mailchimp_groups_js_control' ) );
	}

	public function handle_submit( $submission, $form, $message ) {
		$form_controller = happyforms_get_form_controller();
		$email_integration_part = $form_controller->get_first_part_by_type( $form, 'email_integration' );

		if ( $email_integration_part && 'yes' !== $submission[$email_integration_part['id']] ) {
			return;
		}

		$form_controller = happyforms_get_form_controller();
		$form = happyforms_get_conditional_controller()->get( $form, $_REQUEST );
		$list_id = happyforms_get_form_property( $form, 'mailchimp_list' );

		if ( empty( $list_id ) ) {
			return;
		}

		$email = '';
		$tags = array();
		$groups = array();
		$merge_fields = array();

		$status = ( 1 == happyforms_get_form_property( $form, 'mailchimp_double_opt_in' ) ) ? 'pending' : 'subscribed';

		// Fields
		foreach ( $form['parts'] as $part ) {
			if ( empty( $part['mailchimp_field'] ) ) {
				continue;
			}

			$field_tag = $part['mailchimp_field'];
			$field_parent = '';

			if ( strpos( $field_tag, '::' ) ) {
				$field_full = explode( '::', $field_tag );
				$field_parent = $field_full[0];
				$field_tag = $field_full[1];
			}

			switch( $field_tag ) {
				case 'EMAIL':
					$email = $submission[$part['id']];
					break;
				case 'addr1':
				case 'city':
				case 'zip':
				case 'state':
					if ( ! empty( $field_parent ) ) {
						$merge_fields[$field_parent][$field_tag] = $submission[$part['id']];
					} else {
						$merge_fields[$field_tag] = $submission[$part['id']];
					}
					break;
				default:
					$merge_fields[$field_tag] = $submission[$part['id']];
					break;
			}
		}

		if ( empty( $email ) ) {
			return;
		}

		$subscriber_data = array(
			'email_address' => $email,
			'status' => $status
		);

		if ( ! empty( $merge_fields ) ) {
			$subscriber_data['merge_fields'] = $merge_fields;
		}

		// Tags
		$added_tags = happyforms_get_form_property( $form, 'mailchimp_tags' );

		if ( ! empty( $added_tags ) ) {
			$added_tags = explode( ',', $added_tags );

			foreach( $added_tags as $tag ) {
				$tag = trim( $tag );

				$tags[] = array(
					'name' => $tag,
					'status' => 'active'
				);
			}
		}

		// Groups
		$groups = happyforms_get_form_property( $form, 'mailchimp_groups' );

		if ( ! empty( $groups ) ) {
			$subscriber_data['interests'] = array();

			if ( is_array( $groups ) ) {
				foreach( $groups as $group_id ) {
					$subscriber_data['interests'][$group_id] = true;
				}
			} else {
				$subscriber_data['interests'][$groups] = true;
			}
		}

		$request = $this->service->add_subscriber( $list_id, $subscriber_data, $tags );
	}

	public function add_part_fields( $fields ) {
		$fields['mailchimp_field'] = array(
			'default' => '',
			'sanitize' => 'sanitize_text_field'
		);

		return $fields;
	}

	public function add_part_controls() {
		require( happyforms_get_integrations_folder() . '/services/mailchimp/templates/partial-part-controls.php' );
	}

	public function meta_fields( $fields ) {
		$fields['enable_mailchimp'] = array(
			'default' => 0,
			'sanitize' => 'happyforms_sanitize_checkbox'
		);

		$fields['mailchimp_list'] = array(
			'default' => '',
			'sanitize' => 'sanitize_text_field'
		);

		$fields['mailchimp_groups'] = array(
			'default' => array(),
			'sanitize' => 'sanitize_groups'
		);

		$fields['mailchimp_tags'] = array(
			'default' => '',
			'sanitize' => 'sanitize_text_field'
		);

		$fields['mailchimp_double_opt_in'] = array(
			'default' => 0,
			'sanitize' => 'happyforms_sanitize_checkbox'
		);

		return $fields;
	}

	public function sanitize_groups( $groups ) {
		return $groups;
	}

	public function email_controls( $controls ) {
		$controls[150] = array(
			'type' => 'checkbox',
			'field' => 'enable_mailchimp',
			'label' => __( 'Use Mailchimp', 'happyforms' ),
			'tooltip' => __( 'Send mapped fields to Mailchimp.', 'happyforms' )
		);

		$controls[151] = array(
			'type' => 'group_start',
			'trigger' => 'enable_mailchimp'
		);

		$controls[152] = array(
			'type' => 'checkbox',
			'field' => 'mailchimp_double_opt_in',
			'label' => __( 'Send email to confirm subscription', 'happyforms' )
		);

		$lists = $this->service->get_lists();
		$lists_options = array();

		foreach ( $lists as $list ) {
			$lists_options[$list->id] = $list->name;
		}

		$controls[153] = array(
			'type' => 'select',
			'field' => 'mailchimp_list',
			'placeholder' => __( '— Select —', 'happyforms' ),
			'label' => __( 'List to add user\'s email to', 'happyforms' ),
			'options' => $lists_options
		);

		$controls[154] = array(
			'type' => 'mailchimp_groups',
			'field' => 'mailchimp_groups',
			'include_js_template' => true,
			'label' => __( 'Assign responses to these group(s)', 'happyforms' ),
			'no_options' => __( 'No groups available for the selected list.', 'happyforms' )
		);

		$controls[155] = array(
			'type' => 'text',
			'field' => 'mailchimp_tags',
			'label' => __( 'Add these tags to submissions', 'happyforms' ),
			'placeholder' => __( 'e.g. Influencer, Prospect, Uses coupons', 'happyforms' )
		);

		$controls[156] = array(
			'type' => 'group_end'
		);

		return $controls;
	}

	public function add_logic_to_controls( $controls ) {
		$lists = array();
		$lists = $this->service->get_lists();
		$lists_options = array();

		foreach ( $lists as $list ) {
			$lists_options[$list->id] = $list->name;
		}

		$controls['mailchimp_list'] = array(
			'type' => 'select',
			'options' => $lists_options,
			'then_text' => __( 'Then add to…', 'happyforms' )
		);

		$controls['mailchimp_groups'] = array(
			'type' => 'select',
			'then_text' => __( 'Then assign to group…', 'happyforms' )
		);

		$controls['mailchimp_tags'] = array(
			'type' => 'set',
			'then_text' => __( 'Then add tags…', 'happyforms' )
		);

		return $controls;
	}

	public function add_mailchimp_groups_control( $control, $field, $index ) {
		if ( 'mailchimp_groups' === $control['type'] ) {
			require( happyforms_get_integrations_folder() . '/services/mailchimp/templates/customize-groups.php' );
		}
	}

	public function add_mailchimp_groups_js_control() {
		require_once( happyforms_get_integrations_folder() . '/services/mailchimp/templates/customize-groups-js.php' );
	}

	public function customize_enqueue_scripts( $deps ) {
		wp_enqueue_script(
			'happyforms-mailchimp',
			happyforms_get_plugin_url() . 'integrations/services/mailchimp/assets/js/customize-mailchimp.js',
			array( 'happyforms-conditionals' ), HAPPYFORMS_UPGRADE_VERSION, true
		);

		$lists = $this->service->get_lists();

		$groups_array = array();
		$fields_array = array();

		foreach ( $lists as $list ) {
			$groups = $this->service->get_groups( $list->id );
			$groups_array[$list->id] = array();

			foreach ( $groups as $group ) {
				$groups_array[$list->id][] = $group;
			}

			$fields = $this->service->get_merge_fields( $list->id );
			$fields_array[$list->id] = $fields;
		}

		$mailchimp_data = array(
			'groups' => $groups_array,
			'fields' => $fields_array
		);

		wp_localize_script(
			'happyforms-mailchimp',
			'_happyFormsMailchimpData',
			$mailchimp_data
		);
	}

}

if ( ! function_exists( 'happyforms_get_mailchimp_integration' ) ):

function happyforms_get_mailchimp_integration() {
	return HappyForms_Integration_Mailchimp::instance();
}

endif;

happyforms_get_mailchimp_integration();
