<?php

$integrations = happyforms_get_integrations();
$service = $integrations->get_service( 'google-analytics' );
$credentials = $service->get_credentials();
$enabled = $service->is_enabled();
?>
<div id="happyforms-service-<?php echo $service->id; ?>" class="happyforms-service-integration<?php echo ( $enabled ) ? ' enabled' : ''; ?>">
	<p>
		<label>
			<input type="checkbox" class="happyforms-service-toggle" name="credentials[google-analytics][enabled]" value="1" <?php checked( $enabled, true ); ?>> <?php _e( 'Google Analytics', 'happyforms' ); ?>
		</label>
	</p>

	<div class="nested-block">
		<div class="widget-content <?php if ( $service->is_connected() ) : ?>authenticated<?php endif; ?>">
			<input type="hidden" name="services[]" value="<?php echo $service->id; ?>">
			<p>
				<label for="happyforms_integrations_google-analytics_tracking_id"><?php _e( 'Tracking ID:', 'happyforms' ); ?></label>
				<div class="hf-pwd">
					<input type="password" class="widefat connected" id="happyforms_integrations_google-analytics_tracking_id" name="credentials[google-analytics][tracking_id]" value="<?php echo $credentials['tracking_id']; ?>" />
					<button type="button" class="button button-secondary hf-hide-pw hide-if-no-js" data-toggle="0" aria-label="<?php _e( 'Show credentials', 'happyforms' ); ?>" data-label-show="<?php _e( 'Show credentials', 'happyforms' ); ?>" data-label-hide="<?php _e( 'Hide credentials', 'happyforms' ); ?>">
						<span class="dashicons dashicons-visibility" aria-hidden="true"></span>
					</button>
				</div>
			</p>
		</div>
	</div>
</div>
