<?php
class HappyForms_Integrations_Page_Controller {

	private $sections;

	private static $instance;

	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		self::$instance->hook();

		return self::$instance;
	}

	public function hook() {
		add_action( 'init', array( $this, 'set_settings' ) );

		add_filter( 'happyforms_integrations_page_method', array( $this, 'set_admin_page_method' ) );
		add_filter( 'happyforms_integrations_page_url', array( $this, 'set_admin_page_url' ) );
	}

	public function set_settings() {
		$sections = array(
			1 => array(
				'id' => 'antispam',
				'title' => __( 'Anti-Spam Integrations', 'happyforms' ),
				'description' => __( 'Connect forms with an anti-spam service.', 'happyforms' ),
				'template' => happyforms_get_integrations_folder() . '/templates/admin-antispam-integrations.php',
				'default_state' => 'open',
				'extra_classes' => array( 'happyforms-integrations-section' ),
				'column' => 1,
			),
			2 => array(
				'id' => 'payment',
				'title' => __( 'Payment Integrations', 'happyforms' ),
				'description' => __( 'Connect forms with payment services.', 'happyforms' ),
				'template' => happyforms_get_integrations_folder() . '/templates/admin-payment-integrations.php',
				'default_state' => 'open',
				'extra_classes' => array( 'happyforms-integrations-section' ),
				'column' => 1,
			),
			3 => array(
				'id' => 'email',
				'title' => __( 'Email Integrations', 'happyforms' ),
				'description' => __( 'Connect forms with an email service.', 'happyforms' ),
				'template' => happyforms_get_integrations_folder() . '/templates/admin-email-integrations.php',
				'default_state' => 'open',
				'extra_classes' => array( 'happyforms-integrations-section' ),
				'column' => 2,
			),
			4 => array(
				'id' => 'analytics',
				'title' => __( 'Analytics Integrations', 'happyforms' ),
				'description' => __( 'Connect forms with analytics services.', 'happyforms' ),
				'template' => happyforms_get_integrations_folder() . '/templates/admin-analytics-integrations.php',
				'default_state' => 'open',
				'extra_classes' => array( 'happyforms-integrations-section' ),
				'column' => 2,
			),
			5 => array(
				'id' => 'automation',
				'title' => __( 'Automation Integrations', 'happyforms' ),
				'description' => __( 'Connect forms with automation services.', 'happyforms' ),
				'template' => happyforms_get_integrations_folder() . '/templates/admin-automation-integrations.php',
				'default_state' => 'open',
				'extra_classes' => array( 'happyforms-integrations-section' ),
				'column' => 2,
			),
		);

		$sections = apply_filters( 'happyforms_get_integrations_sections', $sections );
		ksort( $sections );

		$sections = array_filter( $sections, function( $section ) {
			if ( ! isset( $section['capability'] ) ) {
				return true;
			}

			return current_user_can( $section['capability'] );
		} );

		$this->sections = $sections;
	}

	public function get_sections( $column = null ) {
		if ( is_null( $column ) ) {
			return $this->sections;
		}

		$column_settings = array_filter( $this->sections, function( $section ) use ( $column ) {
			return $column === $section['column'];
		} );

		return $column_settings;
	}

	public function set_admin_page_method() {
		return array( $this, 'integrations_page' );
	}

	public function set_admin_page_url() {
		return 'happyforms-integrations';
	}

	public function integrations_page() {
		add_filter( 'admin_footer_text', 'happyforms_admin_footer' );

		require_once( happyforms_get_integrations_folder() . '/templates/admin-integrations.php' );
	}

}

if ( ! function_exists( 'happyforms_get_integrations_page_controller' ) ):

function happyforms_get_integrations_page_controller() {
	return HappyForms_Integrations_Page_Controller::instance();
}

endif;

happyforms_get_integrations_page_controller();
