<div class="<?php happyforms_the_part_class( $part, $form ); ?>" id="<?php happyforms_the_part_id( $part, $form ); ?>-part" <?php happyforms_the_part_data_attributes( $part, $form ); ?>>
	<div class="happyforms-part-wrap">
		<?php happyforms_the_part_label( $part, $form ); ?>

		<?php do_action( 'happyforms_part_input_before', $part, $form ); ?>

		<div class="happyforms-part__el">
			<?php
			$options = happyforms_get_part_options( $part['options'], $part, $form );
			$value = happyforms_get_part_value( $part, $form );

			foreach( $options as $o => $option ) :
				$temp_value = array();
				$rank_value = '';
				$clear_button_class = 'hide-clear-button';

				if( ! empty( $value ) ) {
					$temp_value = $value;
					unset( $temp_value[$option['id']] );

					if( $value[$option['id']] != 0 ) {
						$rank_value = $value[$option['id']];
						$clear_button_class = '';
					}
				}

				$rank_option_html = happyforms_rank_get_options( count( $options ), $temp_value );
			?>
			<div class="happyforms-part__option happyforms-part-option" id="<?php echo esc_attr( $option['id'] ); ?>">
				<div class="happyforms-custom-select" data-searchable="true">
					<div class="happyforms-part__select-wrap">
						<input type="hidden" name="<?php happyforms_the_part_name( $part, $form ); ?>[<?php echo $option['id']; ?>]" value="<?php echo $rank_value;?>" data-serialize="">

						<input id="happyforms-<?php echo $option['id']; ?>" type="text" value="<?php echo $rank_value; ?>" placeholder="<?php echo __( 'Choose', 'happyforms' ); ?>" data-searchable="false" autocomplete="off" readonly="readonly" data-prev-value="<?php echo $rank_value;?>" class="data-holder">
						<ul class="happyforms-custom-select-dropdown">
							<?php echo $rank_option_html; ?>
							<li class="happyforms-dropdown-item happyforms-custom-select-dropdown__item happyforms-rank-clear-button <?php echo $clear_button_class; ?>" data-value=""><?php echo __( 'Clear', 'happyforms' ); ?></li>
						</ul>
					</div>
				</div>
				<label class="option-label">
					<span class="label"><?php echo esc_attr( $option['label'] ); ?></span>
				</label>
			</div>
			<?php endforeach; ?>

			<?php do_action( 'happyforms_part_input_after', $part, $form ); ?>

			<?php if ( 'tooltip' !== $part['description_mode'] ) : ?>
				<?php happyforms_print_part_description( $part ); ?>
			<?php endif; ?>

			<?php happyforms_part_error_message( happyforms_get_part_name( $part, $form ) ); ?>
		</div>
	</div>
</div>