<script type="text/template" id="customize-happyforms-poll-template">
	<?php include( happyforms_get_core_folder() . '/templates/customize-form-part-header.php' ); ?>
	<p>
		<label for="<%= instance.id %>_title"><?php _e( 'Label', 'happyforms' ); ?></label>
		<input type="text" id="<%= instance.id %>_title" class="widefat title" value="<%= instance.label %>" data-bind="label" />
	</p>
	<p>
		<label for="<%= instance.id %>_description"><?php _e( 'Description', 'happyforms' ); ?></label>
		<textarea id="<%= instance.id %>_description" data-bind="description"><%= instance.description %></textarea>
	</p>

	<?php do_action( 'happyforms_part_customize_poll_before_options' ); ?>

	<div class="options">
		<ul class="option-list"></ul>
		<h3><?php _e( 'Choices', 'happyforms' ); ?></h3>
		<p class="no-options description"><?php _e( 'No choices added yet. Add one by clicking <i>Add choice</i> below.', 'happyforms' ); ?></p>
	</div>
	<div class="options-import">
		<h3><?php _e( 'Choices', 'happyforms' ); ?></h3>
		<textarea class="option-import-area" cols="30" rows="10" placeholder="<?php _e( 'Type or paste your choices here, adding each on a new line.' ); ?>"></textarea>
	</div>
	<p class="links mode-manual">
		<a href="#" class="button add-option"><?php _e( 'Add choice', 'happyforms' ); ?></a>
		<span class="centered">
			<a href="#" class="import-options"><?php _e( 'Or, bulk add choices', 'happyforms' ); ?></a>
		</span>
	</p>
	<p class="links mode-import">
		<a href="#" class="button import-option"><?php _e( 'Add choices', 'happyforms' ); ?></a>
		<span class="centered">
			<a href="#" class="add-options"><?php _e( 'Cancel', 'happyforms' ); ?></a>
		</span>
	</p>
	<p>
		<label>
			<input type="checkbox" class="checkbox" value="1" <% if ( instance.required ) { %>checked="checked"<% } %> data-bind="required" /> <?php _e( 'This is required', 'happyforms' ); ?>
		</label>
	</p>

	<?php do_action( 'happyforms_part_customize_poll_after_options' ); ?>

	<div class="happyforms-part-advanced-settings-wrap">
		<?php do_action( 'happyforms_part_customize_poll_before_advanced_options' ); ?>

		<p>
			<label>
				<input type="checkbox" class="checkbox" value="1" <% if ( instance.other_option ) { %>checked="checked"<% } %> data-bind="other_option" /> <?php _e( 'Add \'other\' choice', 'happyforms' ); ?>
			</label>
		</p>
		<div class="happyforms-nested-settings" data-trigger="other_option" style="display: <%= ( instance.other_option ) ? 'block' : 'none' %>">
			<p>
				<label for="<%= instance.id %>_other_option_label"><?php _e( '\'Other\' label', 'happyforms' ); ?></label>
				<input type="text" id="<%= instance.id %>_other_option_label" maxlength="30" class="widefat title" value="<%= instance.other_option_label %>" data-bind="other_option_label" />
			</p>
			<p>
				<label for="<%= instance.id %>_other_option_placeholder"><?php _e( '\'Other\' placeholder', 'happyforms' ); ?></label>
				<input type="text" id="<%= instance.id %>_other_option_placeholder" maxlength="50" class="widefat title" value="<%= instance.other_option_placeholder %>" data-bind="other_option_placeholder" />
			</p>
		</div>
		<p>
			<label>
				<input type="checkbox" class="checkbox" value="1" <% if ( instance.allow_multiple ) { %>checked="checked"<% } %> data-bind="allow_multiple" /> <?php _e( 'Allow multiple choices', 'happyforms' ); ?>
			</label>
		</p>
		<p>
			<label>
				<input type="checkbox" class="checkbox" value="1" <% if ( instance.shuffle_options ) { %>checked="checked"<% } %> data-bind="shuffle_options" /> <?php _e( 'Randomize order of choices', 'happyforms' ); ?>
			</label>
		</p>
		<p class="happyforms-poll-limit-choices-wrap" style="display: <%= ( instance.allow_multiple ) ? 'block' : 'none' %>">
			<label>
				<input type="checkbox" class="checkbox" value="1" <% if ( instance.limit_choices ) { %>checked="checked"<% } %> data-bind="limit_choices" /> <?php _e( 'Limit choices', 'happyforms' ); ?>
			</label>
		</p>
		<div class="happyforms-nested-settings" data-trigger="limit_choices" style="display: <%= ( instance.limit_choices ) ? 'block' : 'none' %>">
			<p>
				<label for="<%= instance.id %>_limit_choices_min"><?php _e( 'Min choices', 'happyforms' ); ?></label>
				<input type="number" id="<%= instance.id %>_limit_choices_min" class="widefat title" min="1" value="<%= instance.limit_choices_min %>" data-bind="limit_choices_min" />
			</p>
			<p>
				<label for="<%= instance.id %>_limit_choices_max"><?php _e( 'Max choices', 'happyforms' ); ?></label>
				<input type="number" id="<%= instance.id %>_limit_choices_max" class="widefat title" min="1" value="<%= instance.limit_choices_max %>" data-bind="limit_choices_max" />
			</p>
		</div>
		<p>
			<label>
				<input type="checkbox" class="checkbox" value="1" <% if ( instance.show_results_before_voting ) { %>checked="checked"<% } %> data-bind="show_results_before_voting" /> <?php _e( 'Allow previewing results', 'happyforms' ); ?>
			</label>
		</p>
		<div class="happyforms-nested-settings" data-trigger="show_results_before_voting" style="display: <%= ( 1 == instance.show_results_before_voting) ? 'block' : 'none' %>">
			<p>
				<label for="<%= instance.id %>_show_results_label"><?php _e( '\'Show results\' label', 'happyforms' ); ?></label>
				<input type="text" id="<%= instance.id %>_show_results_label" class="widefat title" value="<%= instance.show_results_label %>" data-bind="show_results_label" maxlength="30" />
			</p>
			<p>
				<label for="<%= instance.id %>_back_to_poll_label"><?php _e( '\'Back to poll\' label', 'happyforms' ); ?></label>
				<input type="text" id="<%= instance.id %>_back_to_poll_label" class="widefat title" value="<%= instance.back_to_poll_label %>" data-bind="back_to_poll_label" maxlength="30" />
			</p>
		</div>

		<?php happyforms_customize_part_width_control(); ?>

		<?php do_action( 'happyforms_part_customize_poll_after_advanced_options' ); ?>

		<p>
			<label for="<%= instance.id %>_css_class"><?php _e( 'CSS classes', 'happyforms' ); ?></label>
			<input type="text" id="<%= instance.id %>_css_class" class="widefat title" value="<%= instance.css_class %>" data-bind="css_class" />
		</p>
	</div>

	<div class="happyforms-part-logic-wrap">
		<div class="happyforms-logic-view">
			<?php happyforms_customize_part_logic(); ?>
		</div>
	</div>

	<?php happyforms_customize_part_footer(); ?>
</script>
<script type="text/template" id="customize-happyforms-poll-item-template">
	<li data-option-id="<%= id %>">
		<div class="happyforms-part-item-body">
			<div class="happyforms-part-item-handle"></div>
			<label>
				<?php _e( 'Label', 'happyforms' ); ?>:
				<input type="text" class="widefat" name="label" value="<%= label %>" data-option-attribute="label">
			</label>
			<div class="option-actions">
				<a href="#" class="delete-option"><?php _e( 'Delete', 'happyforms' ); ?></a>
			</div>
		</div>
	</li>
</script>
