<?php
$privacy_settings = happyforms_get_privacy_settings();
$action = $privacy_settings->save_action;
$nonce = $privacy_settings->save_nonce;
$settings = $privacy_settings->read();
?>

<div>
	<div class="happyforms-settings-notices"></div>

	<form class="hf-ajax-submit">
		<?php wp_nonce_field( $action, $nonce ); ?>
		<input type="hidden" name="action" value="<?php echo $action; ?>">
		<p><?php _e( 'Handle user\'s data protection and privacy rights.', 'happyforms' ); ?></p>
		<div class="controls">
			<div class="control">
				<div class="control__line">
					<input type="checkbox" name="privacy[save_submissions]" value="1" id="privacy_save_submissions" <?php checked( $settings['save_submissions'], 1 ); ?>>
					<label for="privacy_save_submissions"><?php _e( 'Store activity in database', 'happyforms' ); ?></label>
				</div>
			</div>
			<div class="control">
				<div class="control__line">
					<input type="checkbox" name="privacy[preserve_database_data]" value="1" id="privacy_preserve_database_data" <?php checked( $settings['preserve_database_data'], 1 ); ?>>
					<label for="privacy_preserve_database_data"><?php _e( 'Keep data after deleting HappyForms', 'happyforms' ); ?></label>
				</div>
			</div>
			<div class="control">
				<div class="control__line">
					<input type="checkbox" name="privacy[save_user_data]" value="1" id="privacy_save_user_data" <?php checked( $settings['save_user_data'], 1 ); ?>>
					<label for="privacy_save_user_data"><?php _e( 'Capture user metadata (IP, language, platform, time and timezone)', 'happyforms' ); ?></label>
				</div>
			</div>
		</div>
		<div class="alignleft">
			<span class="spinner"></span>
			<input type="submit" class="button button-primary" value="<?php _e( 'Save Changes', 'happyforms' ); ?>">
		</div>
		<br class="clear">
	</form>
</div>
