<?php
class HappyForms_Settings_Page_Controller {

	private static $instance;

	private $sections;
	private $update_authorize_action =  'happyforms-updates-authorize';
	private $update_deauthorize_action =  'happyforms-updates-deauthorize';

	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		self::$instance->hook();

		return self::$instance;
	}

	public function hook() {
		add_action( 'init', array( $this, 'set_settings' ) );
		add_action( 'wp_ajax_' . $this->update_authorize_action, array( $this, 'updater_authorize' ) );
		add_action( 'wp_ajax_' . $this->update_deauthorize_action, array( $this, 'updater_deauthorize' ) );

		add_filter( 'happyforms_settings_page_method', array( $this, 'set_admin_page_method' ) );
		add_filter( 'happyforms_settings_page_url', array( $this, 'set_admin_page_url' ) );
		add_filter( 'ttf_product_central_settings_template', array( $this, 'set_updater_template' ) );
		add_filter( 'happyforms_settings_page_menu_badge', array( $this, 'handle_settings_page_menu_badge' ) );
	}

	public function set_settings() {
		$sections = array(
			10 => array(
				'id' => 'validation-messages',
				'title' => __( 'Validation Messages', 'happyforms' ),
				'description' => __( 'Revise the wording or language of messages displayed to users when submitting a form with errors.', 'happyforms' ),
				'template' => happyforms_get_include_folder() . '/templates/admin-settings-validation-messages.php',
				'default_state' => 'open',
				'column' => 1,
			),
			20 => array(
				'id' => 'export',
				'title' => __( 'Import and Export', 'happyforms' ),
				'description' => __( 'Transfer forms and submissions to and from sites.', 'happyforms' ),
				'template' => happyforms_get_include_folder() . '/templates/admin-settings-export.php',
				'default_state' => 'open',
				'column' => 1,
			),
			30 => array(
				'id' => 'register',
				'title' => __( 'Register', 'happyforms' ),
				'template' => happyforms_get_include_folder() . '/templates/admin-settings-register.php',
				'default_state' => 'open',
				'column' => 1,
				'capability' => 'manage_options',
			),
			35 => array(
				'id' => 'role_permissions',
				'title' => __( 'Role Capabilities', 'happyforms' ),
				'template' => happyforms_get_include_folder() . '/templates/admin-settings-role-permissions.php',
				'default_state' => 'open',
				'column' => 2,
				'capability' => 'manage_options',
			),
			36 => array(
				'id' => 'privacy',
				'title' => __( 'Privacy', 'happyforms' ),
				'template' => happyforms_get_include_folder() . '/templates/admin-settings-privacy.php',
				'default_state' => 'open',
				'column' => 2,
				'capability' => 'manage_options',
			),
			40 => array(
				'id' => 'blocklist',
				'title' => __( 'Submission Blocklist', 'happyforms' ),
				'template' => happyforms_get_include_folder() . '/templates/admin-settings-blocklist.php',
				'default_state' => 'open',
				'column' => 2,
			),
		);

		$sections = apply_filters( 'happyforms_get_settings_sections', $sections );
		ksort( $sections );

		$sections = array_filter( $sections, function( $section ) {
			if ( ! isset( $section['capability'] ) ) {
				return true;
			}

			return current_user_can( $section['capability'] );
		} );

		$this->sections = $sections;
	}

	public function get_sections( $column = null ) {
		if ( is_null( $column ) ) {
			return $this->sections;
		}

		$column_settings = array_filter( $this->sections, function( $section ) use ( $column ) {
			return $column === $section['column'];
		} );

		return $column_settings;
	}

	public function set_admin_page_method() {
		return array( $this, 'settings_page' );
	}

	public function set_admin_page_url() {
		return 'happyforms-settings';
	}

	public function settings_page() {
		add_filter( 'admin_footer_text', 'happyforms_admin_footer' );

		require_once( happyforms_get_include_folder() . '/templates/admin-settings.php' );
	}

	public function handle_settings_page_menu_badge() {
		$badge = '';

		$products = ttf_product_central_updater()->get_products();
		$data = happyforms_get_plugin_metadata();
		$product_id = $data['id'];
		$product = $products[$product_id];

		if ( current_user_can( 'manage_options' ) && ! $product->is_authorized() ) {
			$badge = ' <span class="awaiting-mod count-1"><span class="pending-count">1</span></span>';
		}

		return $badge;
	}

	public function set_updater_template( $template ) {
		$template = happyforms_get_include_folder() . '/templates/admin-settings-register-form.php';

		return $template;
	}

	public function updater_authorize() {
		ttf_product_central_settings()->authorize( 'ttf-updates-happyforms' );
		ttf_product_central_settings()->render_page( 'ttf-updates-happyforms' );
		exit;
	}

	public function updater_deauthorize() {
		ttf_product_central_settings()->deauthorize( 'ttf-updates-happyforms' );
		ttf_product_central_settings()->render_page( 'ttf-updates-happyforms' );
		exit;
	}

}

if ( ! function_exists( 'happyforms_get_settings_page_controller' ) ):

function happyforms_get_settings_page_controller() {
	return HappyForms_Settings_Page_Controller::instance();
}

endif;

happyforms_get_settings_page_controller();
