<?php

class HappyForms_Privacy_Settings {

	private static $instance;
	private static $hooked = false;

	public $save_action = 'happyforms_save_privacy_settings';
	public $save_nonce = 'happyforms-privacy-settings';
	public $option = 'happyforms_privacy_settings';

	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		self::$instance->hook();

		return self::$instance;
	}

	public function hook() {
		if ( self::$hooked ) {
			return;
		}

		self::$hooked = true;

		add_action( 'wp_ajax_' . $this->save_action, array( $this, 'save_settings' ) );
		add_filter( 'happyforms_save_entries', array( $this, 'save_entries' ) );
		add_filter( 'happyforms_save_user_data', array( $this, 'save_user_data' ) );
		add_filter( 'happyforms_logger_enabled', array( $this, 'saves_user_data' ) );
		add_filter( 'happyforms_cleanup_on_uninstall', array( $this, 'cleanup_on_uninstall' ) );
	}

	public function get_defaults() {
		$defaults = array(
			'save_submissions' => 1,
			'preserve_database_data' => 1,
			'save_user_data' => 1,
		);

		return $defaults;
	}

	public function read( $as_array = false ) {
		$settings = get_option( $this->option, '' );
		$settings = wp_parse_args( $settings, $this->get_defaults() );

		return $settings;
	}

	public function write( $settings ) {
		$defaults = $this->get_defaults();
		$settings = array_intersect_key( $settings, $defaults );

		foreach ( $defaults as $key => $value ) {
			$settings[$key] = isset( $settings[$key] ) ? $settings[$key] : 0;
		}

		update_option( $this->option, $settings );
	}

	public function save_settings() {
		if ( ! check_ajax_referer( $this->save_action, $this->save_nonce ) ) {
			return;
		}

		$settings = isset( $_REQUEST['privacy'] ) ? $_REQUEST['privacy'] : array();
		$this->write( $settings );

		ob_start();
		require_once( happyforms_get_include_folder() . '/templates/admin-settings-privacy.php' );
		$response = ob_get_clean();

		wp_send_json_success( array(
			'html' => $response,
			'message' => __( 'Changes saved.', 'happyforms' ),
		) );
	}

	public function saves_submissions() {
		$settings = $this->read();
		$saves_submissions = $settings['save_submissions'] ? true : false;

		return $saves_submissions;
	}

	public function saves_user_data() {
		$settings = $this->read();
		$saves_user_data = $settings['save_user_data'] ? true : false;

		return $saves_user_data;
	}

	public function preserves_database_data() {
		$settings = $this->read();
		$preserves_database_data = $settings['preserve_database_data'] ? true : false;

		return $preserves_database_data;
	}

	public function save_entries( $save ) {
		return $this->saves_submissions();
	}

	public function save_user_data( $save ) {
		if ( ! $save ) {
			return $save;
		}

		return $this->saves_user_data();
	}

	public function cleanup_on_uninstall() {
		return ! $this->preserves_database_data();
	}

}

if ( ! function_exists( 'happyforms_get_privacy_settings' ) ):

function happyforms_get_privacy_settings() {
	return HappyForms_Privacy_Settings::instance();
}

endif;

happyforms_get_privacy_settings();
