<?php

class HappyForms_Upgrade extends HappyForms_Core {

	public function initialize_plugin() {
		$this->load_translations();

		parent::initialize_plugin();

		add_filter( 'happyforms_show_welcome_page', '__return_false' );
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_styles_preview' ) );
		add_action( 'happyforms_customize_enqueue_scripts', array( $this, 'customize_enqueue_scripts' ) );
		add_filter( 'happyforms_frontend_stylesheets_url', array( $this, 'set_frontend_stylesheets_url' ) );
		add_filter( 'ttf_product_central_banners', array( $this, 'get_updater_banners' ) );
		add_filter( 'ttf_product_central_icons', array( $this, 'get_updater_icons' ) );

		// Helpers
		require_once( happyforms_get_include_folder() . '/helpers/helper-misc.php' );

		// Updates
		require_once( happyforms_get_updater_folder() . '/class-updater.php' );
		ttf_product_central_updater()->register( happyforms_get_plugin_metadata() );

		// Form extensions
		require_once( happyforms_get_include_folder() . '/classes/class-form-setup-upgrade.php' );

		$part_library = happyforms_get_part_library();

		// Website url part
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-website-url.php' );
		$part_library->register_part( 'HappyForms_Part_WebsiteUrl', 3 );

		// Attachment part
		require_once( happyforms_get_include_folder() . '/helpers/helper-upload.php' );
		require_once( happyforms_get_include_folder() . '/helpers/helper-form-templates.php' );
		require_once( happyforms_get_include_folder() . '/classes/class-attachment-controller.php' );
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-attachment.php' );
		$part_library->register_part( 'HappyForms_Part_Attachment', 6 );

		// Table part
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-table.php' );
		$part_library->register_part( 'HappyForms_Part_Table', 7 );

		// Select part
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-select-extended.php' );
		$part_library->deregister_part( 'HappyForms_Part_Select' );
		$part_library->register_part( 'HappyForms_Part_SelectExtended', 8 );

		// Phone part
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-phone.php' );
		$part_library->register_part( 'HappyForms_Part_Phone', 11 );

		// Date part
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-date.php' );
		$part_library->register_part( 'HappyForms_Part_Date', 12 );

		// Address part
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-address.php' );
		$part_library->register_part( 'HappyForms_Part_Address', 14 );

		// Scale part
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-scale.php' );
		$part_library->register_part( 'HappyForms_Part_Scale', 15 );
		
		// Rank order part
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-rank-order.php' );
		$part_library->register_part( 'HappyForms_Part_Rank_Order', 16 );

		// Likert scale part
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-likert-scale.php' );
		$part_library->register_part( 'HappyForms_Part_Likert_Scale', 17 );

		// Rich text part
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-rich-text.php' );
		$part_library->register_part( 'HappyForms_Part_RichText', 18 );

		// Title part
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-title.php' );
		$part_library->register_part( 'HappyForms_Part_Title', 19 );

		// Legal part
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-legal.php' );
		$part_library->register_part( 'HappyForms_Part_Legal', 20 );

		// Rating part
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-rating.php' );
		$part_library->register_part( 'HappyForms_Part_Rating', 21 );

		// Narrative part
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-narrative.php' );
		$part_library->register_part( 'HappyForms_Part_Narrative', 22 );

		// Layout group part
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-layout-drawer-group.php' );
		$part_library->register_part( 'HappyForms_Part_LayoutDrawerGroup', 30 );

		// Title part
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-layout-title.php' );
		$part_library->register_part( 'HappyForms_Part_LayoutTitle', 31 );

		// Placeholder part
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-placeholder.php' );
		$part_library->register_part( 'HappyForms_Part_Placeholder', 32 );

		// Media part
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-media.php' );
		$part_library->register_part( 'HappyForms_Part_Media', 33 );

		// Divider part
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-divider.php' );
		$part_library->register_part( 'HappyForms_Part_Divider', 34 );

		// Modals
		require_once( happyforms_get_include_folder() . '/helpers/helper-modal.php' );
		require_once( happyforms_get_include_folder() . '/classes/class-form-modals.php' );

		// Restrict entries
		require_once( happyforms_get_include_folder() . '/classes/class-form-restrict.php' );

		// Form scheduling
		require_once( happyforms_get_include_folder() . '/classes/class-form-schedule.php' );

		// Password protection
		require_once( happyforms_get_include_folder() . '/classes/class-form-password-protection.php' );

		// Shuffle
		require_once( happyforms_get_include_folder() . '/classes/class-form-shuffle.php' );

		// Turn off styles
		require_once( happyforms_get_include_folder() . '/classes/class-form-mute-styles.php' );

		// Client info
		require_once( happyforms_get_include_folder() . '/classes/class-client-info.php' );

		// Submission sessions
		require_once( happyforms_get_include_folder() . '/classes/class-form-sessions.php' );
		require_once( happyforms_get_include_folder() . '/classes/class-session-controller.php' );

		// Form archive
		require_once( happyforms_get_include_folder() . '/classes/class-form-status.php' );

		// Multi step
		require_once( happyforms_get_include_folder() . '/classes/class-form-stepper.php' );
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-page-break.php' );
		$part_library->register_part( 'HappyForms_Part_PageBreak', 35 );

		// Optional choice parts
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-radio-extended.php' );
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-checkbox-extended.php' );
		$part_library->deregister_part( 'HappyForms_Part_Radio' );
		$part_library->register_part( 'HappyForms_Part_RadioExtended', 5 );
		$part_library->deregister_part( 'HappyForms_Part_Checkbox' );
		$part_library->register_part( 'HappyForms_Part_CheckboxExtended', 5 );

		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-multi-line-text-extended.php' );
		$part_library->deregister_part( 'HappyForms_Part_MultiLineText' );
		$part_library->register_part( 'HappyForms_Part_MultiLineTextExtended', 1 );

		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-signature.php' );
		$part_library->register_part( 'HappyForms_Part_Signature', 18 );

		if ( is_admin() ) {
			require_once( happyforms_get_include_folder() . '/classes/class-export-controller.php' );
			require_once( happyforms_get_include_folder() . '/classes/class-admin-pages-controller.php' );
			require_once( happyforms_get_include_folder() . '/classes/class-settings-page-controller.php' );
		}

		// Polls
		require_once( happyforms_get_include_folder() . '/classes/class-polls-controller.php' );
		require_once( happyforms_get_include_folder() . '/classes/parts/class-part-poll.php' );
		$part_library->register_part( 'HappyForms_Part_Poll', 10 );

		// PDFs
		require_once( happyforms_get_include_folder() . '/classes/class-pdf-controller.php' );
		require_once( happyforms_get_include_folder() . '/classes/class-pdf.php' );

		// Tasks
		require_once( happyforms_get_include_folder() . '/classes/tasks/class-task.php' );
		require_once( happyforms_get_include_folder() . '/classes/tasks/class-task-email-owner.php' );
		require_once( happyforms_get_include_folder() . '/classes/tasks/class-task-email-user.php' );
		require_once( happyforms_get_include_folder() . '/classes/tasks/class-task-email-abandonment.php' );
		require_once( happyforms_get_include_folder() . '/classes/class-task-controller.php' );

		// Integrations
		require_once( happyforms_get_integrations_folder() . '/classes/class-integrations.php' );

		// Conditional logic
		require_once( happyforms_get_include_folder() . '/classes/class-condition.php' );
		require_once( happyforms_get_include_folder() . '/classes/class-conditional-controller.php' );
		require_once( happyforms_get_include_folder() . '/classes/class-conditionals-ui-controller.php' );

		// Validation messages management
		require_once( happyforms_get_include_folder() . '/classes/class-validation-messages-upgrade.php' );

		// Option limiting
		require_once( happyforms_get_include_folder() . '/classes/class-form-option-limiter.php' );

		// Message blocklist
		require_once( happyforms_get_include_folder() . '/classes/class-message-blocklist.php' );

		// Role permissions
		require_once( happyforms_get_include_folder() . '/classes/class-role-permissions.php' );

		// Privacy settings
		require_once( happyforms_get_include_folder() . '/classes/class-privacy-settings.php' );
	}

	public function load_translations() {
		$domains = array( 'happyforms', 'happyforms-upgrade' );

		foreach( $domains as $domain ) {
			$locale = apply_filters( 'plugin_locale', determine_locale(), $domain );
			$mofile = WP_LANG_DIR . '/plugins/' . $domain . '-' . $locale . '.mo';
			load_textdomain( 'happyforms-upgrade', $mofile );
			load_textdomain( 'happyforms', $mofile );
		}
	}

	public function admin_menu() {
		parent::admin_menu();

		global $submenu;

		if ( ! isset( $submenu['happyforms'] ) ) {
			return;
		}

		$submenu_links = wp_list_pluck( $submenu['happyforms'], 2 );
		$activity_index = array_search( 'edit.php?post_type=happyforms-message', $submenu_links );

		if ( false === $activity_index ) {
			return;
		}

		$submenu['happyforms'][$activity_index][0] .= happyforms_unread_messages_badge();
	}

	public function admin_screens() {
		parent::admin_screens();

		global $pagenow;

		$form_post_type = happyforms_get_form_controller()->post_type;
		$response_post_type = happyforms_get_message_controller()->post_type;
		$poll_post_type = happyforms_get_polls_controller()->post_type;
		$post_types = array( $form_post_type, $response_post_type, $poll_post_type );
		$current_post_type = get_current_screen()->post_type;

		if ( ! in_array( $pagenow, array( 'edit.php', 'post.php' ) )
			|| ! in_array( $current_post_type, $post_types ) ) {

			return;
		}

		switch( $current_post_type ) {
			case $form_post_type:
				require_once( happyforms_get_include_folder() . '/classes/class-form-admin-upgrade.php' );
				require_once( happyforms_get_include_folder() . '/classes/class-polls-admin.php' );
				break;
			case $response_post_type:
				if ( 'edit.php' === $pagenow ) {
					require_once( happyforms_get_include_folder() . '/classes/class-message-admin.php' );
				} else {
					require_once( happyforms_get_include_folder() . '/classes/class-message-admin-edit.php' );
				}
				break;
			case $poll_post_type:
				require_once( happyforms_get_include_folder() . '/classes/class-polls-admin.php' );
				break;
		}
	}

	public function admin_enqueue_scripts() {
		parent::admin_enqueue_scripts();

		wp_enqueue_style(
			'happyforms-admin-upgrade',
			happyforms_get_plugin_url() . 'inc/assets/css/admin.css',
			array( 'happyforms-admin' ), HAPPYFORMS_UPGRADE_VERSION
		);

		wp_enqueue_script(
			'happyforms-admin-upgrade',
			happyforms_get_plugin_url() . 'inc/assets/js/admin/dashboard.js',
			array( 'happyforms-admin' ), HAPPYFORMS_UPGRADE_VERSION, true
		);
	}

	public function enqueue_styles_preview() {
		parent::enqueue_styles_preview();

		if ( ! happyforms_is_preview() ) {
			return;
		}

		wp_enqueue_style(
			'happyforms-upgrade-preview',
			happyforms_get_plugin_url() . 'inc/assets/css/preview.css',
			array(), HAPPYFORMS_VERSION
		);
	}

	public function customize_enqueue_scripts( $deps ) {
		wp_enqueue_media();

		wp_enqueue_script(
			'happyforms-media-handle',
			happyforms_get_plugin_url() . 'inc/assets/js/customize/media.js',
			array( 'happyforms-customize' ),
			HAPPYFORMS_UPGRADE_VERSION,
			true
		);
	}

	public function set_frontend_stylesheets_url( $url ) {
		$url = happyforms_get_plugin_url() . 'inc/assets/css/frontend';

		return $url;
	}

	public function get_updater_banners( $banners ) {
		if ( ! $banners ) {
			$banners = array(
				'low' => 'https://happyforms.me/assets/img/plugin/banner-772x250.png',
				'high' => 'https://happyforms.me/assets/img/plugin/banner-1544x500.png',
			);
		}

		return $banners;
	}

	public function get_updater_icons( $icons ) {
		if ( ! $icons ) {
			$icons = array(
				'2x' => 'https://happyforms.me/assets/img/plugin/icon-256x256.png',
				'1x' => 'https://happyforms.me/assets/img/plugin/icon-128x128.png',
			);
		}

		return $icons;
	}

}
