( function( $, _, Backbone, api, settings ) {

	happyForms.classes.models.parts.address = happyForms.classes.models.Part.extend( {
		defaults: function() {
			return _.extend(
				{},
				settings.formParts.address.defaults,
				_.result( happyForms.classes.models.Part.prototype, 'defaults' ),
			);
		},
	} );

	happyForms.classes.views.parts.address = happyForms.classes.views.Part.extend( {
		template: '#happyforms-customize-address-template',

		events: _.extend( {}, happyForms.classes.views.Part.prototype.events, {
			'change [data-bind=apikey]': 'onApiKeyChange',
		} ),

		initialize: function() {
			happyForms.classes.views.Part.prototype.initialize.apply( this, arguments );

			this.listenTo( this.model, 'change:mode', this.onModeChange );
			this.listenTo( this.model, 'change:has_geolocation', this.onGeolocationChange );
		},

		toggleApiKey: function() {
			var $apiKeySettings = $( '.happyforms-nested-settings[data-trigger="has_geolocation"]', this.$el );

			if ( 'autocomplete' === this.model.get( 'mode' )
					|| this.model.get( 'has_geolocation' ) ) {
				$apiKeySettings.show();
			} else {
				$apiKeySettings.hide();
			}
		},

		onApiKeyChange: function( e ) {
			var data = {
				id: this.model.get( 'id' ),
				callback: 'onAddressApiKeyChange',
			};

			happyForms.previewSend( 'happyforms-part-dom-update', data );
		},

		onModeChange: function( model, value ) {
			this.toggleApiKey();

			var $labelPlacementSelect = this.$el.find('[data-bind=label_placement]');

			model.fetchHtml( function( response ) {
				var data = {
					id: model.get( 'id' ),
					html: response,
				};

				happyForms.previewSend( 'happyforms-form-part-refresh', data );
			} );
		},

		onGeolocationChange: function( e ) {
			var self = this;
			var model = this.model;

			this.toggleApiKey();

			this.model.fetchHtml( function( response ) {
				var data = {
					id: model.get( 'id' ),
					html: response,
				};

				happyForms.previewSend( 'happyforms-form-part-refresh', data );
			} );
		}
	} );

	happyForms.previewer = _.extend( happyForms.previewer, {
		onAddressApiKeyChange: function( id, html, options ) {
			var part = this.getPartModel( id );
			var $part = this.getPartElement( html );

			$part.attr( 'data-google-apikey', part.get( 'apikey' ) );
		},

		onAddressModeChangeCallback: function( id, html, options, $ ) {
			var part = this.getPartModel( id );
			var $part = $( html );

			$part.happyFormsAddressAutocomplete();
		}
	} );

} ) ( jQuery, _, Backbone, wp.customize, _happyFormsSettings );
