( function( $, settings ) {
	$( document ).ready( function() {
		var $el = $( '#happyforms-settings-screen' );

		if ( ! $el.length ) {
			return;
		}

		$( '.postbox button.handlediv', $el ).on( 'click', function( e ) {
			e.preventDefault();

			var $button = $( e.target );
			var $widget = $button.parents( '.postbox' );

			$widget.toggleClass( 'closed' );
		} );
	} );

	$( document ).on( 'click', '.postbox button.handlediv', function( e ) {
		var $button = $( this );
		var $section = $button.parents( '.postbox' );
		var sectionState = $section.hasClass( 'closed' ) ? 'closed': 'open';
		var sectionID = $section.attr( 'id' );

		$.post( ajaxurl, {
			action: 'happyforms-manage-admin-sections-states',
			section_id: sectionID,
			section_state: sectionState,
			nonce: settings.manage_sections_state_nonce
		} );
	} );

	$( document ).on( 'keydown', 'form input[type=text], form input[type=email], form input[type=password], form textarea', function( e ) {
		var $form = $( e.target ).parents( 'form' );

		if ( 'Tab' === e.key ) {
			return;
		}

		$form.trigger( 'happyforms.enable' );
	} );

	$( document ).on( 'click', 'form input[type=checkbox]', function( e ) {
		var $form = $( e.target ).parents( 'form' );

		$form.trigger( 'happyforms.enable' );
	} );

	$( document ).on( 'change', 'form select', function( e ) {
		var $form = $( e.target ).parents( 'form' );

		$form.trigger( 'happyforms.enable' );
	} );

	$( document ).on( 'submit', '#happyforms-settings-screen form.hf-ajax-submit', function( e ) {
		e.preventDefault();

		var $form    = $( e.target );
		var $wrapper = $form.parent();
		var $notices = $( '.happyforms-settings-notices', $wrapper );
		var $spinner = $( '.spinner', $wrapper );
		var $submit  = $( 'input[type=submit]', $wrapper );

		$submit.attr( 'disabled', 'disabled' );
		$form.trigger( 'happyforms.disable' );
		$spinner.css( 'visibility', 'visible' );

		$.post( ajaxurl, $form.serialize(), function( response ) {
			$submit.removeAttr( 'disabled' );
			$spinner.css( 'visibility', 'hidden' );

			if ( $form.hasClass( 'happyforms-updater-credentials' ) ) {
				$wrapper.html( response );

				return;
			}

			if ( response.hasOwnProperty( 'url' ) && response.url ) {
				window.location.href = response.url;
			} else {
				var data = response.data;

				if ( data.hasOwnProperty( 'html' ) && data.html ) {
					var $html = $( data.html );

					if ( $( 'form', $html ).length ) {
						$form.replaceWith( data.html );
						$form = $( data.html );
					}

					var id = $html.attr( 'id' );

					if ( 'happyforms-service-zapier' === id ) {
						$( '#happyforms-service-zapier' ).replaceWith( data.html );
					}
				}

				if ( data.hasOwnProperty( 'message' ) && data.message ) {
					var $notice = $( '<div />' ).addClass( 'notice' );

					var $p = $( '<p />' );
					$p.text( data.message ).appendTo( $notice );

					if ( response.success ) {
						$notice.addClass( 'notice-success' );
					} else {
						$notice.addClass( 'error' );
					}

					$notices.html( '' ).show();
					$notice.appendTo( $notices );

					setTimeout( function() {
						$notices.fadeOut();
					}, 3000 );
				}

				$form.trigger( 'happyforms.enable' );
			}
		} );
	} );

	$( document ).on( 'click', '.hf-hide-pw', function( e ) {
		e.preventDefault();

		var $button = $( e.target ).closest( 'button' );
		var $input  = $button.prev();
		var $icon   = $( '> .dashicons', $button );

		$input.click();

		setTimeout( function() {
			$input.select();
		}, 100 );

		var revealIconClass = 'dashicons-visibility';
		var hideIconClass   = 'dashicons-hidden';

		if ( 'password' === $input.attr( 'type' ) ) {
			$button.attr( 'aria-label', $button.attr( 'data-label-hide' ) );
			$input.attr( 'type', 'text' );
			$icon.removeClass( revealIconClass ).addClass( hideIconClass );
		} else {
			$button.attr( 'aria-label', $button.attr( 'data-label-show' ) );
			$input.attr( 'type', 'password' );
			$icon.removeClass( hideIconClass ).addClass( revealIconClass );
		}
	} );
} ) ( jQuery, _happyFormsAdminPagesConfig );
